/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app.viewer;

import java.util.EventListener;
import nextapp.echo.app.Component;
import nextapp.echo.app.Pane;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.extras.app.event.ViewerModelEvent;
import nextapp.echo.extras.app.event.ViewerModelListener;
import nextapp.echo.extras.app.viewer.AbstractViewerModel;
import nextapp.echo.extras.app.viewer.ViewerModel;

public abstract class Viewer
extends Component
implements Pane {
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    private ViewerModel model;
    private ViewerModelListener modelListener = new ViewerModelListener(){

        public void viewerChanged(ViewerModelEvent e) {
        }
    };

    public Viewer() {
        this(null);
    }

    public Viewer(ViewerModel model) {
        this.setModel(model == null ? new NullViewerModel() : model);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public ViewerModel getModel() {
        return this.model;
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setModel(ViewerModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Model may not be null.");
        }
        ViewerModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeViewerModelListener(this.modelListener);
        }
        newValue.addViewerModelListener(this.modelListener);
        this.model = newValue;
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    private class NullViewerModel
    extends AbstractViewerModel {
        private NullViewerModel() {
        }

        public Object get(int index) {
            return null;
        }

        public int size() {
            return 0;
        }
    }
}

