/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.filetransfer.app;

import java.util.EventListener;
import java.util.TooManyListenersException;
import nextapp.echo.app.Border;
import nextapp.echo.app.Component;
import nextapp.echo.app.Insets;
import nextapp.echo.filetransfer.app.event.UploadEvent;
import nextapp.echo.filetransfer.app.event.UploadListener;
import nextapp.echo.filetransfer.app.event.UploadProgressListener;
import nextapp.echo.filetransfer.model.Upload;
import nextapp.echo.filetransfer.model.UploadProcess;
import nextapp.echo.filetransfer.model.event.UploadProcessEvent;
import nextapp.echo.filetransfer.model.event.UploadProcessListener;

public abstract class AbstractUploadSelect
extends Component {
    public static final String UPLOAD_LISTENERS_CHANGED_PROPERTY = "uploadListeners";
    public static final String UPLOAD_PROGRESS_LISTENERS_CHANGED_PROPERTY = "uploadProgressListeners";
    public static final String INPUT_UPLOAD_SEND = "uploadSend";
    public static final String INPUT_UPLOAD_COMPLETE = "uploadComplete";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_BORDER = "border";
    private UploadProcessListener uploadProcessListener = new UploadProcessListener(){

        public void uploadCancel(UploadProcessEvent e) {
            AbstractUploadSelect.this.doUploadCancel(e.getUpload());
        }

        public void uploadComplete(UploadProcessEvent e) {
        }

        public void uploadProgress(UploadProcessEvent e) {
            AbstractUploadSelect.this.doUploadProgress(e.getUpload());
        }

        public void uploadStart(UploadProcessEvent e) {
            AbstractUploadSelect.this.doUploadStart(e.getUpload());
        }
    };
    private UploadProcess uploadProcess;

    public void addUploadListener(UploadListener l) {
        this.getEventListenerList().addListener(UploadListener.class, (EventListener)l);
        this.firePropertyChange(UPLOAD_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void addUploadProgressListener(UploadProgressListener l) {
        this.getEventListenerList().addListener(UploadProgressListener.class, (EventListener)l);
        this.firePropertyChange(UPLOAD_PROGRESS_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    public void cancel() {
        UploadProcess uploadProcess = this.uploadProcess;
        if (uploadProcess != null) {
            uploadProcess.cancel();
        }
    }

    public void doUploadCancel(Upload upload) {
        if (!this.hasUploadProgressListeners()) {
            return;
        }
        UploadEvent e = new UploadEvent((Object)this, upload);
        EventListener[] listeners = this.getEventListenerList().getListeners(UploadProgressListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((UploadProgressListener)listeners[i]).uploadCancel(e);
        }
    }

    public void doUploadComplete(Upload upload) {
        UploadEvent e = new UploadEvent((Object)this, upload);
        EventListener[] listeners = this.getEventListenerList().getListeners(UploadListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((UploadListener)listeners[i]).uploadComplete(e);
        }
    }

    public void doUploadSend() {
        EventListener[] listeners = this.getEventListenerList().getListeners(UploadListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((UploadListener)listeners[i]).uploadSend();
        }
    }

    public void doUploadProgress(Upload upload) {
        if (!this.hasUploadProgressListeners()) {
            return;
        }
        UploadEvent e = new UploadEvent((Object)this, upload);
        EventListener[] listeners = this.getEventListenerList().getListeners(UploadProgressListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((UploadProgressListener)listeners[i]).uploadProgress(e);
        }
    }

    public void doUploadStart(Upload upload) {
        if (!this.hasUploadProgressListeners()) {
            return;
        }
        UploadEvent e = new UploadEvent((Object)this, upload);
        EventListener[] listeners = this.getEventListenerList().getListeners(UploadProgressListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((UploadProgressListener)listeners[i]).uploadStart(e);
        }
    }

    public boolean hasUploadListeners() {
        return !this.hasEventListenerList() || this.getEventListenerList().getListenerCount(UploadListener.class) > 0;
    }

    public boolean hasUploadProgressListeners() {
        return !this.hasEventListenerList() || this.getEventListenerList().getListenerCount(UploadProgressListener.class) > 0;
    }

    public void processInput(String inputName, Object inputValue) {
        if (INPUT_UPLOAD_COMPLETE.equals(inputName)) {
            Upload[] uploads = (Upload[])inputValue;
            for (int i = 0; i < uploads.length; ++i) {
                this.doUploadComplete(uploads[i]);
            }
        } else if (INPUT_UPLOAD_SEND.equals(inputName)) {
            this.doUploadSend();
        }
    }

    public void removeUploadProgressListener(UploadProgressListener l) {
        if (this.hasEventListenerList()) {
            this.getEventListenerList().removeListener(UploadProgressListener.class, (EventListener)l);
        }
        this.firePropertyChange(UPLOAD_PROGRESS_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void removeUploadListener(UploadListener l) throws TooManyListenersException {
        if (this.hasEventListenerList()) {
            this.getEventListenerList().removeListener(UploadListener.class, (EventListener)l);
        }
        this.firePropertyChange(UPLOAD_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setUploadProcess(UploadProcess uploadProcess) {
        if (this.uploadProcess != null) {
            this.uploadProcess.removeProcessListener(this.uploadProcessListener);
        }
        this.uploadProcess = uploadProcess;
        if (this.uploadProcess != null) {
            this.uploadProcess.addProcessListener(this.uploadProcessListener);
        }
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }
}

