/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ResourceRegistry;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;

public class ResourceService
implements Service {
    public static final ResourceService INSTANCE = new ResourceService();
    private static final String PARAMETER_PACKAGE = "pkg";
    private static final String PARAMETER_RESOURCE = "res";

    private ResourceService() {
    }

    public String getId() {
        return "Echo.Resource";
    }

    public int getVersion() {
        return 0;
    }

    public void service(Connection conn) throws IOException {
        String resourceName;
        String packageId;
        ResourceRegistry registry = WebContainerServlet.getResourceRegistry();
        ContentType contentType = registry.getContentType(packageId = conn.getRequest().getParameter(PARAMETER_PACKAGE), resourceName = conn.getRequest().getParameter(PARAMETER_RESOURCE));
        if (contentType == null) {
            throw new IllegalArgumentException("Resource \"" + packageId + ":" + resourceName + "\" is not registered.");
        }
        conn.setContentType(contentType);
        String location = registry.getLocation(packageId, resourceName);
        InputStream in = ResourceService.class.getClassLoader().getResourceAsStream(location);
        if (in == null) {
            throw new IllegalArgumentException("Resource does not exist: \"" + resourceName + "\".  Looking in: \"" + location + "\".");
        }
        OutputStream out = conn.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        try {
            do {
                if ((bytesRead = in.read(buffer)) <= 0) continue;
                out.write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot get resource: \"" + resourceName + "\"."){

                public Throwable getCause() {
                    return ex;
                }
            };
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

