/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.module.struts.image;

import com.octo.captcha.module.config.CaptchaModuleConfigHelper;
import com.octo.captcha.module.struts.CaptchaServicePlugin;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RenderImageCaptchaAction
extends Action {
    private Log log = LogFactory.getLog((Class)(class$com$octo$captcha$module$struts$image$RenderImageCaptchaAction == null ? (class$com$octo$captcha$module$struts$image$RenderImageCaptchaAction = RenderImageCaptchaAction.class$("com.octo.captcha.module.struts.image.RenderImageCaptchaAction")) : class$com$octo$captcha$module$struts$image$RenderImageCaptchaAction));
    static /* synthetic */ Class class$com$octo$captcha$module$struts$image$RenderImageCaptchaAction;

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ImageCaptchaService service = (ImageCaptchaService)CaptchaServicePlugin.getInstance().getService();
        String captchaID = CaptchaModuleConfigHelper.getId((HttpServletRequest)httpServletRequest);
        byte[] captchaChallengeAsJpeg = null;
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage challenge = service.getImageChallengeForID(captchaID, httpServletRequest.getLocale());
            JPEGImageEncoder jpegEncoder = JPEGCodec.createJPEGEncoder((OutputStream)jpegOutputStream);
            jpegEncoder.encode(challenge);
        }
        catch (IllegalArgumentException e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("There was a try from " + httpServletRequest.getRemoteAddr() + " to render an URL without ID" + " or with a too long one"));
                httpServletResponse.sendError(404);
                this.log.error((Object)"should never pass here!");
                return actionMapping.findForward("error");
            }
        }
        catch (CaptchaServiceException e) {
            this.log.warn((Object)"Error trying to generate a captcha and render its challenge as JPEG", (Throwable)e);
            httpServletResponse.sendError(404);
            return actionMapping.findForward("error");
        }
        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaChallengeAsJpeg);
        responseOutputStream.flush();
        responseOutputStream.close();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

