/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.http.okhttp;

import com.google.auto.service.AutoService;
import com.okta.commons.http.RequestExecutor;
import com.okta.commons.http.RequestExecutorFactory;
import com.okta.commons.http.RetryRequestExecutor;
import com.okta.commons.http.config.HttpClientConfiguration;
import com.okta.commons.http.okhttp.OkHttpRequestExecutor;
import okhttp3.OkHttpClient;

@AutoService(value={RequestExecutorFactory.class})
public class OkHttpRequestExecutorFactory
implements RequestExecutorFactory {
    private final OkHttpClient client;

    public OkHttpRequestExecutorFactory() {
        this(null);
    }

    public OkHttpRequestExecutorFactory(OkHttpClient client) {
        this.client = client;
    }

    public RequestExecutor create(HttpClientConfiguration clientConfiguration) {
        OkHttpRequestExecutor executor;
        if (this.client != null) {
            OkHttpClient configuredClient = OkHttpRequestExecutor.configureOkHttpClient(clientConfiguration, this.client.newBuilder());
            executor = new OkHttpRequestExecutor(clientConfiguration, configuredClient);
        } else {
            executor = new OkHttpRequestExecutor(clientConfiguration);
        }
        return new RetryRequestExecutor(clientConfiguration, (RequestExecutor)executor);
    }
}

