/*
 * Decompiled with CFR 0.152.
 */
package com.okta.jwt.impl.http;

import com.okta.commons.lang.ApplicationInfo;
import com.okta.jwt.impl.http.HttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpClient
implements HttpClient {
    private static final String USER_AGENT = ApplicationInfo.get().entrySet().stream().map(entry -> (String)entry.getKey() + "/" + (String)entry.getValue()).collect(Collectors.joining(" "));
    private final okhttp3.OkHttpClient client;

    public OkHttpClient(Duration connectionTimeout, Duration readTimeout) {
        this.client = new OkHttpClient.Builder().connectTimeout(connectionTimeout.toMillis(), TimeUnit.MILLISECONDS).readTimeout(readTimeout.toMillis(), TimeUnit.MILLISECONDS).writeTimeout(readTimeout.toMillis(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).build();
    }

    @Override
    public InputStream get(URL url) throws IOException {
        ResponseBody body;
        Response response = this.client.newCall(new Request.Builder().url(url).header("User-Agent", USER_AGENT).build()).execute();
        if (response.isSuccessful() && (body = response.body()) != null) {
            return body.byteStream();
        }
        throw new IOException("GET request to '" + url + "' return invalid status of '" + response.code() + "' or had an empty response body.");
    }
}

