/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.client;

import com.ongres.scram.common.ClientFinalMessage;
import com.ongres.scram.common.ClientFirstMessage;
import com.ongres.scram.common.ScramFunctions;
import com.ongres.scram.common.ScramMechanism;
import com.ongres.scram.common.ServerFinalMessage;
import com.ongres.scram.common.ServerFirstMessage;
import com.ongres.scram.common.StringPreparation;
import com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.exception.ScramServerErrorException;
import com.ongres.scram.common.util.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClientFinalProcessor {
    private final byte[] clientKey;
    private final byte[] storedKey;
    private final byte[] serverKey;
    private final ScramMechanism scramMechanism;
    private final ClientFirstMessage clientFirstMessage;
    private final ServerFirstMessage serverFirstMessage;
    private String authMessage;

    private ClientFinalProcessor(ScramMechanism scramMechanism, byte[] clientKey, byte[] storedKey, byte[] serverKey, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this.scramMechanism = scramMechanism;
        this.clientKey = (byte[])Preconditions.checkNotNull((Object)clientKey, (String)"clientKey");
        this.storedKey = (byte[])Preconditions.checkNotNull((Object)storedKey, (String)"storedKey");
        this.serverKey = (byte[])Preconditions.checkNotNull((Object)serverKey, (String)"serverKey");
        this.clientFirstMessage = clientFirstMessage;
        this.serverFirstMessage = serverFirstMessage;
    }

    ClientFinalProcessor(ScramMechanism scramMechanism, byte[] clientKey, byte[] serverKey, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this(scramMechanism, clientKey, ScramFunctions.storedKey((ScramMechanism)scramMechanism, (byte[])clientKey), serverKey, clientFirstMessage, serverFirstMessage);
    }

    ClientFinalProcessor(ScramMechanism scramMechanism, byte[] saltedPassword, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this(scramMechanism, ScramFunctions.clientKey((ScramMechanism)scramMechanism, (byte[])saltedPassword), ScramFunctions.serverKey((ScramMechanism)scramMechanism, (byte[])saltedPassword), clientFirstMessage, serverFirstMessage);
    }

    ClientFinalProcessor(ScramMechanism scramMechanism, StringPreparation stringPreparation, char[] password, byte[] salt, ClientFirstMessage clientFirstMessage, ServerFirstMessage serverFirstMessage) {
        this(scramMechanism, ScramFunctions.saltedPassword((ScramMechanism)scramMechanism, (StringPreparation)stringPreparation, (char[])password, (byte[])salt, (int)serverFirstMessage.getIterationCount()), clientFirstMessage, serverFirstMessage);
    }

    private void generateAndCacheAuthMessage(byte[] cbindData) {
        if (null == this.authMessage) {
            this.authMessage = ScramFunctions.authMessage((ClientFirstMessage)this.clientFirstMessage, (ServerFirstMessage)this.serverFirstMessage, (byte[])cbindData);
        }
    }

    @NotNull
    ClientFinalMessage clientFinalMessage(byte @Nullable [] cbindData) {
        this.generateAndCacheAuthMessage(cbindData);
        return new ClientFinalMessage(this.clientFirstMessage.getGs2Header(), cbindData, this.serverFirstMessage.getNonce(), ScramFunctions.clientProof((byte[])this.clientKey, (byte[])ScramFunctions.clientSignature((ScramMechanism)this.scramMechanism, (byte[])this.storedKey, (String)this.authMessage)));
    }

    @NotNull
    ServerFinalMessage receiveServerFinalMessage(@NotNull String serverFinalMessage) throws ScramParseException, ScramServerErrorException, ScramInvalidServerSignatureException {
        Preconditions.checkNotEmpty((String)serverFinalMessage, (String)"serverFinalMessage");
        ServerFinalMessage message = ServerFinalMessage.parseFrom((String)serverFinalMessage);
        if (message.isError()) {
            throw new ScramServerErrorException(message.getServerError());
        }
        if (!ScramFunctions.verifyServerSignature((ScramMechanism)this.scramMechanism, (byte[])this.serverKey, (String)this.authMessage, (byte[])message.getVerifier())) {
            throw new ScramInvalidServerSignatureException("Invalid SCRAM server signature");
        }
        return message;
    }
}

