/*
 * Decompiled with CFR 0.152.
 */
package com.ongres.scram.common;

import com.ongres.scram.common.CharSupplier;
import com.ongres.scram.common.StringWritable;
import com.ongres.scram.common.util.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCharAttributeValue<T extends CharSupplier>
extends StringWritable {
    private final char charAttribute;
    @Nullable
    private final String value;

    protected AbstractCharAttributeValue(@NotNull T charAttribute, @Nullable String value) {
        if (null != value && value.isEmpty()) {
            throw new IllegalArgumentException("Value should be either null or non-empty");
        }
        this.charAttribute = ((CharSupplier)Preconditions.checkNotNull(charAttribute, "attribute")).getChar();
        this.value = value;
    }

    public final char getChar() {
        return this.charAttribute;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @Override
    StringBuilder writeTo(StringBuilder sb) {
        sb.append(this.charAttribute);
        if (null != this.value) {
            sb.append('=').append(this.value);
        }
        return sb;
    }
}

