/*
 * Copyright (C) 2016 - present by OpenGamma Inc. and the OpenGamma group of companies
 *
 * Please see distribution for license.
 */
package com.opengamma.strata.market.param;

import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

/**
 * Empty parameter metadata, used when there is no applicable metadata.
 */
@BeanDefinition(builderScope = "private")
final class EmptyParameterMetadata
    implements ParameterMetadata, ImmutableBean, Serializable {

  /**
   * The singleton instance.
   */
  private static final EmptyParameterMetadata INSTANCE = new EmptyParameterMetadata();

  /**
   * The description and identifier.
   */
  private static final String EMPTY = "";

  /**
   * Obtains the empty instance.
   * 
   * @return the metadata
   */
  static EmptyParameterMetadata empty() {
    return INSTANCE;
  }

  //-------------------------------------------------------------------------
  @Override
  public String getLabel() {
    return EMPTY;
  }

  /**
   * Returns an empty string.
   *
   * @return a simple identifier
   */
  @Override
  public String getIdentifier() {
    return EMPTY;
  }

  //------------------------- AUTOGENERATED START -------------------------
  /**
   * The meta-bean for {@code EmptyParameterMetadata}.
   * @return the meta-bean, not null
   */
  public static EmptyParameterMetadata.Meta meta() {
    return EmptyParameterMetadata.Meta.INSTANCE;
  }

  static {
    MetaBean.register(EmptyParameterMetadata.Meta.INSTANCE);
  }

  /**
   * The serialization version id.
   */
  private static final long serialVersionUID = 1L;

  private EmptyParameterMetadata() {
  }

  @Override
  public EmptyParameterMetadata.Meta metaBean() {
    return EmptyParameterMetadata.Meta.INSTANCE;
  }

  //-----------------------------------------------------------------------
  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj != null && obj.getClass() == this.getClass()) {
      return true;
    }
    return false;
  }

  @Override
  public int hashCode() {
    int hash = getClass().hashCode();
    return hash;
  }

  @Override
  public String toString() {
    StringBuilder buf = new StringBuilder(32);
    buf.append("EmptyParameterMetadata{");
    buf.append('}');
    return buf.toString();
  }

  //-----------------------------------------------------------------------
  /**
   * The meta-bean for {@code EmptyParameterMetadata}.
   */
  static final class Meta extends DirectMetaBean {
    /**
     * The singleton instance of the meta-bean.
     */
    static final Meta INSTANCE = new Meta();

    /**
     * The meta-properties.
     */
    private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap(
        this, null);

    /**
     * Restricted constructor.
     */
    private Meta() {
    }

    @Override
    public BeanBuilder<? extends EmptyParameterMetadata> builder() {
      return new EmptyParameterMetadata.Builder();
    }

    @Override
    public Class<? extends EmptyParameterMetadata> beanType() {
      return EmptyParameterMetadata.class;
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
      return metaPropertyMap$;
    }

    //-----------------------------------------------------------------------
  }

  //-----------------------------------------------------------------------
  /**
   * The bean-builder for {@code EmptyParameterMetadata}.
   */
  private static final class Builder extends DirectPrivateBeanBuilder<EmptyParameterMetadata> {

    /**
     * Restricted constructor.
     */
    private Builder() {
    }

    //-----------------------------------------------------------------------
    @Override
    public Object get(String propertyName) {
      throw new NoSuchElementException("Unknown property: " + propertyName);
    }

    @Override
    public Builder set(String propertyName, Object newValue) {
      throw new NoSuchElementException("Unknown property: " + propertyName);
    }

    @Override
    public EmptyParameterMetadata build() {
      return new EmptyParameterMetadata();
    }

    //-----------------------------------------------------------------------
    @Override
    public String toString() {
      return "EmptyParameterMetadata.Builder{}";
    }

  }

  //-------------------------- AUTOGENERATED END --------------------------
}
