/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.OutputDeviceGraphicsDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.simple.extend.ReplacedElementScaleHelper;
import com.openhtmltopdf.svgsupport.OpenHtmlDocumentLoader;
import com.openhtmltopdf.svgsupport.OpenHtmlGvtFontFamily;
import com.openhtmltopdf.svgsupport.OpenHtmlUserAgent;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.Document;

public class PDFTranscoder
extends SVGAbstractTranscoder {
    private OpenHtmlFontResolver fontResolver;
    private OutputDevice outputDevice;
    private double x;
    private double y;
    private final Box box;
    private RenderingContext ctx;
    private final double dotsPerPixel;
    private boolean allowScripts = false;
    private boolean allowExternalResources = false;
    private UserAgentCallback userAgentCallback;
    private Set<String> allowedProtocols;

    public PDFTranscoder(Box box, double dotsPerPixel, double width, double height) {
        this.box = box;
        this.width = (float)width;
        this.height = (float)height;
        this.dotsPerPixel = dotsPerPixel;
    }

    public void setRenderingParameters(OutputDevice od, RenderingContext ctx, double x, double y, OpenHtmlFontResolver fontResolver, UserAgentCallback userAgentCallback) {
        this.x = x;
        this.y = y;
        this.outputDevice = od;
        this.ctx = ctx;
        this.fontResolver = fontResolver;
        this.userAgentCallback = userAgentCallback;
    }

    public void setImageSize(float docWidth, float docHeight) {
        super.setImageSize(docWidth, docHeight);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setSecurityOptions(boolean allowScripts, boolean allowExternalResources, Set<String> allowedProtocols) {
        this.allowScripts = allowScripts;
        this.allowExternalResources = allowExternalResources;
        this.allowedProtocols = allowedProtocols;
    }

    protected BridgeContext createBridgeContext(String svgVersion) {
        if ("1.2".equals(svgVersion)) {
            return new SVG12BridgeContext(this.userAgent, (DocumentLoader)new OpenHtmlDocumentLoader(this.userAgent, this.userAgentCallback));
        }
        return new BridgeContext(this.userAgent, (DocumentLoader)new OpenHtmlDocumentLoader(this.userAgent, this.userAgentCallback));
    }

    protected void transcode(Document svg, String uri, TranscoderOutput out) throws TranscoderException {
        this.userAgent = new OpenHtmlUserAgent(this.fontResolver, this.allowScripts, this.allowExternalResources, this.allowedProtocols);
        super.transcode(svg, uri, out);
        Rectangle contentBounds = this.box.getContentAreaEdge(this.box.getAbsX(), this.box.getAbsY(), (CssContext)this.ctx);
        final AffineTransform scale2 = ReplacedElementScaleHelper.createScaleTransform((double)this.dotsPerPixel, (Rectangle)contentBounds, (float)this.width, (float)this.height);
        final AffineTransform inverse2 = ReplacedElementScaleHelper.inverseOrNull((AffineTransform)scale2);
        final boolean transformed2 = scale2 != null && inverse2 != null;
        this.outputDevice.drawWithGraphics((float)this.x, (float)this.y, (float)((double)contentBounds.width / this.dotsPerPixel), (float)((double)contentBounds.height / this.dotsPerPixel), new OutputDeviceGraphicsDrawer(){

            public void render(Graphics2D graphics2D) {
                if (transformed2) {
                    graphics2D.transform(scale2);
                }
                PDFTranscoder.this.root.paint(graphics2D);
                if (transformed2) {
                    graphics2D.transform(inverse2);
                }
            }
        });
    }

    protected UserAgent createUserAgent() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return new ErrorHandler(){

            public void warning(TranscoderException arg0) throws TranscoderException {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_SVG_ERROR_HANDLER, (Object)"WARN", (Throwable)arg0);
            }

            public void fatalError(TranscoderException arg0) throws TranscoderException {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_SVG_ERROR_HANDLER, (Object)"FATAL", (Throwable)arg0);
            }

            public void error(TranscoderException arg0) throws TranscoderException {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_SVG_ERROR_HANDLER, (Object)"ERROR", (Throwable)arg0);
            }
        };
    }

    public static class OpenHtmlFontResolver
    implements FontFamilyResolver {
        private final Map<String, OpenHtmlGvtFontFamily> families = new HashMap<String, OpenHtmlGvtFontFamily>(4);

        public GVTFontFamily resolve(String arg0, FontFace arg1) {
            return null;
        }

        public GVTFontFamily resolve(String family) {
            if (this.families.containsKey(family)) {
                return this.families.get(family);
            }
            return null;
        }

        public GVTFontFamily loadFont(InputStream arg0, FontFace arg1) throws Exception {
            return null;
        }

        public GVTFontFamily getFamilyThatCanDisplay(char arg0) {
            return null;
        }

        public GVTFontFamily getDefault() {
            return null;
        }

        private Float getStyle(IdentValue fontStyle) {
            if (fontStyle == IdentValue.ITALIC || fontStyle == IdentValue.OBLIQUE) {
                return TextAttribute.POSTURE_OBLIQUE;
            }
            return null;
        }

        private Float getStyle(BaseRendererBuilder.FontStyle style) {
            switch (style) {
                case ITALIC: 
                case OBLIQUE: {
                    return TextAttribute.POSTURE_OBLIQUE;
                }
            }
            return Float.valueOf(0.0f);
        }

        private Float getWeight(Integer weight) {
            if (weight == null) {
                return null;
            }
            switch (weight) {
                case 100: {
                    return TextAttribute.WEIGHT_EXTRA_LIGHT;
                }
                case 200: 
                case 300: {
                    return TextAttribute.WEIGHT_LIGHT;
                }
                case 400: {
                    return TextAttribute.WEIGHT_REGULAR;
                }
                case 500: 
                case 600: {
                    return TextAttribute.WEIGHT_SEMIBOLD;
                }
                case 700: {
                    return TextAttribute.WEIGHT_BOLD;
                }
                case 800: {
                    return TextAttribute.WEIGHT_EXTRABOLD;
                }
                case 900: {
                    return TextAttribute.WEIGHT_ULTRABOLD;
                }
            }
            return null;
        }

        private Float getWeight(IdentValue weight) {
            if (weight == IdentValue.NORMAL) {
                return TextAttribute.WEIGHT_REGULAR;
            }
            if (weight == IdentValue.BOLD) {
                return TextAttribute.WEIGHT_BOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_100) {
                return TextAttribute.WEIGHT_EXTRA_LIGHT;
            }
            if (weight == IdentValue.FONT_WEIGHT_200) {
                return TextAttribute.WEIGHT_LIGHT;
            }
            if (weight == IdentValue.FONT_WEIGHT_300) {
                return TextAttribute.WEIGHT_LIGHT;
            }
            if (weight == IdentValue.FONT_WEIGHT_400) {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            if (weight == IdentValue.FONT_WEIGHT_500) {
                return TextAttribute.WEIGHT_SEMIBOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_600) {
                return TextAttribute.WEIGHT_SEMIBOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_700) {
                return TextAttribute.WEIGHT_BOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_800) {
                return TextAttribute.WEIGHT_EXTRABOLD;
            }
            if (weight == IdentValue.FONT_WEIGHT_900) {
                return TextAttribute.WEIGHT_ULTRABOLD;
            }
            if (weight == IdentValue.LIGHTER) {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            if (weight == IdentValue.BOLDER) {
                return TextAttribute.WEIGHT_MEDIUM;
            }
            return null;
        }

        private void addFontFaceFont(String fontFamilyNameOverride, IdentValue fontWeightOverride, IdentValue fontStyleOverride, String uri, byte[] font1) throws FontFormatException {
            OpenHtmlGvtFontFamily family;
            if (this.families.containsKey(fontFamilyNameOverride)) {
                family = this.families.get(fontFamilyNameOverride);
            } else {
                family = new OpenHtmlGvtFontFamily(fontFamilyNameOverride);
                this.families.put(fontFamilyNameOverride, family);
            }
            family.addFont(font1, 1.0f, this.getWeight(fontWeightOverride), this.getStyle(fontStyleOverride));
        }

        public void importFontFaces(List<FontFaceRule> fontFaces, SharedContext ctx) {
            for (FontFaceRule rule : fontFaces) {
                CalculatedStyle style = rule.getCalculatedStyle();
                FSDerivedValue src = style.valueByName(CSSName.SRC);
                if (src == IdentValue.NONE) continue;
                byte[] font1 = ctx.getUserAgentCallback().getBinaryResource(src.asString());
                if (font1 == null) {
                    XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_COULD_NOT_LOAD_FONT, (Object)src.asString());
                    continue;
                }
                String fontFamily = null;
                IdentValue fontWeight = null;
                IdentValue fontStyle = null;
                if (rule.hasFontFamily()) {
                    fontFamily = style.valueByName(CSSName.FONT_FAMILY).asString();
                }
                if (rule.hasFontWeight()) {
                    fontWeight = style.getIdent(CSSName.FONT_WEIGHT);
                }
                if (rule.hasFontStyle()) {
                    fontStyle = style.getIdent(CSSName.FONT_STYLE);
                }
                try {
                    this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), font1);
                }
                catch (FontFormatException e) {
                    XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_SVG_COULD_NOT_READ_FONT, (Throwable)e);
                }
            }
        }

        public void addFontFile(File fontFile, String family, Integer weight, BaseRendererBuilder.FontStyle style) throws IOException, FontFormatException {
            OpenHtmlGvtFontFamily fontFamily = this.families.computeIfAbsent(family, fam -> new OpenHtmlGvtFontFamily((String)fam));
            fontFamily.addFont(fontFile, 12.0f, this.getWeight(weight), this.getStyle(style));
        }
    }
}

