/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.exceptions.ResponseNotReceivedException;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;

public class WaitState {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean connected = true;
    private boolean waitEvents = false;
    private boolean captureIdleEvents = false;
    private int capturedIdleEvents = 0;
    private final Object lock = new Object();
    private String profile;
    LinkedList<ResultItem> events = new LinkedList();

    public void setWaitEvents(boolean wait_events) {
        this.waitEvents = wait_events;
    }

    private void internalWait(long timeout) throws WebDriverException {
        try {
            if (!this.connected) {
                throw new CommunicationException("Waiting aborted - not connected!");
            }
            this.lock.wait(timeout);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHandshake() {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onHandshake");
            this.events.add(new ResultItem(WaitResult.HANDSHAKE));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResponse(int tag, UmsProtos.Response response) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onResponse for " + tag);
            this.events.add(new ResultItem(response, tag));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onError(int tag) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.fine("Got ERROR for " + tag);
            this.events.add(new ResultItem(WaitResult.ERROR, tag));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onException(Exception e) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.warning("Got exception");
            this.events.add(new ResultItem(new WebDriverException((Throwable)e)));
            this.connected = false;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDisconnected() {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onDisconnected");
            this.events.add(new ResultItem(WaitResult.DISCONNECTED));
            this.connected = false;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWindowLoaded(int windowId) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onWindowLoaded");
            this.events.add(new ResultItem(WaitResult.EVENT_WINDOW_LOADED, windowId));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequest(int windowId) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onRequest");
            this.events.add(new ResultItem(WaitResult.EVENT_REQUEST_FIRED, windowId));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWindowClosed(int windowId) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onWindowClosed");
            this.events.add(new ResultItem(WaitResult.EVENT_WINDOW_CLOSED, windowId));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOperaIdle() {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onOperaIdle");
            this.events.add(new ResultItem(WaitResult.EVENT_OPERA_IDLE, 0));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDesktopWindowClosed(DesktopWmProtos.DesktopWindowInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onDesktopWindowClosed");
            this.events.add(new ResultItem(WaitResult.EVENT_DESKTOP_WINDOW_CLOSED, info));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDesktopWindowActivated(DesktopWmProtos.DesktopWindowInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onDesktopWindowActivated");
            this.events.add(new ResultItem(WaitResult.EVENT_DESKTOP_WINDOW_ACTIVATED, info));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDesktopWindowShown(DesktopWmProtos.DesktopWindowInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onDesktopWindowShown");
            this.events.add(new ResultItem(WaitResult.EVENT_DESKTOP_WINDOW_SHOWN, info));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDesktopWindowUpdated(DesktopWmProtos.DesktopWindowInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onDesktopWindowUpdated");
            this.events.add(new ResultItem(WaitResult.EVENT_DESKTOP_WINDOW_UPDATED, info));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDesktopWindowLoaded(DesktopWmProtos.DesktopWindowInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onDesktopWindowLoaded");
            this.events.add(new ResultItem(WaitResult.EVENT_DESKTOP_WINDOW_LOADED, info));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQuickMenuShown(DesktopWmProtos.QuickMenuInfo info) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onQuickMenuShown");
            this.events.add(new ResultItem(WaitResult.EVENT_QUICK_MENU_SHOWN, info));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQuickMenuClosed(DesktopWmProtos.QuickMenuID id) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onQuickMenuClosed");
            this.events.add(new ResultItem(WaitResult.EVENT_QUICK_MENU_CLOSED, id));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQuickMenuItemPressed(DesktopWmProtos.QuickMenuItemID menuItemID) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onQuickMenuItemPressed");
            this.events.add(new ResultItem(WaitResult.EVENT_QUICK_MENU_ITEM_PRESSED, menuItemID));
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSelftestDone(String results) {
        Object object = this.lock;
        synchronized (object) {
            this.logger.finest("Event: onSelftestDone");
            this.events.add(new ResultItem(results));
            this.lock.notify();
        }
    }

    private ResultItem getResult() {
        if (this.events.isEmpty()) {
            return null;
        }
        if (this.waitEvents) {
            ResultItem result_item = this.events.getFirst();
            while (true) {
                if (!result_item.isEventToWaitFor()) {
                    this.events.remove(result_item);
                    return result_item;
                }
                if (!result_item.wasSeen()) {
                    result_item.seen = true;
                    return result_item;
                }
                int index = this.events.indexOf(result_item);
                if (index + 1 >= this.events.size()) {
                    return null;
                }
                result_item = this.events.get(index + 1);
            }
        }
        return this.events.removeFirst();
    }

    private final ResultItem pollResultItem(long timeout, boolean idle) {
        ResultItem result = this.getResult();
        if (result != null) {
            result.remainingIdleTimeout = timeout;
        }
        if (result == null && timeout > 0L) {
            long start = System.currentTimeMillis();
            this.internalWait(timeout);
            long end = System.currentTimeMillis();
            result = this.getResult();
            if (result != null) {
                result.remainingIdleTimeout = timeout - (end - start);
                this.logger.finest("Remaining timeout: " + result.remainingIdleTimeout);
            }
        }
        if (result == null) {
            if (idle) {
                throw new ResponseNotReceivedException("No idle response in a timely fashion");
            }
            throw new ResponseNotReceivedException("No response in a timely fashion");
        }
        return result;
    }

    private final ResultItem waitAndParseResult(long timeout, int match, String stringMatch, ResponseType type) {
        if (this.profile != null && this.profile.toLowerCase().equals("desktop") && type == ResponseType.WINDOW_LOADED && timeout < 30000L) {
            long newTimeout = 30000L;
            this.logger.warning("WARNING: desktop-specific workaround for waitAndParseResult.  Changing timeout from " + timeout + " to " + newTimeout);
            timeout = newTimeout;
        }
        Object object = this.lock;
        synchronized (object) {
            block23: while (true) {
                ResultItem result = this.pollResultItem(timeout, type == ResponseType.OPERA_IDLE);
                timeout = result.remainingIdleTimeout;
                WaitResult waitResult = result.waitResult;
                switch (waitResult) {
                    case HANDSHAKE: {
                        if (type != ResponseType.HANDSHAKE) break;
                        return null;
                    }
                    case RESPONSE: {
                        if (result.data == match && type == ResponseType.RESPONSE) {
                            return result;
                        }
                        if (type != ResponseType.HANDSHAKE) break;
                        throw new CommunicationException("Expecting handshake");
                    }
                    case ERROR: {
                        if (result.data == match && type == ResponseType.RESPONSE) {
                            return null;
                        }
                        if (type != ResponseType.HANDSHAKE) break;
                        throw new CommunicationException("Expecting handshake");
                    }
                    case EXCEPTION: {
                        throw result.exception;
                    }
                    case DISCONNECTED: {
                        throw new CommunicationException("Problem encountered : " + waitResult.toString());
                    }
                    case EVENT_WINDOW_LOADED: {
                        if (result.data != match || type != ResponseType.WINDOW_LOADED) continue block23;
                        return null;
                    }
                    case EVENT_WINDOW_CLOSED: {
                        if (result.data != match || type != ResponseType.WINDOW_LOADED) continue block23;
                        throw new CommunicationException("Window closed unexpectedly");
                    }
                    case EVENT_DESKTOP_WINDOW_SHOWN: {
                        if (type != ResponseType.DESKTOP_WINDOW_SHOWN) break;
                        if (stringMatch.length() == 0) {
                            return result;
                        }
                        this.logger.finest("EVENT_DESKTOP_WINDOW_SHOWN: Name: " + result.desktopWindowInfo.getName() + " ID: " + result.desktopWindowInfo.getWindowID() + " OnScreen: " + result.desktopWindowInfo.getOnScreen());
                        if (!result.desktopWindowInfo.getName().equals(stringMatch)) break;
                        return result;
                    }
                    case EVENT_DESKTOP_WINDOW_UPDATED: {
                        if (type != ResponseType.DESKTOP_WINDOW_UPDATED) break;
                        if (stringMatch.length() == 0) {
                            return result;
                        }
                        this.logger.fine("EVENT_DESKTOP_WINDOW_UPDATED: Name: " + result.desktopWindowInfo.getName() + " ID: " + result.desktopWindowInfo.getWindowID());
                        if (!result.desktopWindowInfo.getName().equals(stringMatch)) break;
                        return result;
                    }
                    case EVENT_DESKTOP_WINDOW_ACTIVATED: {
                        if (type != ResponseType.DESKTOP_WINDOW_ACTIVATED) break;
                        if (stringMatch.length() == 0) {
                            return result;
                        }
                        this.logger.fine("DESKTOP_WINDOW_ACTIVATED: Name: " + result.desktopWindowInfo.getName() + " ID: " + result.desktopWindowInfo.getWindowID());
                        if (!result.desktopWindowInfo.getName().equals(stringMatch)) break;
                        return result;
                    }
                    case EVENT_DESKTOP_WINDOW_CLOSED: {
                        if (type != ResponseType.DESKTOP_WINDOW_CLOSED) break;
                        if (stringMatch.length() == 0) {
                            return result;
                        }
                        this.logger.fine("EVENT_DESKTOP_WINDOW_CLOSED: Name: " + result.desktopWindowInfo.getName() + " ID: " + result.desktopWindowInfo.getWindowID());
                        if (!result.desktopWindowInfo.getName().equals(stringMatch)) break;
                        return result;
                    }
                    case EVENT_DESKTOP_WINDOW_LOADED: {
                        if (type != ResponseType.DESKTOP_WINDOW_LOADED) break;
                        if (stringMatch.length() == 0) {
                            return result;
                        }
                        this.logger.fine("EVENT_DESKTOP_WINDOW_LOADED: Name: " + result.desktopWindowInfo.getName() + " ID: " + result.desktopWindowInfo.getWindowID());
                        if (!result.desktopWindowInfo.getName().equals(stringMatch)) break;
                        return result;
                    }
                    case EVENT_QUICK_MENU_SHOWN: {
                        if (type != ResponseType.QUICK_MENU_SHOWN) break;
                        if (stringMatch.length() == 0) {
                            return result;
                        }
                        this.logger.fine("EVENT_QUICK_MENU_SHOWN: Name: " + result.quickMenuInfo.getMenuId().getMenuName());
                        if (!result.quickMenuInfo.getMenuId().getMenuName().equals(stringMatch)) break;
                        return result;
                    }
                    case EVENT_QUICK_MENU_CLOSED: {
                        if (type != ResponseType.QUICK_MENU_CLOSED) break;
                        if (stringMatch != null && stringMatch.length() == 0) {
                            return result;
                        }
                        if (!result.quickMenuId.getMenuName().equals(stringMatch)) break;
                        stringMatch = "";
                        return result;
                    }
                    case EVENT_QUICK_MENU_ITEM_PRESSED: {
                        if (type != ResponseType.QUICK_MENU_ITEM_PRESSED) break;
                        if (stringMatch.length() == 0) {
                            return result;
                        }
                        this.logger.fine("QUICK_MENU_ITEM_PRESSED: Text: " + result.quickMenuItemID.getMenuText());
                        if (!result.quickMenuItemID.getMenuText().equals(stringMatch)) break;
                        return result;
                    }
                    case EVENT_REQUEST_FIRED: {
                        if (result.data != match || type != ResponseType.REQUEST_FIRED) continue block23;
                        return null;
                    }
                    case EVENT_OPERA_IDLE: {
                        this.logger.finest("RECV EVENT_OPERA_IDLE!");
                        if (result.data != match || type != ResponseType.OPERA_IDLE) continue block23;
                        return null;
                    }
                    case EVENT_SELFTEST_DONE: {
                        this.logger.finest("RECV EVENT_SELFTEST_DONE");
                        if (type != ResponseType.SELFTEST_DONE) break;
                        return result;
                    }
                }
            }
        }
    }

    public void waitForHandshake(long value) {
        this.waitAndParseResult(value, 0, null, ResponseType.HANDSHAKE);
    }

    public void waitForWindowLoaded(int windowId, long timeout) {
        this.waitAndParseResult(timeout, windowId, null, ResponseType.WINDOW_LOADED);
    }

    public void captureOperaIdle() {
        this.logger.finer("captureIdleEvents is now true!");
        this.captureIdleEvents = true;
    }

    public void waitForOperaIdle(long timeout) {
        if (this.captureIdleEvents && this.capturedIdleEvents > 0) {
            this.logger.finer("Captured " + this.capturedIdleEvents + " OperaIdle event(s)");
            this.captureIdleEvents = false;
            this.capturedIdleEvents = 0;
            return;
        }
        this.captureIdleEvents = false;
        this.waitAndParseResult(timeout, 0, null, ResponseType.OPERA_IDLE);
    }

    public UmsProtos.Response waitFor(int tag, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, tag, null, ResponseType.RESPONSE);
        if (item != null) {
            return item.response;
        }
        return null;
    }

    public void waitForRequest(int windowId, long timeout) {
        this.waitAndParseResult(timeout, windowId, null, ResponseType.REQUEST_FIRED);
    }

    public int waitForDesktopWindowShown(String win_name, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, win_name, ResponseType.DESKTOP_WINDOW_SHOWN);
        if (item != null) {
            return item.desktopWindowInfo.getWindowID();
        }
        return 0;
    }

    public int waitForDesktopWindowUpdated(String win_name, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, win_name, ResponseType.DESKTOP_WINDOW_UPDATED);
        if (item != null) {
            return item.desktopWindowInfo.getWindowID();
        }
        return 0;
    }

    public int waitForDesktopWindowActivated(String win_name, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, win_name, ResponseType.DESKTOP_WINDOW_ACTIVATED);
        if (item != null) {
            return item.desktopWindowInfo.getWindowID();
        }
        return 0;
    }

    public int waitForDesktopWindowClosed(String win_name, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, win_name, ResponseType.DESKTOP_WINDOW_CLOSED);
        if (item != null) {
            return item.desktopWindowInfo.getWindowID();
        }
        return 0;
    }

    public int waitForDesktopWindowLoaded(String win_name, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, win_name, ResponseType.DESKTOP_WINDOW_LOADED);
        if (item != null) {
            return item.desktopWindowInfo.getWindowID();
        }
        return 0;
    }

    public String waitForQuickMenuShown(String menuName, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, menuName, ResponseType.QUICK_MENU_SHOWN);
        if (item != null) {
            return item.quickMenuInfo.getMenuId().getMenuName();
        }
        return "";
    }

    public String waitForQuickMenuClosed(String menuName, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, menuName, ResponseType.QUICK_MENU_CLOSED);
        if (item != null) {
            return item.quickMenuId.getMenuName();
        }
        return "";
    }

    public String waitForQuickMenuItemPressed(String menuItemText, long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, menuItemText, ResponseType.QUICK_MENU_ITEM_PRESSED);
        if (item != null) {
            return item.quickMenuItemID.getMenuText();
        }
        return "";
    }

    public String waitForSelftestDone(long timeout) {
        ResultItem item = this.waitAndParseResult(timeout, 0, null, ResponseType.SELFTEST_DONE);
        if (item != null) {
            return item.selftestResults;
        }
        return null;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResponseType {
        HANDSHAKE,
        RESPONSE,
        WINDOW_LOADED,
        REQUEST_FIRED,
        OPERA_IDLE,
        DESKTOP_WINDOW_SHOWN,
        DESKTOP_WINDOW_UPDATED,
        DESKTOP_WINDOW_ACTIVATED,
        DESKTOP_WINDOW_CLOSED,
        DESKTOP_WINDOW_LOADED,
        QUICK_MENU_SHOWN,
        QUICK_MENU_CLOSED,
        QUICK_MENU_ITEM_PRESSED,
        SELFTEST_DONE;

    }

    private class ResultItem {
        int data;
        WaitResult waitResult;
        WebDriverException exception;
        UmsProtos.Response response;
        boolean seen;
        long remainingIdleTimeout;
        DesktopWmProtos.DesktopWindowInfo desktopWindowInfo;
        private DesktopWmProtos.QuickMenuInfo quickMenuInfo;
        private DesktopWmProtos.QuickMenuID quickMenuId;
        private DesktopWmProtos.QuickMenuItemID quickMenuItemID;
        String selftestResults;

        public ResultItem(WebDriverException ex) {
            this.waitResult = WaitResult.EXCEPTION;
            this.exception = ex;
            WaitState.this.logger.finest("EVENT: " + this.waitResult.toString() + ", exception: " + ex.toString());
        }

        public ResultItem(WaitResult result) {
            this.waitResult = result;
            WaitState.this.logger.finest("EVENT: " + result.toString());
        }

        public ResultItem(WaitResult result, int data) {
            this.waitResult = result;
            this.data = data;
            WaitState.this.logger.finest("EVENT: " + result.toString() + ", data=" + data);
        }

        public ResultItem(WaitResult result, DesktopWmProtos.DesktopWindowInfo info) {
            this.waitResult = result;
            this.desktopWindowInfo = info;
            WaitState.this.logger.finest("EVENT: " + result.toString() + ", desktop window=" + info.getWindowID());
        }

        public ResultItem(WaitResult result, DesktopWmProtos.QuickMenuInfo info) {
            this.waitResult = result;
            this.quickMenuInfo = info;
            WaitState.this.logger.finest("EVENT: " + result.toString() + ", quick_menu=" + info.getMenuId().getMenuName());
        }

        public ResultItem(WaitResult result, DesktopWmProtos.QuickMenuID id) {
            this.waitResult = result;
            this.quickMenuId = id;
            WaitState.this.logger.finest("EVENT: " + result.toString() + ", quick_menu=" + id.getMenuName());
        }

        public ResultItem(WaitResult result, DesktopWmProtos.QuickMenuItemID info) {
            this.waitResult = result;
            this.quickMenuItemID = info;
            WaitState.this.logger.finest("EVENT: " + result.toString() + ", quick_menu_item=" + info.getMenuText());
        }

        public ResultItem(UmsProtos.Response response, int tag) {
            this.response = response;
            this.data = tag;
            this.waitResult = WaitResult.RESPONSE;
            WaitState.this.logger.finest("EVENT: " + this.waitResult.toString() + ", data=" + this.data);
        }

        public ResultItem(String results) {
            this.waitResult = WaitResult.EVENT_SELFTEST_DONE;
            this.selftestResults = results;
        }

        public boolean isEventToWaitFor() {
            switch (this.waitResult) {
                case EVENT_DESKTOP_WINDOW_ACTIVATED: 
                case EVENT_DESKTOP_WINDOW_CLOSED: 
                case EVENT_DESKTOP_WINDOW_UPDATED: 
                case EVENT_DESKTOP_WINDOW_SHOWN: 
                case EVENT_DESKTOP_WINDOW_LOADED: 
                case EVENT_QUICK_MENU_SHOWN: 
                case EVENT_QUICK_MENU_CLOSED: 
                case EVENT_QUICK_MENU_ITEM_PRESSED: 
                case EVENT_SELFTEST_DONE: {
                    return true;
                }
            }
            return false;
        }

        public boolean wasSeen() {
            return this.seen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WaitResult {
        RESPONSE,
        ERROR,
        EXCEPTION,
        DISCONNECTED,
        HANDSHAKE,
        EVENT_WINDOW_LOADED,
        EVENT_WINDOW_CLOSED,
        EVENT_OPERA_IDLE,
        EVENT_DESKTOP_WINDOW_SHOWN,
        EVENT_DESKTOP_WINDOW_CLOSED,
        EVENT_DESKTOP_WINDOW_ACTIVATED,
        EVENT_DESKTOP_WINDOW_UPDATED,
        EVENT_DESKTOP_WINDOW_LOADED,
        EVENT_REQUEST_FIRED,
        EVENT_QUICK_MENU_SHOWN,
        EVENT_QUICK_MENU_CLOSED,
        EVENT_QUICK_MENU_ITEM_PRESSED,
        EVENT_SELFTEST_DONE;

    }
}

