/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.SystemInputCommand;
import com.opera.core.systems.scope.protos.SystemInputProtos;
import com.opera.core.systems.scope.services.ISystemInput;
import java.awt.Point;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInputManager
extends AbstractService
implements ISystemInput {
    SystemInputManager(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "system-input";
        if (!this.isVersionInRange(version, "2.0", serviceName)) {
            throw new UnsupportedOperationException(serviceName + " version " + version + " is not supported");
        }
        services.setSystemInputManager(this);
    }

    public void init() {
    }

    @Override
    public void click(Point location, SystemInputProtos.MouseInfo.MouseButton button, int numClicks, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(numClicks);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeCommand(SystemInputCommand.CLICK, (AbstractMessage.Builder<?>)actionBuilder.clone());
    }

    @Override
    public void mouseMove(Point location, SystemInputProtos.MouseInfo.MouseButton button, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(1);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeCommand(SystemInputCommand.MOUSEMOVE, (AbstractMessage.Builder<?>)actionBuilder.clone());
    }

    @Override
    public void mouseUp(Point location, SystemInputProtos.MouseInfo.MouseButton button, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(1);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeCommand(SystemInputCommand.MOUSEUP, (AbstractMessage.Builder<?>)actionBuilder.clone());
    }

    @Override
    public void mouseDown(Point location, SystemInputProtos.MouseInfo.MouseButton button, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(1);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeCommand(SystemInputCommand.MOUSEDOWN, (AbstractMessage.Builder<?>)actionBuilder.clone());
    }

    @Override
    public void keyPress(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.KeyPressInfo.Builder actionBuilder = SystemInputProtos.KeyPressInfo.newBuilder();
        actionBuilder.setKey(key);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeCommand(SystemInputCommand.KEYPRESS, (AbstractMessage.Builder<?>)actionBuilder.clone());
    }

    @Override
    public void keyDown(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.KeyPressInfo.Builder actionBuilder = SystemInputProtos.KeyPressInfo.newBuilder();
        actionBuilder.setKey(key);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeCommand(SystemInputCommand.KEYDOWN, (AbstractMessage.Builder<?>)actionBuilder.clone());
    }

    @Override
    public void keyUp(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.KeyPressInfo.Builder actionBuilder = SystemInputProtos.KeyPressInfo.newBuilder();
        actionBuilder.setKey(key);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeCommand(SystemInputCommand.KEYUP, (AbstractMessage.Builder<?>)actionBuilder.clone());
    }
}

