/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.util;

import com.opera.core.systems.util.SocketListener;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketMonitor {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Selector selector;
    boolean locked = false;
    private LinkedList<SelectorChangeRequest> changes = new LinkedList();

    public SocketMonitor() {
        try {
            this.selector = SelectorProvider.provider().openSelector();
            this.logger.setLevel(Level.OFF);
            this.logger.severe("Starting up...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(SelectableChannel channel, SocketListener listener, int selectMask) {
        this.logger.info("Add channel: " + channel.toString() + ", mask=" + this.debugMask(selectMask));
        LinkedList<SelectorChangeRequest> linkedList = this.changes;
        synchronized (linkedList) {
            this.changes.add(new SelectorChangeRequest(channel, Operation.ADD, selectMask, listener));
            this.selector.wakeup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modify(SelectableChannel channel, SocketListener listener, int selectMask) {
        this.logger.info("Modify channel: " + (channel != null ? channel.toString() : "null") + ", mask=" + this.debugMask(selectMask));
        if (channel == null) {
            return false;
        }
        LinkedList<SelectorChangeRequest> linkedList = this.changes;
        synchronized (linkedList) {
            this.changes.add(new SelectorChangeRequest(channel, Operation.MODIFY, selectMask, listener));
            this.selector.wakeup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(SelectableChannel channel) {
        if (channel == null) {
            return;
        }
        this.logger.info("Remove channel: " + channel.toString());
        LinkedList<SelectorChangeRequest> linkedList = this.changes;
        synchronized (linkedList) {
            this.changes.add(new SelectorChangeRequest(channel, Operation.REMOVE));
            this.selector.wakeup();
        }
    }

    public void stop() {
        this.selector.wakeup();
    }

    public boolean poll() {
        return this.poll(Long.MAX_VALUE);
    }

    public boolean poll(long ms) {
        boolean ok = this.pollSockets(ms);
        this.applyChanges();
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pollSockets(long ms) {
        if (this.selector.keys().isEmpty()) {
            return true;
        }
        try {
            this.locked = true;
            Selector selector = this.selector;
            synchronized (selector) {
                this.selector.select(ms);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.locked = false;
        }
        this.locked = true;
        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            SelectionKey key = iterator.next();
            iterator.remove();
            try {
                this.processSelectionKey(key);
            }
            catch (CancelledKeyException cke) {
                cke.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                key.cancel();
            }
        }
        this.locked = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyChanges() {
        LinkedList<SelectorChangeRequest> linkedList = this.changes;
        synchronized (linkedList) {
            if (this.changes.size() == 0) {
                return;
            }
            Iterator it = this.changes.iterator();
            while (it.hasNext()) {
                try {
                    SelectorChangeRequest req = (SelectorChangeRequest)it.next();
                    req.dump();
                    switch (req.op) {
                        case ADD: {
                            try {
                                req.channel.register(this.selector, req.mask, req.listener);
                            }
                            catch (ClosedChannelException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case MODIFY: {
                            SelectionKey key = req.channel.keyFor(this.selector);
                            if (key == null) break;
                            key.interestOps(req.mask);
                            break;
                        }
                        case REMOVE: {
                            SelectionKey selKey = req.channel.keyFor(this.selector);
                            if (selKey == null) break;
                            selKey.cancel();
                        }
                    }
                }
                catch (CancelledKeyException e) {
                    this.logger.finest("Key was cancelled - ignoring...");
                }
            }
            this.changes.clear();
        }
    }

    protected void processSelectionKey(SelectionKey key) throws IOException {
        int notTriggered;
        SelectableChannel channel = key.channel();
        if (!key.isValid()) {
            return;
        }
        SocketListener listener = (SocketListener)key.attachment();
        int currentMask = key.interestOps();
        int triggerMask = key.readyOps();
        int wantedMask = 0;
        if (key.isValid() && key.isAcceptable() && listener.canRead(channel)) {
            wantedMask |= 0x10;
        }
        if (key.isValid() && key.isConnectable() && listener.canRead(channel)) {
            wantedMask |= 8;
        }
        if (key.isValid() && key.isReadable() && listener.canRead(channel)) {
            wantedMask |= 1;
        }
        if (key.isValid() && key.isWritable() && listener.canWrite(channel)) {
            wantedMask |= 4;
        }
        if ((wantedMask |= (notTriggered = currentMask & ~triggerMask)) != currentMask) {
            if (wantedMask != 0) {
                if (key.isValid()) {
                    key.interestOps(wantedMask);
                }
            } else {
                key.cancel();
            }
        }
    }

    private String debugMask(int mask) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if ((mask & 1) == 1) {
            builder.append(" READ");
        }
        if ((mask & 4) == 4) {
            builder.append(" WRITE");
        }
        if ((mask & 0x10) == 16) {
            builder.append(" ACCEPT");
        }
        if ((mask & 8) == 8) {
            builder.append(" CONNECT");
        }
        builder.append("}");
        return builder.toString();
    }

    class SelectorChangeRequest {
        protected SelectableChannel channel;
        protected Operation op;
        protected int mask;
        protected SocketListener listener;

        public SelectorChangeRequest(SelectableChannel channel, Operation op, int mask, SocketListener listener) {
            this.channel = channel;
            this.op = op;
            this.mask = mask;
            this.listener = listener;
        }

        public SelectorChangeRequest(SelectableChannel channel, Operation op) {
            this.channel = channel;
            this.op = op;
            this.mask = 0;
            this.listener = null;
        }

        public void dump() {
            switch (this.op) {
                case ADD: {
                    SocketMonitor.this.logger.finest("SelectorChangeRequest: Add socket=" + this.channel.toString() + ", mask=" + this.mask);
                    break;
                }
                case MODIFY: {
                    SocketMonitor.this.logger.finest("SelectorChangeRequest: Modify socket=" + this.channel.toString() + ", mask=" + this.mask);
                    break;
                }
                case REMOVE: {
                    SocketMonitor.this.logger.finest("SelectorChangeRequest: Remove socket=" + this.channel.toString());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        ADD,
        MODIFY,
        REMOVE;

    }
}

