/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.opera.core.systems.CapturesScreen;
import com.opera.core.systems.OperaAtom;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.internal.OperaColors;
import com.opera.core.systems.model.Canvas;
import com.opera.core.systems.model.ColorResult;
import com.opera.core.systems.model.ScreenCaptureReply;
import com.opera.core.systems.scope.exceptions.ResponseNotReceivedException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.internal.OperaMouseKeys;
import com.opera.core.systems.scope.services.Debugger;
import com.opera.core.systems.scope.services.Exec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.Color;

public class OperaWebElement
extends RemoteWebElement
implements CapturesScreen {
    public static final List<String> SPECIAL_INPUTS = ImmutableList.of((Object)"datetime", (Object)"date", (Object)"month", (Object)"week", (Object)"time", (Object)"datetime-local", (Object)"range", (Object)"color", (Object)"file");
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final int objectId;
    private final int runtimeId;
    private final OperaDriver parent;
    private final Exec exec;
    private final Debugger debugger;
    private Coordinates coordinates = new Coordinates(){

        public Point getLocationOnScreen() {
            throw new UnsupportedOperationException();
        }

        public Point getLocationInViewPort() {
            String coordinates = OperaWebElement.this.debugger.callFunctionOnObject("locator.scrollIntoView();\nvar x = 0, y = 0;\nif(window.top !== window.self) {\nx = (window.screenLeft - window.top.screenLeft) + window.scrollX;\ny = (window.screenTop - window.top.screenTop) + window.scrollY;\n}\nreturn (( x + locator.getBoundingClientRect().left) + ',' + ( y + locator.getBoundingClientRect().top));\n", OperaWebElement.this.objectId);
            String[] location = coordinates.split(",");
            return new Point(Integer.valueOf(location[0]).intValue(), Integer.valueOf(location[1]).intValue());
        }

        public Point getLocationInDOM() {
            return OperaWebElement.this.getLocation();
        }

        public Object getAuxiliary() {
            throw new UnsupportedOperationException();
        }
    };

    public OperaWebElement(OperaDriver driver, int id) {
        this.parent = driver;
        this.objectId = id;
        this.parent.objectIds.add(this.objectId);
        this.debugger = this.parent.getDebugger();
        this.exec = this.parent.getScopeServices().getExec();
        this.runtimeId = this.debugger.getRuntimeId();
        this.setId(String.valueOf(this.hashCode()));
        this.setFileDetector(this.parent.getFileDetector());
    }

    public final String callMethod(String method) {
        this.parent.assertConnected();
        return this.debugger.callFunctionOnObject(method, this.objectId);
    }

    private void executeMethod(String script) {
        this.parent.assertConnected();
        this.debugger.callFunctionOnObject(script, this.objectId, false);
    }

    private Object evaluateMethod(String script) {
        return this.debugger.callFunctionOnObject(script, this.objectId, true);
    }

    public void click() {
        this.assertElementNotStale();
        this.assertElementDisplayed();
        this.parent.getScopeServices().captureOperaIdle();
        if (this.getTagName().equals("OPTION")) {
            this.callMethod("return " + (Object)((Object)OperaAtom.CLICK) + "(locator)");
        } else {
            this.parent.getMouse().click(this.getCoordinates());
        }
        try {
            this.parent.waitForLoadToComplete();
        }
        catch (ResponseNotReceivedException e) {
            this.logger.fine("Response not received, returning control to user");
        }
    }

    @Deprecated
    public void middleClick() {
        Point point = this.coordinates.getLocationInViewPort();
        this.exec.mouseAction(point.x, point.y, OperaMouseKeys.MIDDLE);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public String getAttribute(String attribute) {
        this.assertElementNotStale();
        if (attribute.equalsIgnoreCase("value")) {
            return this.callMethod("if(/^input|select|option|textarea$/i.test(locator.nodeName)){return locator.value;}return locator.textContent;");
        }
        return this.callMethod("return " + (Object)((Object)OperaAtom.GET_ATTRIBUTE) + "(locator, '" + attribute + "')");
    }

    public String getText() {
        this.assertElementNotStale();
        return this.callMethod("return " + (Object)((Object)OperaAtom.GET_TEXT) + "(locator)");
    }

    public boolean isDisplayed() {
        this.assertElementNotStale();
        return (Boolean)this.evaluateMethod("return " + (Object)((Object)OperaAtom.IS_DISPLAYED) + "(locator)");
    }

    public boolean isEnabled() {
        this.assertElementNotStale();
        return (Boolean)this.evaluateMethod("return " + (Object)((Object)OperaAtom.IS_ENABLED) + "(locator)");
    }

    public boolean isSelected() {
        this.assertElementNotStale();
        return (Boolean)this.evaluateMethod("return " + (Object)((Object)OperaAtom.IS_SELECTED) + "(locator)");
    }

    public void clear() {
        this.verifyCanInteractWithElement();
        if (this.isEnabled() && !Boolean.valueOf(this.getAttribute("readonly")).booleanValue()) {
            this.executeMethod("return " + (Object)((Object)OperaAtom.CLEAR) + "(locator)");
        }
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.verifyCanInteractWithElement();
        String typeAttribute = this.getAttribute("type").toLowerCase();
        if (this.getTagName().equals("INPUT") && SPECIAL_INPUTS.contains(typeAttribute)) {
            if (typeAttribute.equals("file")) {
                File localFile = this.fileDetector.getLocalFile(keysToSend);
                if (localFile != null) {
                    this.debugger.setFormElementValue(this.objectId, localFile.getAbsolutePath());
                }
            } else {
                this.debugger.setFormElementValue(this.objectId, Joiner.on((String)"").join((Object[])keysToSend));
            }
            return;
        }
        this.parent.getScopeServices().captureOperaIdle();
        this.switchFocusToThisIfNeeded();
        this.parent.getKeyboard().sendKeys(keysToSend);
        try {
            this.parent.waitForLoadToComplete();
        }
        catch (ResponseNotReceivedException responseNotReceivedException) {
            // empty catch block
        }
    }

    private void switchFocusToThisIfNeeded() {
        String type = this.callMethod("locator.type");
        if (type.equals("text") || type.equals("textarea")) {
            this.executeMethod((Object)((Object)OperaAtom.MOVE_CARET_TO_END) + "(locator)");
        }
        this.executeMethod("locator.focus()");
    }

    public void submit() {
        this.parent.getScopeServices().captureOperaIdle();
        this.evaluateMethod("return " + (Object)((Object)OperaAtom.SUBMIT) + "(locator)");
        try {
            this.parent.waitForLoadToComplete();
        }
        catch (ResponseNotReceivedException e) {
            this.logger.fine("Response not received, returning control to user");
        }
    }

    public Point getLocation() {
        this.assertElementNotStale();
        String coordinates = this.debugger.callFunctionOnObject("var coords = " + (Object)((Object)OperaAtom.GET_LOCATION) + "(locator); return coords.x + ',' + coords.y;", this.objectId);
        if (coordinates.isEmpty()) {
            this.logger.warning("Falling back to non-atom positioning code in getLocation");
            coordinates = this.debugger.callFunctionOnObject("var coords = locator.getBoundingClientRect();return (coords.left-window.pageXOffset)+','+(coords.top-window.pageYOffset)", this.objectId);
        }
        String[] location = coordinates.split(",");
        return new Point(Integer.valueOf(location[0]).intValue(), Integer.valueOf(location[1]).intValue());
    }

    public Dimension getSize() {
        this.assertElementNotStale();
        String widthAndHeight = this.debugger.callFunctionOnObject("var s=" + (Object)((Object)OperaAtom.GET_SIZE) + "(locator);return s.width+','+s.height;", this.objectId);
        String[] dimension = widthAndHeight.split(",");
        return new Dimension(Integer.valueOf(dimension[0]).intValue(), Integer.valueOf(dimension[1]).intValue());
    }

    public String getImageHash() {
        return this.getImageHash(10L, new ArrayList<String>());
    }

    public String getImageHash(long timeout, List<String> hashes) {
        return this.saveScreenshot("", timeout, false, hashes);
    }

    public String saveScreenshot(String filename) {
        return this.saveScreenshot(filename, 10L);
    }

    public String saveScreenshot(String filename, long timeout) {
        return this.saveScreenshot(filename, timeout, true, new ArrayList<String>());
    }

    public String saveScreenshot(String filename, long timeout, boolean includeImage, List<String> hashes) {
        this.assertElementNotStale();
        Canvas canvas = this.buildCanvas();
        ScreenCaptureReply reply = this.exec.screenWatcher(canvas, timeout, includeImage, hashes);
        if (includeImage && reply.getPng() != null) {
            try {
                FileChannel stream = new FileOutputStream(filename).getChannel();
                stream.write(ByteBuffer.wrap(reply.getPng()));
                stream.close();
            }
            catch (IOException e) {
                throw new WebDriverException("Failed to write file: " + e.getMessage(), (Throwable)e);
            }
        }
        return reply.getMd5();
    }

    @Override
    public ScreenCaptureReply captureScreen() {
        return this.captureScreen(OperaIntervals.RUNNER_SCREEN_CAPTURE_TIMEOUT.getMs());
    }

    @Override
    public ScreenCaptureReply captureScreen(long timeout) {
        return this.captureScreen(timeout, new ArrayList<String>());
    }

    @Override
    public ScreenCaptureReply captureScreen(long timeout, List<String> knownMD5s) {
        this.assertElementNotStale();
        Canvas canvas = this.buildCanvas();
        return this.exec.screenWatcher(canvas, timeout, true, knownMD5s);
    }

    @Deprecated
    public boolean containsColor(OperaColors ... colors) {
        this.assertElementNotStale();
        Canvas canvas = this.buildCanvas();
        ScreenCaptureReply reply = this.exec.containsColor(canvas, 100L, colors);
        List<ColorResult> results = reply.getColorResults();
        for (ColorResult result : results) {
            if (result.getCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private Canvas buildCanvas() {
        Canvas canvas = new Canvas();
        Dimension dimension = this.getSize();
        Point point = this.coordinates.getLocationInViewPort();
        int x = point.x;
        int y = point.y;
        int w = Math.max(dimension.width, 1);
        int h = Math.max(dimension.height, 1);
        canvas.setX(x);
        canvas.setY(y);
        canvas.setHeight(h);
        canvas.setWidth(w);
        canvas.setViewPortRelative(true);
        return canvas;
    }

    public String getTagName() {
        this.assertElementNotStale();
        return this.callMethod("return (locator.tagName);");
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        if (this.isDisplayed()) {
            return this.getLocation();
        }
        return null;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getRuntimeId() {
        return this.runtimeId;
    }

    public int hashCode() {
        int result = 42;
        result = 31 * result + this.objectId;
        result = 31 * result + this.runtimeId;
        return result;
    }

    public String toString() {
        return "element" + this.hashCode();
    }

    private WebElement findSingleElement(String using, String type) {
        Integer id = this.debugger.executeScriptOnObject(using, this.objectId);
        if (id != null) {
            return new OperaWebElement(this.parent, id);
        }
        throw new NoSuchElementException("Cannot find element with " + type);
    }

    protected WebElement findElement(final String by, final String using) {
        final OperaWebElement el = this;
        return this.parent.implicitlyWaitFor(new Callable<WebElement>(){

            @Override
            public WebElement call() {
                return OperaWebElement.this.parent.findElement(by, using, el);
            }
        });
    }

    protected List<WebElement> findElements(String by, String using) {
        return this.parent.findElements(by, using, this);
    }

    private List<WebElement> findMultipleElements(String using, String type) {
        Integer id = this.debugger.executeScriptOnObject(using, this.objectId);
        if (id == null) {
            throw new NoSuchElementException("Cannot find element(s) with " + type);
        }
        return this.parent.processElements(id);
    }

    public WebElement findElementByName(String using) {
        return this.findSingleElement("document.evaluate(\"descendant-or-self::*[@name='" + using + "']\",locator,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext()", "name");
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findMultipleElements("var result = document.evaluate(\"descendant-or-self::*[@name='" + using + "']\"" + ", locator, null, XPathResult.ORDERED_NODE_ITERATOR_TYPE,  null);\n" + "var elements = new Array();\n" + "var element = result.iterateNext();\n" + "while (element) {\n" + "  elements.push(element);\n" + "  element = result.iterateNext();\n" + "}\n" + "return elements", "XPath");
    }

    protected void finalize() throws Throwable {
        this.debugger.releaseObject(this.objectId);
        super.finalize();
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getCssValue(String property) {
        this.assertElementNotStale();
        String value = this.callMethod("return " + (Object)((Object)OperaAtom.GET_EFFECTIVE_STYLE) + "(locator, '" + property + "')");
        if (property.contains("color") && value.contains("rgb")) {
            return Color.fromString((String)value).asRgba();
        }
        return value;
    }

    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    private void verifyCanInteractWithElement() {
        this.assertElementNotStale();
        this.assertElementDisplayed();
        this.assertElementEnabled();
    }

    private void assertElementDisplayed() {
        this.assertElementDisplayed("You may only interact with visible elements");
    }

    private void assertElementDisplayed(String message) {
        Boolean displayed = this.parent.implicitlyWaitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return OperaWebElement.this.isDisplayed();
            }
        });
        if (displayed == null || !displayed.booleanValue()) {
            throw new ElementNotVisibleException(message);
        }
    }

    private void assertElementEnabled() {
        this.assertElementEnabled("You may only interact with enabled elements");
    }

    private void assertElementEnabled(String message) {
        if (!this.isEnabled()) {
            throw new InvalidElementStateException(message);
        }
    }

    private void assertElementNotStale() {
        if (!this.parent.objectIds.contains(this.objectId)) {
            throw new StaleElementReferenceException("Element appears to be stale.  Did you navigate away from the page that contained it?  And is the current window focussed the same as the one holding this element?");
        }
        if (Boolean.valueOf(this.callMethod("locator.parentNode == undefined")).booleanValue()) {
            throw new StaleElementReferenceException("The element seems to be disconnected from the DOM.  This means that the user cannot interact with it.");
        }
    }
}

