/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.Discriminator;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.PlatformSeparators;
import com.oracle.bedrock.runtime.options.TemporaryDirectory;
import java.io.File;
import java.util.Calendar;
import java.util.Iterator;

public class WorkingDirectory
implements Option {
    private final Object workingDirectory;

    private WorkingDirectory(Object workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Object getValue() {
        return this.workingDirectory;
    }

    public File resolve(Platform platform, OptionsByType optionsByType) {
        if (this.workingDirectory == null) {
            return null;
        }
        if (this.workingDirectory instanceof File) {
            return (File)this.workingDirectory;
        }
        DisplayName displayName = (DisplayName)optionsByType.get(DisplayName.class, new Object[0]);
        Discriminator discriminator = (Discriminator)optionsByType.get(Discriminator.class, new Object[0]);
        ExpressionEvaluator evaluator = new ExpressionEvaluator(optionsByType);
        evaluator.defineVariable("applicationName", (Object)displayName.resolve(optionsByType));
        evaluator.defineVariable("displayName", (Object)displayName.resolve(null));
        if (discriminator != null) {
            evaluator.defineVariable("discriminator", (Object)discriminator.getValue());
        }
        evaluator.defineVariable("platform", (Object)platform);
        Object directoryValue = this.workingDirectory;
        if (directoryValue instanceof ContextSensitiveDirectoryName) {
            ContextSensitiveDirectoryName contextSensitiveValue = (ContextSensitiveDirectoryName)directoryValue;
            directoryValue = contextSensitiveValue.resolve(platform, optionsByType);
        }
        if (directoryValue instanceof Iterator) {
            Iterator iterator = (Iterator)directoryValue;
            if (iterator.hasNext()) {
                directoryValue = iterator.next().toString();
            } else {
                throw new IndexOutOfBoundsException(String.format("No more values available for the working directory [%s]", this.workingDirectory));
            }
        }
        if (directoryValue instanceof File) {
            return (File)directoryValue;
        }
        String expression = directoryValue.toString().trim();
        Object result = evaluator.evaluate(expression, Object.class);
        return new File(String.valueOf(result));
    }

    public static WorkingDirectory currentDirectory() {
        return new WorkingDirectory(System.getProperty("user.dir"));
    }

    public static WorkingDirectory temporaryDirectory() {
        ContextSensitiveDirectoryName name = new ContextSensitiveDirectoryName(){

            @Override
            public Object resolve(Platform platform, OptionsByType optionsByType) {
                DisplayName displayName = (DisplayName)optionsByType.get(DisplayName.class, new Object[0]);
                PlatformSeparators separators = (PlatformSeparators)optionsByType.get(PlatformSeparators.class, new Object[0]);
                String sanitizedDisplayName = separators.asSanitizedFileName(displayName.resolve(optionsByType));
                Calendar now = Calendar.getInstance();
                String temporaryDirectoryName = String.format("%1$s-%2$tY%2$tm%2$td-%2$tH%2$tM%2$tS-%2$tL", sanitizedDisplayName, now);
                TemporaryDirectory defaultTemp = TemporaryDirectory.at(separators.getFileSeparator() + "tmp");
                TemporaryDirectory temporaryDirectory = (TemporaryDirectory)optionsByType.getOrDefault(TemporaryDirectory.class, (Option)defaultTemp);
                return new File(temporaryDirectory.get().toFile(), temporaryDirectoryName);
            }
        };
        return new WorkingDirectory(name);
    }

    public static WorkingDirectory at(File workingDirectory) {
        return workingDirectory != null ? new WorkingDirectory(workingDirectory) : WorkingDirectory.currentDirectory();
    }

    public static WorkingDirectory at(Object workingDirectory) {
        return workingDirectory != null ? new WorkingDirectory(workingDirectory) : WorkingDirectory.currentDirectory();
    }

    public static WorkingDirectory subDirectoryOf(final File parent) {
        ContextSensitiveDirectoryName name = new ContextSensitiveDirectoryName(){

            @Override
            public Object resolve(Platform platform, OptionsByType optionsByType) {
                DisplayName displayName = (DisplayName)optionsByType.get(DisplayName.class, new Object[0]);
                PlatformSeparators separators = (PlatformSeparators)optionsByType.get(PlatformSeparators.class, new Object[0]);
                String sanitizedDisplayName = separators.asSanitizedFileName(displayName.resolve(optionsByType));
                File parentFile = parent != null ? parent : new File(System.getProperty("user.dir"));
                return new File(parentFile, sanitizedDisplayName);
            }
        };
        return new WorkingDirectory(name);
    }

    public static interface ContextSensitiveDirectoryName {
        public Object resolve(Platform var1, OptionsByType var2);
    }
}

