/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.matchers;

import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class RecordingMatcher<T>
extends BaseMatcher<T> {
    private Matcher<? super T> matcher;
    private AtomicInteger successCount;
    private AtomicInteger failureCount;

    public RecordingMatcher(Matcher<? super T> matcher) {
        this.matcher = matcher;
        this.successCount = new AtomicInteger(0);
        this.failureCount = new AtomicInteger(0);
    }

    public static <T> RecordingMatcher<T> of(Matcher<? super T> matcher) {
        return new RecordingMatcher<T>(matcher);
    }

    public int getSuccessCount() {
        return this.successCount.get();
    }

    public boolean hasSucceeded() {
        return this.getSuccessCount() > 0;
    }

    public int getFailureCount() {
        return this.failureCount.get();
    }

    public boolean hasFailed() {
        return this.getFailureCount() > 0;
    }

    public int getAttemptCount() {
        return this.successCount.get() + this.failureCount.get();
    }

    public boolean attempted() {
        return this.getAttemptCount() > 0;
    }

    public boolean matches(Object o) {
        boolean match = this.matcher.matches(o);
        if (match) {
            this.successCount.incrementAndGet();
        } else {
            this.failureCount.incrementAndGet();
        }
        return match;
    }

    public void describeTo(Description description) {
        description.appendText("A recoding matcher for ");
        this.matcher.describeTo(description);
    }
}

