/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.io.InputStream;

public class InputBuffer {
    public static final String END_OF_STREAM_MESSAGE = "End of data encountered.";
    private InputStream inputStream;

    protected InputBuffer(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected int getBytes(byte[] buf, int len) throws IOException {
        int retVal = 0;
        for (int i = 0; i < len; ++i) {
            int b = this.inputStream.read();
            if (b < 0) {
                retVal = -1;
                break;
            }
            buf[i] = (byte)b;
            ++retVal;
        }
        return retVal;
    }

    protected byte getByte() throws IOException {
        int b = this.inputStream.read();
        if (b < 0) {
            throw new IOException(END_OF_STREAM_MESSAGE);
        }
        return (byte)b;
    }

    protected int skipBytes(int len) throws IOException {
        int retVal = 0;
        for (int i = 0; i < len; ++i) {
            int b = this.inputStream.read();
            if (b < 0) {
                throw new IOException(END_OF_STREAM_MESSAGE);
            }
            ++retVal;
        }
        return retVal;
    }

    protected String getNextString() throws IOException {
        StringBuilder sb = new StringBuilder();
        String retVal = null;
        while (true) {
            int b;
            if ((b = this.inputStream.read()) < 0) {
                throw new IOException(END_OF_STREAM_MESSAGE);
            }
            if (b == 13) break;
            sb.append((char)b);
        }
        this.inputStream.read();
        if (sb.length() > 0) {
            retVal = sb.toString();
        }
        return retVal;
    }

    protected String getNextLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int b;
            if ((b = this.inputStream.read()) < 0) {
                throw new IOException(END_OF_STREAM_MESSAGE);
            }
            if (b == 10) break;
            sb.append((char)b);
        }
        return sb.toString();
    }
}

