/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.time.Period;
import java.util.Arrays;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.sql.INTERVALYM;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonIntervalYMImpl
implements OracleJsonIntervalYM {
    public static final int INTERVALYM_LEN = 5;
    byte[] raw;

    public OracleJsonIntervalYMImpl(byte[] byArray) {
        this.raw = byArray;
    }

    public OracleJsonIntervalYMImpl(Period period) {
        this.raw = OsonPrimitiveConversions.periodToIntervalYM(OracleJsonExceptions.ORACLE_FACTORY, period);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.INTERVALYM;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonIntervalYM)) {
            return false;
        }
        if (!(object instanceof OracleJsonIntervalYMImpl)) {
            throw new UnsupportedOperationException();
        }
        OracleJsonIntervalYMImpl oracleJsonIntervalYMImpl = (OracleJsonIntervalYMImpl)object;
        return Arrays.equals(oracleJsonIntervalYMImpl.raw, this.raw);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public String getString() {
        return OsonPrimitiveConversions.serializeIntervalYM(OracleJsonExceptions.ORACLE_FACTORY, this.raw());
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public Period getPeriod() {
        return OsonPrimitiveConversions.intervalYMToPeriod(this.raw());
    }

    public static String serializePeriod(Period period, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        byte[] byArray = OsonPrimitiveConversions.periodToIntervalYM(exceptionFactory, period);
        return OsonPrimitiveConversions.serializeIntervalYM(exceptionFactory, byArray);
    }

    @Override
    public INTERVALYM getINTERVALYM() {
        return new INTERVALYM(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createIntervalYM(this.raw));
    }
}

