/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCacheKey;

class DownHostsCache {
    private static final DownHostsCache SOLE_INSTANCE = new DownHostsCache();
    static int DOWN_HOSTS_TIMEOUT = Integer.parseInt("600");
    private static final int MIN_TIME_BETWEEN_PURGES = 60;
    private Map<DownHostsCacheKey, LocalDateTime> downHostsCacheMap = new ConcurrentHashMap<DownHostsCacheKey, LocalDateTime>();
    private LocalDateTime lastPurge = LocalDateTime.MIN;

    private DownHostsCache() {
    }

    static DownHostsCache getInstance() {
        return SOLE_INSTANCE;
    }

    LocalDateTime markDownHost(InetAddress inetAddress, int n2) {
        return this.downHostsCacheMap.put(new DownHostsCacheKey(inetAddress.getHostAddress(), n2), LocalDateTime.now());
    }

    void reorderAddresses(InetAddress[] inetAddressArray, int n2) {
        this.refreshCache();
        int n3 = 0;
        int n4 = inetAddressArray.length - 1;
        while (n3 < n4) {
            while (n3 <= n4 && !this.isDownHostsCached(inetAddressArray[n3], n2)) {
                ++n3;
            }
            while (n4 >= n3 && this.isDownHostsCached(inetAddressArray[n4], n2)) {
                --n4;
            }
            if (n3 >= n4) continue;
            DownHostsCache.swap(inetAddressArray, n3, n4);
        }
    }

    private static <T> void swap(T[] TArray, int n2, int n3) {
        T t2 = TArray[n2];
        TArray[n2] = TArray[n3];
        TArray[n3] = t2;
    }

    private void refreshCache() {
        if (LocalDateTime.now().minus(60L, ChronoUnit.SECONDS).isAfter(this.lastPurge)) {
            for (DownHostsCacheKey downHostsCacheKey : this.downHostsCacheMap.keySet()) {
                LocalDateTime localDateTime = this.downHostsCacheMap.get(downHostsCacheKey);
                if (localDateTime == null || LocalDateTime.now().minus(DOWN_HOSTS_TIMEOUT, ChronoUnit.SECONDS).compareTo(localDateTime) <= 0) continue;
                this.downHostsCacheMap.remove(downHostsCacheKey);
            }
            this.lastPurge = LocalDateTime.now();
        }
    }

    private boolean isDownHostsCached(InetAddress inetAddress, int n2) {
        DownHostsCacheKey downHostsCacheKey = new DownHostsCacheKey(inetAddress.getHostAddress(), n2);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }

    LocalDateTime markDownHost(ConnOption connOption) {
        return this.downHostsCacheMap.put(new DownHostsCacheKey(connOption.addr, 0), LocalDateTime.now());
    }

    void reorderAddresses(List<ConnOption> list) {
        this.refreshCache();
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 < n3) {
            while (n2 <= n3 && !this.isDownHostsCached(list.get(n2))) {
                ++n2;
            }
            while (n3 >= n2 && this.isDownHostsCached(list.get(n3))) {
                --n3;
            }
            if (n2 >= n3) continue;
            Collections.swap(list, n2, n3);
        }
    }

    private boolean isDownHostsCached(ConnOption connOption) {
        DownHostsCacheKey downHostsCacheKey = new DownHostsCacheKey(connOption.addr, 0);
        return this.downHostsCacheMap.containsKey(downHostsCacheKey);
    }
}

