/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.json;

import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public interface OracleJsonParser
extends Closeable {
    public boolean hasNext();

    public Event next();

    public String getString();

    public boolean isIntegralNumber();

    public int getInt();

    public long getLong();

    public double getDouble();

    public float getFloat();

    public BigInteger getBigInteger();

    public BigDecimal getBigDecimal();

    public OffsetDateTime getOffsetDateTime();

    public LocalDateTime getLocalDateTime();

    public Period getPeriod();

    public Duration getDuration();

    public byte[] getBytes();

    public OracleJsonValue getValue();

    public OracleJsonArray getArray();

    public OracleJsonObject getObject();

    public void skipArray();

    public void skipObject();

    public <T> T wrap(Class<T> var1);

    @Override
    public void close();

    public static enum Event {
        START_ARRAY,
        START_OBJECT,
        KEY_NAME,
        VALUE_STRING,
        VALUE_DECIMAL,
        VALUE_DOUBLE,
        VALUE_FLOAT,
        VALUE_BINARY,
        VALUE_TIMESTAMP,
        VALUE_TIMESTAMPTZ,
        VALUE_DATE,
        VALUE_INTERVALYM,
        VALUE_INTERVALDS,
        VALUE_TRUE,
        VALUE_FALSE,
        VALUE_NULL,
        END_OBJECT,
        END_ARRAY;

    }
}

