/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.EnumSet;
import java.util.Iterator;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.sql.ROWID;

class NTFDCNRowChanges
implements RowChangeDescription {
    EnumSet<RowChangeDescription.RowOperation> opcode;
    int rowidLength;
    byte[] rowid;
    ROWID rowidObj;

    NTFDCNRowChanges(EnumSet<RowChangeDescription.RowOperation> _opcode, int _rowidLength, byte[] _rowid) {
        this.opcode = _opcode;
        this.rowidLength = _rowidLength;
        this.rowid = _rowid;
        this.rowidObj = null;
    }

    @Override
    public ROWID getRowid() {
        if (this.rowidObj == null) {
            this.rowidObj = new ROWID(this.rowid);
        }
        return this.rowidObj;
    }

    @Override
    @Deprecated
    public RowChangeDescription.RowOperation getRowOperation() {
        Iterator iterator = this.opcode.iterator();
        if (iterator.hasNext()) {
            RowChangeDescription.RowOperation op = (RowChangeDescription.RowOperation)((Object)iterator.next());
            return op;
        }
        return null;
    }

    @Override
    public EnumSet<RowChangeDescription.RowOperation> getRowOperations() {
        return this.opcode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("      ROW:  operation=" + this.getRowOperations() + ", ROWID=" + new String(this.rowid) + "\n");
        return sb.toString();
    }
}

