/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.AbstractTrueCacheConnection;
import oracle.jdbc.driver.AbstractTrueCacheResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.TrueCacheDriverExtension;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

@ProxyFor(value={OracleStatement.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractTrueCacheStatement {
    protected OracleStatement primaryStatement;
    protected OracleStatement tcStatement;
    protected OracleResultSet.ResultSetType resultSetType;
    boolean closed;
    protected static final int PLAIN_STMT = 0;
    protected static final int PREP_STMT = 1;
    protected static final int CALL_STMT = 2;
    int statementType = 0;
    boolean isCloseOnCompletion = false;
    AbstractTrueCacheResultSet currentResultSet;
    static int NON_CACHED = 3;
    Vector<String> m_batchItems = null;
    protected CallHistoryEntry head;
    protected CallHistoryEntry tail;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract Statement getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Statement var1);

    void initialize(AbstractTrueCacheConnection connection, OracleResultSet.ResultSetType resultSetType, int statementType) throws SQLException {
        this.statementType = statementType;
        this.resultSetType = resultSetType;
        this.closed = false;
        this.createStatement(connection);
    }

    protected void createStatement(AbstractTrueCacheConnection connection) throws SQLException {
        this.primaryStatement = this.createStatement(connection.getPrimaryConnection());
        OracleConnection tcConnection = connection.getTrueCacheConnection();
        if (connection.isTrueCacheConnectionAvailable()) {
            this.tcStatement = this.createStatement(tcConnection);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={String.class}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preStmtExecuteQuery(Method m, Object receiver, Object ... args) {
        try {
            ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionLock();
            this.ensureOpen();
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
                this.currentResultSet = null;
            }
            this.setDelegate(this.getDelegateStatement());
        }
        catch (SQLException ex) {
            ((AbstractTrueCacheConnection)this.getCreator()).releaseConnectionLock();
            throw new RuntimeException(ex);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={String.class})})
    protected ResultSet postStmtExecuteQuery(Method m, ResultSet result) {
        try {
            OracleStatement statement = (OracleStatement)this.getDelegate();
            result = this.createResultSetProxy(result);
            this.currentResultSet = (AbstractTrueCacheResultSet)((Object)result);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ((AbstractTrueCacheConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Post
    @Methods(signatures={@Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected Object postStmtExecuteUpdate(Method m, Object result) {
        try {
            Object object = result;
            return object;
        }
        finally {
            ((AbstractTrueCacheConnection)this.getCreator()).releaseConnectionLock();
        }
    }

    @OnError(value=SQLException.class)
    protected Object onErrorStmt(Method m, SQLException e) throws SQLException {
        ((AbstractTrueCacheConnection)this.getCreator()).checkAndReleaseConnectionLock();
        throw e;
    }

    public void close() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.primaryStatement.close();
            if (this.tcStatement != null) {
                this.tcStatement.close();
            }
            this.closed = true;
            this.setDelegate(null);
        }
    }

    public void clearDefines() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.clearDefines();
        }
    }

    public void defineColumnType(int column_index, int type) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.defineColumnType(column_index, type);
        }
    }

    public void defineColumnType(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.defineColumnType(ccolumnIndex, type, lobPrefetchSize);
        }
    }

    public void defineColumnType(int ccolumnIndex, int typeCode, String typeName) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.defineColumnType(ccolumnIndex, typeCode, typeName);
        }
    }

    public void defineColumnType(int ccolumnIndex, int type, int lobPrefetchSize, short formOfUse) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.defineColumnType(ccolumnIndex, type, lobPrefetchSize, formOfUse);
        }
    }

    public void defineColumnTypeBytes(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.defineColumnTypeBytes(ccolumnIndex, type, lobPrefetchSize);
        }
    }

    public void defineColumnTypeChars(int ccolumnIndex, int type, int lobPrefetchSize) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.defineColumnTypeChars(ccolumnIndex, type, lobPrefetchSize);
        }
    }

    public void setDatabaseChangeRegistration(DatabaseChangeRegistration registration) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.setDatabaseChangeRegistration(registration);
        }
    }

    public void setSnapshotSCN(long scn) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.setSnapshotSCN(scn);
        }
    }

    public void registerBindChecksumListener(OracleStatement.BindChecksumListener listener) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.registerBindChecksumListener(listener);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.setEscapeProcessing(enable);
        }
    }

    public void clearWarnings() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            statement.clearWarnings();
        }
    }

    public void setRowPrefetch(int value) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setRowPrefetch";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{value};
            this.primaryStatement.setRowPrefetch(value);
            if (this.tcStatement != null) {
                this.tcStatement.setRowPrefetch(value);
            }
        }
    }

    public int getRowPrefetch() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            int n = statement.getRowPrefetch();
            return n;
        }
    }

    public void setLobPrefetchSize(int value) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setLobPrefetchSize";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{value};
            this.primaryStatement.setLobPrefetchSize(value);
            if (this.tcStatement != null) {
                this.tcStatement.setLobPrefetchSize(value);
            }
        }
    }

    public int getLobPrefetchSize() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            int n = statement.getLobPrefetchSize();
            return n;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setFetchDirection";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{direction};
            this.primaryStatement.setFetchDirection(direction);
            if (this.tcStatement != null) {
                this.tcStatement.setFetchDirection(direction);
            }
        }
    }

    public int getFetchDirection() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            int n = statement.getFetchDirection();
            return n;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setFetchSize";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{rows};
            this.primaryStatement.setFetchSize(rows);
            if (this.tcStatement != null) {
                this.tcStatement.setFetchSize(rows);
            }
        }
    }

    public int getFetchSize() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            int n = statement.getFetchSize();
            return n;
        }
    }

    public void setQueryTimeout(int max) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setQueryTimeout";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{max};
            this.primaryStatement.setQueryTimeout(max);
            if (this.tcStatement != null) {
                this.tcStatement.setQueryTimeout(max);
            }
        }
    }

    public int getQueryTimeout() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            int n = statement.getQueryTimeout();
            return n;
        }
    }

    public void setMaxRows(int max) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setMaxRows";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{max};
            this.primaryStatement.setMaxRows(max);
            if (this.tcStatement != null) {
                this.tcStatement.setMaxRows(max);
            }
        }
    }

    public int getMaxRows() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            int n = statement.getMaxRows();
            return n;
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setMaxFieldSize";
            Class[] argsType = new Class[]{Integer.TYPE};
            Object[] args = new Object[]{max};
            this.primaryStatement.setMaxFieldSize(max);
            if (this.tcStatement != null) {
                this.tcStatement.setMaxFieldSize(max);
            }
        }
    }

    public int getMaxFieldSize() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            int n = statement.getMaxFieldSize();
            return n;
        }
    }

    public void setFixedString(boolean fixedString) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            String methodName = "setFixedString";
            Class[] argsType = new Class[]{Boolean.TYPE};
            Object[] args = new Object[]{fixedString};
            this.primaryStatement.setFixedString(fixedString);
            if (this.tcStatement != null) {
                this.tcStatement.setFixedString(fixedString);
            }
        }
    }

    public boolean getFixedString() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = this.getDelegateStatement();
            boolean bl = statement.getFixedString();
            return bl;
        }
    }

    public void closeWithKey(String key) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("closeWithKey").fillInStackTrace();
    }

    public int getcacheState() {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();
        try {
            int n = this.getDelegateStatement().getcacheState();
            if (lock != null) {
                lock.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException ex) {
                return NON_CACHED;
            }
        }
    }

    public boolean isPoolable() throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        return false;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="setShardingKeyRpnTokens", args={byte[].class}), @Signature(name="getShardingKeyRpnTokens", args={}), @Signature(name="setCursorName", args={String.class}), @Signature(name="getserverCursor", args={})})
    protected void preUnsupportedStatementMethods(Method m, Object receiver, Object ... args) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public Connection getConnection() throws SQLException {
        return (Connection)this.getCreator();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet result;
        block9: {
            result = null;
            AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OracleStatement statement = (OracleStatement)this.getDelegate();
                if (statement != null) {
                    result = statement.getGeneratedKeys();
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                        if (this.currentResultSet == null) {
                            this.currentResultSet = (AbstractTrueCacheResultSet)((Object)result);
                        }
                    }
                    break block9;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet result;
        block8: {
            result = null;
            AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OracleStatement statement = this.getDelegateStatement();
                if (statement != null) {
                    result = statement.getResultSet();
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                        this.currentResultSet = (AbstractTrueCacheResultSet)((Object)result);
                    }
                    break block8;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    public boolean getMoreResults() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                boolean bl = statement.getMoreResults();
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                boolean bl = statement.getMoreResults(current);
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean isNCHAR(int columnIndex) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                boolean bl = statement.isNCHAR(columnIndex);
                return bl;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public String[] getRegisteredTableNames() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                String[] stringArray = statement.getRegisteredTableNames();
                return stringArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getRegisteredQueryId() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                long l = statement.getRegisteredQueryId();
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public int getUpdateCount() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                int n = statement.getUpdateCount();
                return n;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getQueryId() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                long l = statement.getQueryId();
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public byte[] getCompileKey() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                byte[] byArray = statement.getCompileKey();
                return byArray;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public long getChecksum() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                long l = statement.getChecksum();
                return l;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public OracleStatement.SqlKind getSqlKind() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                OracleStatement.SqlKind sqlKind = statement.getSqlKind();
                return sqlKind;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                SQLWarning sQLWarning = statement.getWarnings();
                return sQLWarning;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
        }
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.ensureOpen();
        return this.resultSetType.getConcur();
    }

    public int getResultSetType() throws SQLException {
        this.ensureOpen();
        return this.resultSetType.getType();
    }

    public int getResultSetHoldability() throws SQLException {
        this.ensureOpen();
        return 1;
    }

    public int getstatementType() {
        return this.statementType;
    }

    public void cancel() throws SQLException {
        OracleStatement statement = (OracleStatement)this.getDelegate();
        if (statement != null) {
            statement.cancel();
        }
    }

    public void closeOnCompletion() throws SQLException {
        this.ensureOpen();
        this.isCloseOnCompletion = true;
    }

    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureOpen();
        return this.isCloseOnCompletion;
    }

    public void addBatch(String sql) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.ensureOpen();
            this.addBatchItem(sql);
        }
    }

    public void clearBatch() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OracleStatement statement = (OracleStatement)this.getDelegate();
            if (statement != null) {
                statement.clearBatch();
            } else {
                this.clearBatchCritical();
            }
        }
    }

    public int[] executeBatch() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        OracleStatement statement = null;
        try {
            Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();
            try {
                Object object;
                statement = this.getDelegateStatement();
                this.setDelegate(statement);
                if (this.m_batchItems != null) {
                    object = this.m_batchItems.iterator();
                    while (object.hasNext()) {
                        String sql = (String)object.next();
                        statement.addBatch(sql);
                    }
                }
                object = statement.executeBatch();
                if (lock != null) {
                    lock.close();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.clearBatchItems();
        }
    }

    protected ResultSet createResultSetProxy(ResultSet rs) throws SQLException {
        return TrueCacheDriverExtension.PROXY_FACTORY.proxyForCreate(rs, this);
    }

    protected OracleStatement createStatement(OracleConnection connection) throws SQLException {
        return (OracleStatement)connection.createStatement(this.resultSetType.getType(), this.resultSetType.getConcur());
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.getCreator();
    }

    final void ensureOpen() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        if (applicationConnection.lifecycle != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    void addBatchItem(String sql) {
        if (this.m_batchItems == null) {
            this.m_batchItems = new Vector();
        }
        this.m_batchItems.addElement(sql);
    }

    void clearBatchCritical() throws SQLException {
        this.ensureOpen();
        this.clearBatchItems();
    }

    void clearBatchItems() {
        if (this.m_batchItems != null) {
            this.m_batchItems.removeAllElements();
        }
    }

    protected void appendCallEntry(CallHistoryEntry entry) {
        entry.prevEntry = this.tail;
        entry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = entry;
        }
        this.tail = entry;
        if (this.head == null) {
            this.head = entry;
        }
    }

    protected void removeCallEntry(CallHistoryEntry entry) {
        if (entry.nextEntry != null) {
            entry.nextEntry.prevEntry = entry.prevEntry;
        }
        if (entry.prevEntry != null) {
            entry.prevEntry.nextEntry = entry.nextEntry;
        }
        if (this.head == entry) {
            this.head = entry.nextEntry;
        }
        if (this.tail == entry) {
            this.tail = entry.prevEntry;
        }
    }

    protected void purgeCallEntries() {
        this.head = null;
        this.tail = null;
    }

    boolean closeByDependent(OracleConnection connection) throws SQLException {
        if (this.isCloseOnCompletion && (this.currentResultSet == null || this.currentResultSet.isComplete())) {
            this.close();
            return true;
        }
        return false;
    }

    private OracleStatement getDelegateStatement() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        return applicationConnection.isReadOnly() && applicationConnection.isTrueCacheConnectionAvailable() && this.tcStatement != null ? this.tcStatement : this.primaryStatement;
    }

    static class SetterCallHistoryEntry {
        CallHistoryEntry callHistoryEnrty;
        Object originalValue;

        SetterCallHistoryEntry(Object originalValue, String methodName, Class<?>[] argsType, Object[] args) {
            this.originalValue = originalValue;
            this.callHistoryEnrty = new CallHistoryEntry(methodName, argsType, args);
        }
    }

    static class CallHistoryEntry {
        String methodName;
        Class<?>[] argsType;
        Object[] args;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;

        CallHistoryEntry(String methodName, Class<?>[] argsType, Object[] args) {
            this.methodName = methodName;
            this.argsType = argsType;
            this.args = args;
        }
    }
}

