/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.xa.OracleXAResource;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAHeteroConnection
extends OracleXAConnection {
    private int rmid = -1;
    private String xaCloseString = null;

    public OracleXAHeteroConnection() throws XAException {
    }

    public OracleXAHeteroConnection(Connection connection) throws XAException {
        super(connection);
    }

    @Override
    public synchronized XAResource getXAResource() {
        try {
            if (this.xaResource == null) {
                this.xaResource = new OracleXAHeteroResource((Connection)this.physicalConn, this);
                ((OracleXAHeteroResource)this.xaResource).setRmid(this.rmid);
                if (this.logicalHandle != null) {
                    ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                }
            }
        }
        catch (XAException xAException) {
            this.xaResource = null;
        }
        return this.xaResource;
    }

    synchronized void setRmid(int n2) {
        this.rmid = n2;
    }

    synchronized int getRmid() {
        return this.rmid;
    }

    synchronized void setXaCloseString(String string) {
        this.xaCloseString = string;
    }

    synchronized String getXaCloseString() {
        return this.xaCloseString;
    }
}

