/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.DatabaseSessionState;
import oracle.jdbc.internal.StateSignatures;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIosesstemplate
extends T4CTTIfun {
    private StateSignatures stateSignatures;
    private long templateId;
    private byte[] fullOverflow;
    private List<byte[]> deltaOverflows;

    T4CTTIosesstemplate(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)17);
        this.setFunCode((short)164);
    }

    /*
     * Enabled aggressive block sorting
     */
    void doOSESSTEMPLATE(DatabaseSessionState databaseSessionState) throws IOException, SQLException {
        this.stateSignatures = databaseSessionState.getStateSignatures();
        this.templateId = databaseSessionState.getId();
        this.fullOverflow = databaseSessionState.getCheckpoint();
        this.deltaOverflows = databaseSessionState.getUpdates();
        if (this.templateId == 0L) {
            if (this.fullOverflow == null) return;
            if (this.fullOverflow.length == 0) {
                return;
            }
        }
        this.doPigRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB8(this.stateSignatures.getSignatureFlags());
        this.meg.marshalUB8(this.stateSignatures.getClientSignature());
        this.meg.marshalUB8(this.stateSignatures.getServerSignature());
        this.meg.marshalUB4(this.stateSignatures.getVersion());
        this.meg.marshalUB8(this.templateId);
        this.meg.marshalPTR();
        this.meg.marshalUB4(1L);
        if (this.fullOverflow != null && this.fullOverflow.length > 0) {
            this.meg.marshalUB4(this.fullOverflow.length);
            this.meg.marshalCLR(this.fullOverflow, 0, this.fullOverflow.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

