/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.rsi.RSIException;
import oracle.rsi.ReactiveStreamsIngestion;
import oracle.rsi.StreamEntity;
import oracle.rsi.StreamField;
import oracle.rsi.internal.IngestSuite;
import oracle.rsi.internal.Metadata;
import oracle.rsi.logging.ClioSupport;

@Supports(value={Feature.RSI_TRACE})
public class RSIBuilder
implements ReactiveStreamsIngestion.Builder,
Cloneable {
    private static final int DB_SHARD_CATALOG = 4;
    private static final int DEFAULT_BUFFER_INTERVAL_DURATION_SECONDS = 5;
    private DatabaseType dbType = DatabaseType.NON_SHARDED;
    String dbUrl = null;
    String dbUser = null;
    String dbSchema = null;
    OpaqueString dbPassword = null;
    String shardedDbGlobalServiceName = null;
    String tableName = null;
    private String normalizedTableName = null;
    String[] columns = null;
    String[] normalizedColumns = null;
    Class<?> entityClass = null;
    Field[] fields = null;
    Method[] methods = null;
    boolean isUpsert = false;
    boolean isUseDP = false;
    boolean isUseDPParallel = false;
    boolean isUseDPNoLog = false;
    boolean isUseDPSkipUnusableIndexes = false;
    boolean isUseDPSkipIndexMaintenance = false;
    int maxRowsToBuffer = 0;
    Duration bufferInterval = Duration.ofSeconds(0L);
    Executor executor = null;
    Function<byte[], Object> transformer = null;
    Metadata dbMetadata;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;

    @Override
    public ReactiveStreamsIngestion.Builder url(String string) {
        if (this.dbUrl != null) {
            throw new IllegalStateException("The database url is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database url cannot be null.");
        }
        this.dbUrl = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder username(String string) {
        if (this.dbUser != null) {
            throw new IllegalStateException("The database username is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database username cannot be null.");
        }
        this.dbUser = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder schema(String string) {
        if (this.dbSchema != null) {
            throw new IllegalStateException("The database schema is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database schema cannot be null.");
        }
        this.dbSchema = string.toUpperCase();
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder password(@Blind String string) {
        if (this.dbPassword != null) {
            throw new IllegalStateException("The database password is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database password cannot be null.");
        }
        this.dbPassword = OpaqueString.newOpaqueString((String)string);
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder globalServiceName(String string) {
        if (this.shardedDbGlobalServiceName != null) {
            throw new IllegalStateException("The global service name is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The global service name cannot be null.");
        }
        this.shardedDbGlobalServiceName = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder executor(Executor executor) {
        if (this.executor != null) {
            throw new IllegalStateException("The thread pool instance is already set.");
        }
        if (executor == null) {
            throw new IllegalStateException("The thread pool instance cannot be null.");
        }
        this.executor = executor;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder bufferRows(int n) {
        if (this.maxRowsToBuffer != 0) {
            throw new IllegalStateException("Number of rows allowed to buffer is already set.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Number of rows allowed to buffer cannot be zero or negative.");
        }
        this.maxRowsToBuffer = n;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder bufferInterval(Duration duration) {
        if (!this.bufferInterval.isZero()) {
            throw new IllegalStateException("Buffer interval is already set.");
        }
        Duration duration2 = Duration.ofSeconds(2L);
        this.bufferInterval = duration.compareTo(duration2) < 0 ? duration2 : duration;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder transformer(Function<byte[], Object> function) {
        if (this.transformer != null) {
            throw new IllegalStateException("The transformer instance is already set.");
        }
        if (function == null) {
            throw new IllegalArgumentException("The transformer instance cannot be null.");
        }
        this.transformer = function;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder table(String string) {
        if (this.tableName != null) {
            throw new IllegalStateException("The database table name is already set.");
        }
        if (string == null) {
            throw new IllegalArgumentException("The database table name cannot be null.");
        }
        this.tableName = string;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder columns(String[] stringArray) {
        if (this.columns != null) {
            throw new IllegalStateException("Column names are already set.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Column names cannot be null.");
        }
        this.columns = stringArray;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder entity(Class<?> clazz) {
        if (this.entityClass != null) {
            throw new IllegalArgumentException("The mapping class is already set.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The mapping class cannot be bull.");
        }
        this.entityClass = clazz;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder doUpsert() {
        if (this.isUpsert) {
            throw new IllegalStateException("UPSERT is already enabled.");
        }
        if (this.isUseDP) {
            throw new IllegalStateException("Cannot use Direct Path load for Upsert.");
        }
        this.isUpsert = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPath() {
        if (this.isUseDP) {
            throw new IllegalStateException("The Direct Path load is already enabled.");
        }
        if (this.isUpsert) {
            throw new IllegalStateException("Cannot use Direct Path load for Upsert.");
        }
        this.isUseDP = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathParallel() {
        if (this.isUseDPParallel) {
            throw new IllegalStateException("The Direct Path PARALLEL statement option is already enabled.");
        }
        this.isUseDPParallel = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathNoLog() {
        if (this.isUseDPNoLog) {
            throw new IllegalStateException("The Direct Path NOLOG statement option is already enabled.");
        }
        this.isUseDPNoLog = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathSkipUnusableIndexes() {
        if (this.isUseDPSkipUnusableIndexes) {
            throw new IllegalStateException("The Direct Path SKIP_UNUSABLE_INDEXES statement option is already enabled.");
        }
        this.isUseDPSkipUnusableIndexes = true;
        return this;
    }

    @Override
    public ReactiveStreamsIngestion.Builder useDirectPathSkipIndexMaintenance() {
        if (this.isUseDPSkipIndexMaintenance) {
            throw new IllegalStateException("The Direct Path SKIP_INDEX_MAINTENANCE statement option is already enabled.");
        }
        this.isUseDPSkipIndexMaintenance = true;
        return this;
    }

    private void validateAndReadMappingClass() {
        if (this.entityClass != null) {
            String string;
            if (this.tableName != null) {
                throw new IllegalStateException("Redundant parameter - table name. The mapping class is already supplied.");
            }
            if (this.columns != null) {
                throw new IllegalStateException("Redundant parameter - column names. The mapping class is already supplied.");
            }
            StreamEntity streamEntity = this.entityClass.getAnnotation(StreamEntity.class);
            this.tableName = string = streamEntity.tableName().isEmpty() ? this.entityClass.getSimpleName() : streamEntity.tableName();
            this.fields = (Field[])Stream.of(this.entityClass.getDeclaredFields()).filter(field -> field.getAnnotation(StreamField.class) != null).map(field -> {
                field.setAccessible(true);
                return field;
            }).toArray(Field[]::new);
            Stream<String> stream = Stream.of(this.fields).map(field -> field.getAnnotation(StreamField.class).columnName().isBlank() ? field.getName() : field.getAnnotation(StreamField.class).columnName());
            this.methods = (Method[])Stream.of(this.entityClass.getDeclaredMethods()).filter(method -> method.getAnnotation(StreamField.class) != null).toArray(Method[]::new);
            Stream<String> stream2 = Stream.of(this.methods).map(method -> method.getAnnotation(StreamField.class).columnName().isBlank() ? (method.getName().matches("get(.*)") ? method.getName().substring(3) : method.getName()) : method.getAnnotation(StreamField.class).columnName());
            this.columns = (String[])Stream.concat(stream, stream2).toArray(String[]::new);
        }
    }

    private final String normalizeSchemaObjectAndGet(String string, boolean bl) {
        String string2;
        Object object;
        String string3 = "ACCESS|ADD|ALL|ALTER|AND|ANY|AS|ASC|AUDIT|BETWEEN|BY|CHAR|CHECK|CLUSTER|COLUMN|COMMENT|COMPRESS|CONNECT|CREATE|CURRENT|DATE|DECIMAL|DEFAULT|DELETE|DESC|DISTINCT|DROP|ELSE|EXCLUSIVE|EXISTS|FILE|FLOAT|FOR|FROM|GRANT|GROUP|HAVING|IDENTIFIED|IMMEDIATE|IN|INCREMENT|INDEX|INITIAL|INSERT|INTEGER|INTERSECT|INTO|IS|LEVEL|LIKE|LOCK|LONG|MAXEXTENTS|MINUS|MLSLABEL|MODE|MODIFY|NOAUDIT|NOCOMPRESS|NOT|NOWAIT|NULL|NUMBER|OF|OFFLINE|ON|ONLINE|OPTION|OR|ORDER|PCTFREE|PRIOR|PUBLIC|RAW|RENAME|RESOURCE|REVOKE|ROW|ROWID|ROWNUM|ROWS|SELECT|SESSION|SET|SHARE|SIZE|SMALLINT|START|SUCCESSFUL|SYNONYM|SYSDATE|TABLE|THEN|TO|TRIGGER|UID|UNION|UNIQUE|UPDATE|USER|VALIDATE|VALUES|VARCHAR|VARCHAR2|VIEW|WHENEVER|WHERE|WITH";
        String string4 = string3 + "|COLUMN_VALUE|IS|NESTED_TABLE_ID";
        Object object2 = object = bl ? string4 : string3;
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            string2 = string.toUpperCase();
            if (!string2.matches("^[a-zA-Z][a-zA-Z0-9_]*$") || string.matches((String)object)) {
                String string5 = "Invalid schema object name: " + string + ".";
                ClioSupport.ilogSevere(Logger.getLogger(this.getClass().getName()), null, null, null, string5);
                throw new RSIException(string5);
            }
        } else {
            string2 = string.replaceAll("^\"|\"$", "");
            if (string2.matches("^.*[\"|\u0000].*$") || bl && string2.equals("ROWID")) {
                String string6 = "Invalid schema object name: " + string + ".";
                ClioSupport.ilogSevere(Logger.getLogger(this.getClass().getName()), null, null, null, string6);
                throw new RSIException(string6);
            }
        }
        return string2;
    }

    private void normalizeTableNameAndColumns() {
        this.normalizedTableName = this.normalizeSchemaObjectAndGet(this.tableName, false);
        this.normalizedColumns = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            this.normalizedColumns[i] = this.normalizeSchemaObjectAndGet(this.columns[i], true);
        }
    }

    private void configureDefaults() {
        if (this.columns == null || this.columns.length == 0) {
            ClioSupport.ilogSevere(Logger.getLogger(this.getClass().getName()), null, null, null, "Columns cannot be null or empty.");
            throw new RSIException("Columns cannot be null or empty.");
        }
        this.executor = this.executor != null ? this.executor : ForkJoinPool.commonPool();
        this.bufferInterval = this.bufferInterval.isZero() ? Duration.ofSeconds(5L) : this.bufferInterval;
    }

    private void initDatabaseType(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT GSMADMIN_INTERNAL.GETSHARDINGMODE FROM DUAL");){
            int n;
            if (resultSet.next() && ((n = resultSet.getInt(1)) & 4) != 0) {
                this.dbType = DatabaseType.SHARDED;
                if (this.shardedDbGlobalServiceName == null) {
                    ClioSupport.ilogSevere(Logger.getLogger(this.getClass().getName()), null, null, null, "Global Service Name cannot be null.");
                    throw new RSIException("Global Service Name cannot be null.");
                }
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 904) {
                ClioSupport.ilogInfo(Logger.getLogger(this.getClass().getName()), null, null, null, sQLException.getMessage() + ". Defaulting the database type to Non-Sharded.");
            }
            throw sQLException;
        }
    }

    private void initDbMetadata(Connection connection) {
        this.dbMetadata = Metadata.getMetadata(this.normalizedTableName, this.dbSchema, connection);
    }

    private void init() throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword.get());){
            this.initDatabaseType(connection);
            this.initDbMetadata(connection);
        }
    }

    @Override
    public ReactiveStreamsIngestion build() throws RSIException {
        this.validateAndReadMappingClass();
        this.normalizeTableNameAndColumns();
        this.configureDefaults();
        try {
            this.init();
            if (this.dbType.equals((Object)DatabaseType.SHARDED)) {
                ClioSupport.ilogInfo(Logger.getLogger(this.getClass().getName()), null, null, null, "Database type is Sharded.");
                return IngestSuite.newIngestSuiteForShardedDatabase(this);
            }
            ClioSupport.ilogInfo(Logger.getLogger(this.getClass().getName()), null, null, null, "Database type is non-sharded.");
            if (this.dbMetadata.getTable().isPartitioned()) {
                ClioSupport.ilogInfo(Logger.getLogger(this.getClass().getName()), null, null, null, "Table is partitioned.");
                return IngestSuite.newIngestSuiteForPartitionedTable(this);
            }
            return IngestSuite.newIngestSuiteForNonShardedDatabase(this);
        }
        catch (Exception exception) {
            RSIException rSIException = new RSIException(exception.getMessage(), exception.getCause());
            ClioSupport.ilogSevere(Logger.getLogger(this.getClass().getName()), null, null, null, rSIException.getMessage());
            throw rSIException;
        }
    }

    static {
        try {
            $$$methodRef$$$34 = RSIBuilder.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$33 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$0", Field.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$32 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$1", Field.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$31 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$30 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$3", Field.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$29 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$4", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$28 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$5", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$27 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$6", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$26 = RSIBuilder.class.getDeclaredMethod("lambda$validateAndReadMappingClass$7", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$25 = RSIBuilder.class.getDeclaredMethod("build", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$24 = RSIBuilder.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$23 = RSIBuilder.class.getDeclaredMethod("initDbMetadata", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$22 = RSIBuilder.class.getDeclaredMethod("initDatabaseType", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$21 = RSIBuilder.class.getDeclaredMethod("configureDefaults", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$20 = RSIBuilder.class.getDeclaredMethod("normalizeTableNameAndColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$19 = RSIBuilder.class.getDeclaredMethod("normalizeSchemaObjectAndGet", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$18 = RSIBuilder.class.getDeclaredMethod("validateAndReadMappingClass", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$17 = RSIBuilder.class.getDeclaredMethod("useDirectPathSkipIndexMaintenance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$16 = RSIBuilder.class.getDeclaredMethod("useDirectPathSkipUnusableIndexes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$15 = RSIBuilder.class.getDeclaredMethod("useDirectPathNoLog", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$14 = RSIBuilder.class.getDeclaredMethod("useDirectPathParallel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$13 = RSIBuilder.class.getDeclaredMethod("useDirectPath", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$12 = RSIBuilder.class.getDeclaredMethod("doUpsert", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$11 = RSIBuilder.class.getDeclaredMethod("entity", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$10 = RSIBuilder.class.getDeclaredMethod("columns", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$9 = RSIBuilder.class.getDeclaredMethod("table", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$8 = RSIBuilder.class.getDeclaredMethod("transformer", Function.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$7 = RSIBuilder.class.getDeclaredMethod("bufferInterval", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$6 = RSIBuilder.class.getDeclaredMethod("bufferRows", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$5 = RSIBuilder.class.getDeclaredMethod("executor", Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$4 = RSIBuilder.class.getDeclaredMethod("globalServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$3 = RSIBuilder.class.getDeclaredMethod("password", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$2 = RSIBuilder.class.getDeclaredMethod("schema", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$1 = RSIBuilder.class.getDeclaredMethod("username", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
        try {
            $$$methodRef$$$0 = RSIBuilder.class.getDeclaredMethod("url", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
    }

    private static final class DatabaseType
    extends Enum<DatabaseType> {
        public static final /* enum */ DatabaseType NON_SHARDED;
        public static final /* enum */ DatabaseType SHARDED;
        private static final /* synthetic */ DatabaseType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static DatabaseType[] values() {
            return (DatabaseType[])$VALUES.clone();
        }

        public static DatabaseType valueOf(String string) {
            return Enum.valueOf(DatabaseType.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = DatabaseType.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$1 = DatabaseType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            try {
                $$$methodRef$$$0 = DatabaseType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.rsi");
            NON_SHARDED = new DatabaseType();
            SHARDED = new DatabaseType();
            $VALUES = new DatabaseType[]{NON_SHARDED, SHARDED};
        }
    }
}

