/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.ONSDatabaseEventHandlerTask;
import oracle.ucp.jdbc.oracle.ONSRuntimeLBEventHandlerTask;
import oracle.ucp.jdbc.oracle.OracleDatabaseInstanceInfo;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleFailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerFactory;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleJDBCConnectionPool
extends JDBCConnectionPool
implements RACManagerImpl.RACCallbackExtended {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleJDBCConnectionPool.class.getCanonicalName());
    private final AtomicReference<String> m_onsConfigurationString = new AtomicReference<String>("");
    RACManager m_racManager = null;
    private final StringBuilder m_errorInfo = new StringBuilder(512);
    int m_markedToCloseConnCount = 0;
    int m_tornDownConnCount = 0;
    private boolean isAffinityConn = false;

    public OracleJDBCConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void start() throws UniversalConnectionPoolException {
        JDBCUniversalPooledConnection conn;
        super.start();
        String sqlStr = this.getSQLForValidateConnection();
        if (this.getValidateConnectionOnBorrow() && null != sqlStr && !"".equals(sqlStr) && null != (conn = (JDBCUniversalPooledConnection)this.createOnePooledConnection())) {
            boolean invalidSQL;
            block14: {
                Statement stmt;
                block13: {
                    invalidSQL = false;
                    stmt = null;
                    stmt = conn.getSQLConnection(conn.getPhysicalConnection()).createStatement();
                    stmt.execute(sqlStr);
                    Object var12_5 = null;
                    if (null == stmt) break block13;
                    try {
                        stmt.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                this.closePhysicalConnection(conn.getPhysicalConnection());
                {
                    break block14;
                    catch (SQLException e) {
                        int err = e.getErrorCode();
                        for (int perr : this.getWrongSQLCodes()) {
                            if (perr != err) continue;
                            this.setValidateConnectionOnBorrow(false);
                            invalidSQL = true;
                            break;
                        }
                        Object var12_6 = null;
                        if (null != stmt) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                        }
                        this.closePhysicalConnection(conn.getPhysicalConnection());
                    }
                }
                catch (Throwable throwable) {
                    Object var12_7 = null;
                    if (null != stmt) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    this.closePhysicalConnection(conn.getPhysicalConnection());
                    throw throwable;
                }
            }
            if (invalidSQL) {
                UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(151);
                logger.throwing(this.getClass().getName(), "start", ucpe);
                throw ucpe;
            }
        }
    }

    @Override
    public synchronized void purge() throws UniversalConnectionPoolException {
        for (UniversalPooledConnection upc : this.getAllBorrowedConnections()) {
            this.abortConnection(upc);
        }
        super.purge();
    }

    @Override
    public void setFailoverEnabled(boolean enabled) throws UniversalConnectionPoolException {
        super.setFailoverEnabled(enabled);
        if (this.m_racManager == null) {
            this.m_racManager = RACManagerFactory.getRACManager(null, UniversalConnectionPoolManagerBase.getTaskManager(), UniversalConnectionPoolManagerBase.getTimerManager());
            ConnectionAffinityCallback affCbk = this.getConnectionAffinityCallback();
            if (affCbk != null) {
                this.m_racManager.registerConnectionAffinityCallback(affCbk);
            }
        }
        this.m_racManager.registerRACCallback(this);
        String onsConfig = this.m_onsConfigurationString.get();
        if (onsConfig != null && !onsConfig.equals("")) {
            this.m_racManager.setONSConfiguration(onsConfig);
        }
    }

    @Override
    protected synchronized void startFailover() throws UniversalConnectionPoolException {
        logger.finest("start failover");
        this.m_racManager.start();
    }

    @Override
    protected synchronized void stopFailover() throws UniversalConnectionPoolException {
        logger.finest("stop failover");
        this.m_racManager.stop();
    }

    protected void setFailoverEventHandlerTask(ONSDatabaseEventHandlerTask failoverEventHandlerTask) {
        logger.log(Level.FINEST, "failoverEventHandlerTask: {0}", failoverEventHandlerTask);
        RACManagerImpl racMngr = (RACManagerImpl)this.m_racManager;
        racMngr.setFailoverEventHandlerTask(failoverEventHandlerTask);
    }

    @Override
    public boolean isRuntimeLoadBalancingEnabled() {
        if (this.m_racManager != null) {
            return this.m_racManager.isRuntimeLoadBalancingEnabled();
        }
        return false;
    }

    protected void setRuntimeLoadBalancingEventHandlerTask(ONSRuntimeLBEventHandlerTask rlbEventHandlerTask) {
        logger.log(Level.FINEST, "runtimeLoadBalancingEventHandlerTask: {0}", rlbEventHandlerTask);
        RACManagerImpl racMngr = (RACManagerImpl)this.m_racManager;
        racMngr.setRuntimeLoadBalancingEventHandlerTask(rlbEventHandlerTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDownConnectionsForInstance(OracleDatabaseInstanceInfo dbInstance, int numConnectionsToTearDown) {
        logger.log(Level.FINEST, "{0}, {1}, {2}", new Object[]{this, dbInstance.getInstanceName(), numConnectionsToTearDown});
        int tearDownCount = numConnectionsToTearDown;
        int _tornDownAvailConnCount = 0;
        int _markedToCloseCount = 0;
        OracleJDBCConnectionPool oracleJDBCConnectionPool = this;
        synchronized (oracleJDBCConnectionPool) {
            boolean _sucProcessingOneConn;
            int i;
            UniversalPooledConnection[] conns = this.getAvailableConnections();
            for (i = 0; i < conns.length && tearDownCount > 0; ++i) {
                _sucProcessingOneConn = true;
                if (!(conns[i] instanceof OracleFailoverablePooledConnection) || !this.failoverServiceEventMatch((OracleFailoverablePooledConnection)((Object)conns[i]), dbInstance.getInstanceName(), dbInstance.getDatabaseName())) continue;
                _sucProcessingOneConn = FailoverActionResult.FAILED != this.processFailoverAction(conns[i], true, false, 0);
                boolean bl = _sucProcessingOneConn = _sucProcessingOneConn && FailoverActionResult.FAILED != this.processFailoverAction(conns[i], true, false, 1);
                if (!_sucProcessingOneConn) continue;
                --tearDownCount;
                ++_tornDownAvailConnCount;
            }
            this.m_tornDownConnCount += _tornDownAvailConnCount;
            if (tearDownCount > 0) {
                conns = this.getAllBorrowedConnections();
                for (i = 0; i < conns.length && tearDownCount > 0; ++i) {
                    _sucProcessingOneConn = true;
                    if (!(conns[i] instanceof OracleFailoverablePooledConnection) || !this.failoverServiceEventMatch((OracleFailoverablePooledConnection)((Object)conns[i]), dbInstance.getInstanceName(), dbInstance.getDatabaseName())) continue;
                    try {
                        conns[i].setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        --tearDownCount;
                    }
                    catch (UniversalConnectionPoolException ucpe) {
                        logger.log(Level.FINEST, "Borrowed connection tearing failed when setting status", this.getStackTraceString(ucpe));
                        this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                        _sucProcessingOneConn = false;
                    }
                    if (!_sucProcessingOneConn) continue;
                    ++_markedToCloseCount;
                }
                this.m_markedToCloseConnCount += _markedToCloseCount;
            }
        }
        logger.log(Level.FINEST, "Connection tearing target: {0}, available torn: {1}, borrowed marked to close: {2}", new Object[]{numConnectionsToTearDown, _tornDownAvailConnCount, _markedToCloseCount});
    }

    private String getStackTraceString(Throwable exc) {
        StringWriter stackTraceWriter = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(stackTraceWriter);
        exc.printStackTrace(pw);
        return ((Object)stackTraceWriter).toString();
    }

    private boolean failoverServiceEventMatch(OracleFailoverablePooledConnection pooledConnection, String instanceName, String dbUniqueName) {
        logger.log(Level.FINEST, "{0}, {1}, {2}", new Object[]{pooledConnection, instanceName, dbUniqueName});
        if (instanceName == null) {
            return true;
        }
        String pcDbUniqueName = pooledConnection.getDbUniqueName();
        String pcDataSourceInstanceName = pooledConnection.getDataSourceInstanceName();
        if (pcDataSourceInstanceName == null || pcDbUniqueName == null) {
            return false;
        }
        return instanceName.equals(pcDataSourceInstanceName) && dbUniqueName.equals(pcDbUniqueName);
    }

    private FailoverActionResult processFailoverAction(UniversalPooledConnection pc, boolean isAvailableConnection, boolean isPlannedDownEvent, int actionFlag) {
        logger.log(Level.FINEST, "{0}, {1}, {2}, {3}", new Object[]{pc, isAvailableConnection, isPlannedDownEvent, actionFlag});
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                try {
                    if (!isAvailableConnection && isPlannedDownEvent) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    logger.log(Level.FINEST, "setting status failed: ", this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                try {
                    this.abortConnection(pc);
                }
                catch (Exception exc) {
                    logger.log(Level.FINEST, "aborting connection failed: ", this.getStackTraceString(exc));
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    if (isAvailableConnection) {
                        this.removeAndCloseOneAvailableConnection(pc);
                    } else {
                        this.closeConnection(pc);
                    }
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    logger.log(Level.FINEST, "closing connection failed: ", this.getStackTraceString(ucpe));
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }

    @Override
    protected UniversalPooledConnection selectConnectionPerRuntimeLoadBalancing(ConnectionRetrievalInfo cri) {
        logger.log(Level.FINEST, "ConnectionRetrievalInfo: {0}", cri);
        if (this.m_racManager != null) {
            try {
                return (OracleUniversalPooledConnection)this.m_racManager.selectConnectionPerRCLB(cri);
            }
            catch (UniversalConnectionPoolException ucpexc) {
                logger.log(Level.FINEST, "selectConnectionPerRCLB: ", ucpexc);
                return null;
            }
        }
        return null;
    }

    @Override
    public synchronized void registerConnectionAffinityCallback(ConnectionAffinityCallback affCbk) throws UniversalConnectionPoolException {
        super.registerConnectionAffinityCallback(affCbk);
        if (this.m_racManager != null) {
            this.m_racManager.registerConnectionAffinityCallback(affCbk);
        }
    }

    @Override
    public synchronized void removeConnectionAffinityCallback() throws UniversalConnectionPoolException {
        super.removeConnectionAffinityCallback();
        if (this.m_racManager != null) {
            this.m_racManager.unregisterConnectionAffinityCallback(this.getConnectionAffinityCallback());
        }
    }

    @Override
    protected UniversalPooledConnection selectConnectionPerRuntimeLoadBalancingAndAffinity(ConnectionRetrievalInfo cri) {
        if (this.m_racManager != null) {
            try {
                return (OracleUniversalPooledConnection)this.m_racManager.selectConnectionPerRCLBAndAffinity(cri);
            }
            catch (UniversalConnectionPoolException ucpexc) {
                logger.log(Level.FINEST, "selectConnectionPerRCLBAndAffinity: ", ucpexc);
                return null;
            }
        }
        return null;
    }

    UniversalPooledConnection getConnectionToNamedInstance() {
        return this.createOnePooledConnection();
    }

    public String getONSConfiguration() throws UniversalConnectionPoolException {
        return this.m_racManager.getONSConfiguration();
    }

    public void setONSConfiguration(String onsConfigStr) throws UniversalConnectionPoolException {
        String oldOnsConfigStr;
        logger.log(Level.FINEST, "onsConfigStr: {0}", Util.maskONSConfigurationString(onsConfigStr));
        if (onsConfigStr == null) {
            onsConfigStr = "";
        }
        if (onsConfigStr.equals(oldOnsConfigStr = this.m_onsConfigurationString.getAndSet(onsConfigStr))) {
            return;
        }
        if (this.m_racManager != null) {
            this.m_racManager.setONSConfiguration(onsConfigStr);
        }
    }

    @Override
    public OracleJDBCConnectionPoolStatistics getStatistics() {
        return new OracleJDBCConnectionPoolStatisticsImpl(this);
    }

    public long getSuccessfulAffinityBasedBorrowCount() {
        return this.m_racManager.getSuccessfulAffinityBasedBorrowCount();
    }

    public long getFailedAffinityBasedBorrowCount() {
        return this.m_racManager.getFailedAffinityBasedBorrowCount();
    }

    public long getSuccessfulRCLBBasedBorrowCount() {
        return this.m_racManager.getSuccessfulRCLBBasedBorrowCount();
    }

    public long getFailedRCLBBasedBorrowCount() {
        return this.m_racManager.getFailedRCLBBasedBorrowCount();
    }

    public String getFCFProcessingInfo() {
        return this.m_racManager.getFCFProcessingInfo();
    }

    public String getFCFProcessingInfoProcessedOnly() {
        return this.m_racManager.getFCFProcessingInfoProcessedOnly();
    }

    @Override
    protected void processTimedOutConnection(UniversalPooledConnection pc) throws UniversalConnectionPoolException, TaskManagerException {
        logger.log(Level.FINEST, "UniversalPooledConnection: {0}", pc);
        OracleUniversalPooledConnection opc = (OracleUniversalPooledConnection)pc;
        opc.handleTimeout();
    }

    @Override
    public void closePhysicalConnection(final Object physicalConnection) {
        logger.log(Level.FINEST, "physicalConnection: {0}", physicalConnection);
        OracleJDBCConnectionPool.submitWTPTask(new UCPTaskBase(){

            public void run() {
                OracleJDBCConnectionPool.this.superClosePhysicalConnection(physicalConnection);
            }
        });
    }

    private void superClosePhysicalConnection(Object physicalConnection) {
        super.closePhysicalConnection(physicalConnection);
    }

    @Override
    protected void abortConnection(UniversalPooledConnection pooledConnection) throws UniversalConnectionPoolException {
        OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)pooledConnection;
        oupc.abortPhysicalConnection();
    }

    @Override
    protected int[] getWrongSQLCodes() {
        return new int[]{942, 904, 923};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initiateDownEventProcessing(OracleFailoverEvent event) {
        logger.finest("about to raise priority");
        this.raisePriority();
        try {
            try {
                FailoverablePooledConnection[] aconns = this.getAllAvailableFPCs();
                FailoverablePooledConnection[] bconns = this.getAllBorrowedFPCs();
                OracleJDBCConnectionPool oracleJDBCConnectionPool = this;
                synchronized (oracleJDBCConnectionPool) {
                    this.m_racManager.markDownConnectionsForDownEvent(aconns, bconns, event);
                }
                oracleJDBCConnectionPool = this;
                synchronized (oracleJDBCConnectionPool) {
                    this.m_racManager.cleanupConnectionsForDownEvent(aconns, bconns, event);
                }
            }
            catch (Exception exc) {
                logger.throwing(this.getClass().getName(), "callback processDownEvent failed: ", exc);
                Object var8_7 = null;
                logger.finest("about to lower priority to normal");
                this.lowerPriorityToNormal();
                return;
            }
            Object var8_6 = null;
            logger.finest("about to lower priority to normal");
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            logger.finest("about to lower priority to normal");
            this.lowerPriorityToNormal();
            throw throwable;
        }
        this.lowerPriorityToNormal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int initiateUpEventProcessing(OracleFailoverEvent event) {
        int n;
        logger.finest("about to raise priority");
        this.raisePriority();
        try {
            try {
                OracleJDBCConnectionPool oracleJDBCConnectionPool = this;
                synchronized (oracleJDBCConnectionPool) {
                    n = this.m_racManager.processUpEvent(this.getAllAvailableFPCs(), this.getAllBorrowedFPCs(), this.getInitialPoolSize(), this.getMaxPoolSize(), event);
                }
                Object var6_6 = null;
                logger.finest("about to lower priority to normal");
            }
            catch (Exception exc) {
                logger.throwing(this.getClass().getName(), "callback processUpEvent failed: ", exc);
                int n2 = 0;
                Object var6_7 = null;
                logger.finest("about to lower priority to normal");
                this.lowerPriorityToNormal();
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            logger.finest("about to lower priority to normal");
            this.lowerPriorityToNormal();
            throw throwable;
        }
        this.lowerPriorityToNormal();
        return n;
    }

    @Override
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        UniversalPooledConnection upc;
        if (this.isFailoverEnabled() && !this.isAffinityConn) {
            JDBCConnectionFactoryAdapter cfa = (JDBCConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
            String origUrl = cfa.getUrl();
            String instancedUrl = ((RACManagerImpl)this.m_racManager).getUrlForMostDesirableInstanceToGrow(origUrl);
            if (!instancedUrl.equals(origUrl)) {
                logger.finest("instancedUrl=" + instancedUrl);
            }
            cfa.setUrl(instancedUrl);
            upc = super.createOnePooledConnection(connectionRetrievalInfo);
            cfa.setUrl(origUrl);
        } else {
            upc = super.createOnePooledConnection(connectionRetrievalInfo);
        }
        return upc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FailoverablePooledConnection openNewConnection(String url, RACInstance racInstance) {
        if (url == null || url.equals("")) {
            try {
                OracleJDBCConnectionPool oracleJDBCConnectionPool = this;
                synchronized (oracleJDBCConnectionPool) {
                    this.addNewConnections(this.getConnectionRetrievalInfo(), 1);
                }
            }
            catch (Exception exc) {
                logger.throwing(this.getClass().getName(), "callback openNewConnection failed: ", exc);
            }
        } else {
            block11: {
                this.isAffinityConn = true;
                try {
                    JDBCConnectionFactoryAdapter cfa = (JDBCConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
                    FailoverablePooledConnection fpc = null;
                    String originalUrl = cfa.getUrl();
                    String namedInstanceUrl = url;
                    if (namedInstanceUrl == null) break block11;
                    cfa.setUrl(namedInstanceUrl);
                    fpc = (FailoverablePooledConnection)((Object)this.createOnePooledConnection());
                    cfa.setUrl(originalUrl);
                    FailoverablePooledConnection failoverablePooledConnection = fpc;
                    Object var9_11 = null;
                    this.isAffinityConn = false;
                    return failoverablePooledConnection;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    this.isAffinityConn = false;
                    throw throwable;
                }
            }
            logger.log(Level.FINEST, "URL invalid for connecting to named instance");
            Object var9_12 = null;
            this.isAffinityConn = false;
        }
        return null;
    }

    @Override
    public String getUrl() {
        JDBCConnectionFactoryAdapter cfa = (JDBCConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
        return cfa.getUrl();
    }

    @Override
    public String getPoolName() {
        return this.getName();
    }

    @Override
    public int getRoomToGrowPool() {
        return this.roomToGrow();
    }

    @Override
    public boolean isValid(FailoverablePooledConnection fpc) {
        OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)fpc;
        return oupc.isValid();
    }

    protected FailoverablePooledConnection[] getAllAvailableFPCs() {
        UniversalPooledConnection[] upcs = this.getAvailableConnections();
        if (upcs != null) {
            FailoverablePooledConnection[] aconns = new FailoverablePooledConnection[upcs.length];
            int i = 0;
            for (UniversalPooledConnection upc : upcs) {
                aconns[i++] = (FailoverablePooledConnection)((Object)upc);
            }
            return aconns;
        }
        return null;
    }

    protected FailoverablePooledConnection[] getAllBorrowedFPCs() {
        UniversalPooledConnection[] upcs = this.getAllBorrowedConnections();
        if (upcs != null) {
            FailoverablePooledConnection[] bconns = new FailoverablePooledConnection[upcs.length];
            int i = 0;
            for (UniversalPooledConnection upc : upcs) {
                bconns[i++] = (FailoverablePooledConnection)((Object)upc);
            }
            return bconns;
        }
        return null;
    }

    @Override
    public FailoverablePooledConnection getAvailableConnectionToInstance(ConnectionRetrievalInfo cri, RACInstance racInstance) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "cri: {0}, racInstance: {1}", new Object[]{cri, racInstance});
        FailoverablePooledConnection pc = null;
        FailoverablePooledConnection tmpPc = null;
        Collection conns = this.getAvailablePhysicalConnections(cri);
        int sz = conns.size();
        for (UniversalPooledConnection conn : conns) {
            UniversalPooledConnectionStatus status = conn.getStatus();
            if (!status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || !Util.sameOrEqual((tmpPc = (FailoverablePooledConnection)((Object)conn)).getInstance(), racInstance.getInstance()) || !Util.sameOrEqual(tmpPc.getDatabase(), racInstance.getDatabase())) continue;
            pc = tmpPc;
            break;
        }
        logger.log(Level.FINEST, "Returning fpc: {0}, racInstance: {1}", new Object[]{pc, racInstance});
        return pc;
    }

    @Override
    public Collection<FailoverablePooledConnection> getAvailableConnections(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        Collection upcs = this.getAvailablePhysicalConnections(cri);
        HashSet<FailoverablePooledConnection> fpcs = new HashSet<FailoverablePooledConnection>(upcs.size());
        for (UniversalPooledConnection upc : upcs) {
            fpcs.add((FailoverablePooledConnection)((Object)upc));
        }
        return fpcs;
    }

    @Override
    public void lbaEventOccurred(OracleLoadBalancingEvent rlbEvent) throws UniversalConnectionPoolException {
    }

    void setRACManager(RACManagerImpl racMngr) {
        this.m_racManager = racMngr;
    }

    @Override
    protected void onAddingConnectionToPool(UniversalPooledConnection pooledConnection) {
        super.onAddingConnectionToPool(pooledConnection);
        if (this.isFailoverEnabled()) {
            FailoverablePooledConnection fpc = (FailoverablePooledConnection)((Object)pooledConnection);
            try {
                this.m_racManager.connectionOpened(fpc);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onRemovingConnectionFromPool(UniversalPooledConnection pooledConnection) {
        super.onRemovingConnectionFromPool(pooledConnection);
        if (this.isFailoverEnabled()) {
            FailoverablePooledConnection fpc = (FailoverablePooledConnection)((Object)pooledConnection);
            try {
                this.m_racManager.connectionClosed(fpc);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                // empty catch block
            }
        }
    }
}

