/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetProxyFactory
implements InvocationHandler {
    private static final Logger logger = UCPLoggerFactory.createLogger(ResultSetProxyFactory.class.getCanonicalName());
    private final ResultSet m_proxiedResultSet;
    private final Statement m_proxyStatement;
    private final JDBCUniversalPooledConnection m_jdbcPooledConnection;
    private final JDBCConnectionPool m_jdbcConnectionPool;
    private boolean m_closed = false;
    protected final long creationTS = System.currentTimeMillis();
    private static final Map<Class, Class[]> m_mapInterfaces = new HashMap<Class, Class[]>();

    public static Object createResultSetProxy(Object proxiedResultSet, Object proxyStatement, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (proxiedResultSet == null) {
            return null;
        }
        Object rsetProxy = Proxy.newProxyInstance(proxyStatement.getClass().getClassLoader(), ResultSetProxyFactory.createInterfaces(proxiedResultSet), (InvocationHandler)new ResultSetProxyFactory(proxiedResultSet, proxyStatement, jdbcConnectionPool, jdbcPooledConnection));
        logger.log(Level.FINEST, "returns {0}", rsetProxy);
        return rsetProxy;
    }

    private ResultSetProxyFactory(Object proxiedResultSet, Object proxyStatement, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        int errCode;
        if (null == jdbcPooledConnection) {
            errCode = 150;
        } else if (null == jdbcConnectionPool) {
            errCode = 54;
        } else if (!(proxiedResultSet instanceof ResultSet)) {
            errCode = 266;
        } else if (!(proxyStatement instanceof Statement)) {
            errCode = 265;
        } else {
            this.m_proxiedResultSet = (ResultSet)proxiedResultSet;
            this.m_proxyStatement = (Statement)proxyStatement;
            this.m_jdbcConnectionPool = jdbcConnectionPool;
            this.m_jdbcPooledConnection = jdbcPooledConnection;
            return;
        }
        UniversalConnectionPoolException e = UCPErrorHandler.newUniversalConnectionPoolException(errCode);
        logger.throwing(this.getClass().getName(), "ResultSetProxyFactory", e);
        throw e;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.m_jdbcPooledConnection.heartbeat();
        String methodName = method.getName();
        if ("equals".equals(methodName)) {
            return new Boolean(proxy == args[0]);
        }
        if ("hashCode".equals(methodName)) {
            return new Integer(System.identityHashCode(proxy));
        }
        if ("toString".equals(methodName)) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
        }
        if (!this.m_closed && "getStatement".equals(methodName)) {
            return this.m_proxyStatement;
        }
        UniversalPooledConnectionStatus status = this.m_jdbcPooledConnection.getStatus();
        Object result = null;
        try {
            if (this.creationTS < this.m_jdbcPooledConnection.getAvailableStartTime() || this.creationTS < this.m_jdbcPooledConnection.getBorrowedStartTime()) {
                this.m_closed = true;
                try {
                    this.m_proxyStatement.getConnection().close();
                }
                catch (Throwable err) {
                    logger.log(Level.FINEST, "statement getConnection() error: {0}", err);
                }
            }
            if ("close".equals(methodName)) {
                if (this.m_closed) {
                    return null;
                }
                this.m_closed = true;
            } else {
                if ("isClosed".equals(methodName)) {
                    return this.m_closed || status == UniversalPooledConnectionStatus.STATUS_CLOSED || status == UniversalPooledConnectionStatus.STATUS_BAD;
                }
                if (this.m_closed) {
                    throw UCPErrorHandler.newSQLException(43);
                }
                if (this.m_proxyStatement.getConnection().isClosed() || status == UniversalPooledConnectionStatus.STATUS_CLOSED || status == UniversalPooledConnectionStatus.STATUS_BAD) {
                    throw UCPErrorHandler.newSQLException(31);
                }
            }
            result = method.invoke((Object)this.m_proxiedResultSet, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (Util.isSQLRecoverableException(t)) {
                this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
            }
            logger.throwing(this.getClass().getName(), "invoke", t);
            throw t;
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "invoke", e);
            throw e;
        }
        this.m_jdbcPooledConnection.heartbeat();
        return result;
    }

    private static Class[] createInterfaces(Object object) {
        Class<?> objectClass = object.getClass();
        Class[] interfaces = m_mapInterfaces.get(objectClass);
        if (null != interfaces) {
            return interfaces;
        }
        HashSet<Class> interfacesSet = new HashSet<Class>();
        ResultSetProxyFactory.addInterfaces(interfacesSet, objectClass);
        interfaces = interfacesSet.toArray(new Class[0]);
        m_mapInterfaces.put(objectClass, interfaces);
        return interfaces;
    }

    private static void addInterfaces(HashSet<Class> interfaces, Class type) {
        if (type != null) {
            for (Class<?> proxyInterface : type.getInterfaces()) {
                interfaces.add(proxyInterface);
            }
            ResultSetProxyFactory.addInterfaces(interfaces, type.getSuperclass());
        }
    }
}

