/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool;

import java.lang.reflect.Executable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.common.waitfreepool.PoolIteratorQueue;
import oracle.ucp.common.waitfreepool.Queue;
import oracle.ucp.common.waitfreepool.SkipList;
import oracle.ucp.common.waitfreepool.SkipListTuple;

final class LinkedListPool<T>
implements Pool<T> {
    private final AtomicLong elementsInstantiated = new AtomicLong(0L);
    private long listLength = 1L;
    private final Element listHead = new Element();
    private final AtomicReference<Element> fillRef = new AtomicReference<Element>(this.listHead);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    final long elementsInstantiated() {
        return this.elementsInstantiated.get();
    }

    final long listLength() {
        return this.listLength;
    }

    LinkedListPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T data) {
        Element element = this.fillRef.get();
        Element newElement = null;
        while (true) {
            if (element.tryReserve()) {
                try {
                    if (element.data == null) {
                        element.data = data;
                        this.fillRef.set(element);
                        return;
                    }
                }
                finally {
                    element.release();
                }
            }
            if (element.next.get() == null && newElement == null) {
                newElement = new Element(data);
            }
            if (element.next.compareAndSet(null, newElement)) {
                this.fillRef.set(newElement);
                ++this.listLength;
                return;
            }
            element = (Element)element.next.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSkipLists(SkipListTuple ... tuples) {
        final Queue[] queues = new Queue[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            queues[i] = new Queue();
        }
        final LinkedListPool outerThis = this;
        PoolIterator<Element> it = this.poolElementsIterator(true, null);
        try {
            while (it.hasNext()) {
                Element element = (Element)it.next();
                for (int i = 0; i < tuples.length; ++i) {
                    if (null == element.data) {
                        throw new NullPointerException("no data");
                    }
                    if (!tuples[i].getPredicate().test(element.data)) continue;
                    queues[i].enqueue(element);
                }
            }
        }
        finally {
            it.release();
        }
        for (int i = 0; i < queues.length; ++i) {
            final int index = i;
            tuples[i].getConsumer().accept(new SkipList<T>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public PoolIterator<T> poolIterator(boolean revisit) {
                    return outerThis.poolIterator(revisit, queues[index]);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(LinkedListPool.class, LinkedListPool.class, Queue[].class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("poolIterator", Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    @Override
    public PoolIterator<T> poolIterator(boolean revisit) {
        return this.poolIterator(revisit, null);
    }

    private PoolIterator<T> poolIterator(final boolean revisit, final Queue<Element> skipList) {
        return new PoolIterator<T>(){
            final PoolIterator<Element> it;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            {
                this.it = LinkedListPool.this.poolElementsIterator(revisit, skipList);
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return ((Element)this.it.next()).data;
            }

            @Override
            public void remove() {
                this.it.remove();
            }

            @Override
            public void release() {
                this.it.release();
            }

            @Override
            public boolean isSleeping() {
                return this.it.isSleeping();
            }

            @Override
            public boolean isAlive() {
                return this.it.isAlive();
            }

            static {
                try {
                    $$$methodRef$$$6 = 2.class.getDeclaredConstructor(LinkedListPool.class, Boolean.TYPE, Queue.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 2.class.getDeclaredMethod("isAlive", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredMethod("isSleeping", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("release", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("remove", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private PoolIterator<Element> poolElementsIterator(final boolean revisit, final Queue<Element> skipList) {
        final Thread iteratorThread = Thread.currentThread();
        LinkedListPool outerThis = this;
        return new PoolIterator<Element>(){
            volatile Iterator<Element> it;
            volatile Element currentElement;
            volatile boolean outerReservation;
            volatile boolean nextReserved;
            final AtomicBoolean released;
            private boolean sleeping;
            private final Queue<Element> revisitQueue;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            {
                this.it = null != skipList ? skipList.Iterator() : LinkedListPool.this.elementsIterator();
                this.currentElement = null;
                this.outerReservation = false;
                this.nextReserved = false;
                this.released = new AtomicBoolean(false);
                this.sleeping = false;
                this.revisitQueue = new Queue();
            }

            @Override
            public boolean isAlive() {
                return !this.released.get() && iteratorThread.isAlive();
            }

            @Override
            public boolean isSleeping() {
                return this.sleeping;
            }

            private void throwIfWrongThread() {
                if (iteratorThread != Thread.currentThread()) {
                    throw new IllegalStateException("PoolIterator has been run by a wrong thread");
                }
            }

            private boolean preReserved(Element element) {
                return element.reserved.get() == Thread.currentThread();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Element reserveNext() {
                while (this.it.hasNext()) {
                    Element element = this.it.next();
                    if (element.tryReserve()) {
                        if (element.data != null) {
                            Element elementToReturn = element;
                            return elementToReturn;
                        }
                        element.release();
                        continue;
                    }
                    if (this.preReserved(element)) {
                        if (element.data == null) continue;
                        this.outerReservation = true;
                        return element;
                    }
                    if (!revisit) continue;
                    element.poolIteratorQueue.enqueue(this);
                    this.revisitQueue.enqueue(element);
                }
                Element first = null;
                Element element;
                while ((element = this.revisitQueue.dequeue()) != null) {
                    if (element == first) {
                        first = null;
                        try {
                            this.sleeping = true;
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.sleeping = false;
                        }
                    }
                    if (null == first) {
                        first = element;
                    }
                    if (element.poolIteratorQueue.peek(this)) {
                        if (element.tryReserve()) {
                            element.poolIteratorQueue.disable(this);
                            if (element.data != null) {
                                return element;
                            }
                            element.release();
                            continue;
                        }
                        this.revisitQueue.enqueue(element);
                        continue;
                    }
                    this.revisitQueue.enqueue(element);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                this.throwIfWrongThread();
                if (this.nextReserved) {
                    return true;
                }
                if (this.currentElement != null) {
                    if (this.outerReservation) {
                        this.outerReservation = false;
                    } else {
                        this.currentElement.release();
                    }
                }
                this.nextReserved = (this.currentElement = this.reserveNext()) != null;
                return this.nextReserved;
            }

            @Override
            public Element next() {
                this.throwIfWrongThread();
                if (this.hasNext()) {
                    this.nextReserved = false;
                    return this.currentElement;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.throwIfWrongThread();
                if (this.currentElement != null) {
                    this.currentElement.data = null;
                    if (this.currentElement.id < ((Element)LinkedListPool.this.fillRef.get()).id) {
                        LinkedListPool.this.fillRef.set(this.currentElement);
                    }
                } else {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void release() {
                this.throwIfWrongThread();
                if (this.released.compareAndSet(false, true)) {
                    this.revisitQueue.clear();
                    if (this.currentElement != null) {
                        if (this.outerReservation) {
                            this.outerReservation = false;
                        } else {
                            this.currentElement.release();
                        }
                        this.currentElement = null;
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$10 = 3.class.getDeclaredConstructor(LinkedListPool.class, Queue.class, Thread.class, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 3.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 3.class.getDeclaredMethod("release", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 3.class.getDeclaredMethod("remove", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 3.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 3.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 3.class.getDeclaredMethod("reserveNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 3.class.getDeclaredMethod("preReserved", Element.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredMethod("throwIfWrongThread", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("isSleeping", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("isAlive", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private Iterator<Element> elementsIterator() {
        return new Iterator<Element>(){
            private Element current;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            {
                this.current = LinkedListPool.this.listHead;
            }

            @Override
            public boolean hasNext() {
                return null != this.current;
            }

            @Override
            public Element next() {
                if (null != this.current) {
                    Element element = this.current;
                    this.current = (Element)this.current.next.get();
                    return element;
                }
                return null;
            }

            static {
                try {
                    $$$methodRef$$$3 = 4.class.getDeclaredConstructor(LinkedListPool.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$14 = LinkedListPool.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = LinkedListPool.class.getDeclaredMethod("access$1300", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = LinkedListPool.class.getDeclaredMethod("access$1200", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = LinkedListPool.class.getDeclaredMethod("access$800", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = LinkedListPool.class.getDeclaredMethod("access$700", LinkedListPool.class, Boolean.TYPE, Queue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = LinkedListPool.class.getDeclaredMethod("access$600", LinkedListPool.class, Boolean.TYPE, Queue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = LinkedListPool.class.getDeclaredMethod("access$000", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = LinkedListPool.class.getDeclaredMethod("elementsIterator", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = LinkedListPool.class.getDeclaredMethod("poolElementsIterator", Boolean.TYPE, Queue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = LinkedListPool.class.getDeclaredMethod("poolIterator", Boolean.TYPE, Queue.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = LinkedListPool.class.getDeclaredMethod("poolIterator", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = LinkedListPool.class.getDeclaredMethod("buildSkipLists", SkipListTuple[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = LinkedListPool.class.getDeclaredMethod("put", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = LinkedListPool.class.getDeclaredMethod("listLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = LinkedListPool.class.getDeclaredMethod("elementsInstantiated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    private final class Element {
        private final long id;
        private final AtomicReference<Thread> reserved = new AtomicReference<Object>(null);
        private final AtomicReference<Element> next = new AtomicReference<Object>(null);
        volatile T data;
        private final PoolIteratorQueue<Element> poolIteratorQueue = new PoolIteratorQueue();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;

        private Element() {
            this((Object)null);
        }

        private Element(T data) {
            this.data = data;
            this.id = LinkedListPool.this.elementsInstantiated.getAndIncrement();
        }

        private boolean tryReserve() {
            return this.reserved.compareAndSet(null, Thread.currentThread());
        }

        private void release() {
            Thread currentThread = Thread.currentThread();
            if (!this.reserved.compareAndSet(currentThread, null)) {
                throw new IllegalStateException("element is released by wrong thread: " + currentThread);
            }
        }

        static {
            try {
                $$$methodRef$$$11 = Element.class.getDeclaredConstructor(LinkedListPool.class, Object.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$10 = Element.class.getDeclaredConstructor(LinkedListPool.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = Element.class.getDeclaredConstructor(LinkedListPool.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = Element.class.getDeclaredConstructor(LinkedListPool.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = Element.class.getDeclaredMethod("access$1100", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = Element.class.getDeclaredMethod("access$1000", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Element.class.getDeclaredMethod("access$900", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Element.class.getDeclaredMethod("access$400", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Element.class.getDeclaredMethod("access$300", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Element.class.getDeclaredMethod("access$200", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Element.class.getDeclaredMethod("release", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Element.class.getDeclaredMethod("tryReserve", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

