/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.InputStream;
import java.net.URI;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.xml.XMLConfigurationParser;

public class DatasourceConfigManager {
    private static DatasourceConfigManager configManager = null;
    private static Map<String, Object> parsedUcpConfigMap;
    private static Map<String, PoolDataSource> poolDataSources;
    private static Map<String, PoolXADataSource> poolXADataSources;

    private DatasourceConfigManager() {
    }

    public static synchronized void init() throws UniversalConnectionPoolException {
        if (configManager != null) {
            return;
        }
        try {
            String xmlSystemPropertyPath = Util.getXMLConfigurationFilePath();
            if (null != xmlSystemPropertyPath && !xmlSystemPropertyPath.isEmpty()) {
                URI xmlFilePathAsURI = URI.create(xmlSystemPropertyPath);
                XMLConfigurationParser parser = XMLConfigurationParser.getInstance();
                parsedUcpConfigMap = parser.parse(xmlFilePathAsURI);
                DatasourceConfigManager.loadPoolsFromConfig();
                configManager = new DatasourceConfigManager();
            }
        }
        catch (Exception e) {
            UCPErrorHandler.throwUniversalConnectionPoolException(387, e);
        }
    }

    public static synchronized void init(InputStream is) throws UniversalConnectionPoolException {
        if (configManager != null) {
            return;
        }
        if (null == is) {
            DatasourceConfigManager.init();
        } else {
            try {
                XMLConfigurationParser parser = XMLConfigurationParser.getInstance();
                parsedUcpConfigMap = parser.parse(is);
                DatasourceConfigManager.loadPoolsFromConfig();
                configManager = new DatasourceConfigManager();
            }
            catch (Exception e) {
                UCPErrorHandler.throwUniversalConnectionPoolException(387, e);
            }
        }
    }

    public static DatasourceConfigManager getDatasourceConfigManager() {
        return DatasourceConfigManager.getDatasourceConfigManager(null);
    }

    public static DatasourceConfigManager getDatasourceConfigManager(InputStream is) {
        if (configManager == null) {
            try {
                DatasourceConfigManager.init(is);
            }
            catch (UniversalConnectionPoolException e) {
                throw new IllegalStateException(" Invalid UCP Config ", e);
            }
        }
        return configManager;
    }

    private static void loadPoolsFromConfig() throws Exception {
        for (Map.Entry<String, Object> e : parsedUcpConfigMap.entrySet()) {
            DatasourceConfigManager.loadPool(e.getKey(), e.getValue());
        }
    }

    private static void loadPool(String poolName, Object poolConfig) throws UniversalConnectionPoolException, Exception {
        Map poolConfigMap = (Map)poolConfig;
        boolean isXAPool = false;
        if (Boolean.parseBoolean((String)poolConfigMap.get("is-xa-pool"))) {
            isXAPool = true;
        }
        for (Map.Entry poolConfigEntry : poolConfigMap.entrySet()) {
            if (!((String)poolConfigEntry.getKey()).startsWith("data-source-")) continue;
            String dsName = ((String)poolConfigEntry.getKey()).substring("data-source-".length());
            if (isXAPool) {
                PoolXADataSourceImpl pdsXA = new PoolXADataSourceImpl(poolName, dsName, poolConfigMap);
                poolXADataSources.putIfAbsent(dsName, pdsXA);
                continue;
            }
            PoolDataSourceImpl pds = new PoolDataSourceImpl(poolName, dsName, poolConfigMap);
            poolDataSources.putIfAbsent(dsName, pds);
        }
    }

    PoolDataSource getPoolDataSource(String dataSourceName) throws SQLException {
        PoolDataSource pds = poolDataSources.get(dataSourceName);
        if (pds == null) {
            UCPErrorHandler.throwSQLException(73, null);
        }
        return pds;
    }

    PoolXADataSource getPoolXADataSource(String dataSourceName) throws SQLException {
        PoolXADataSource xaPds = poolXADataSources.get(dataSourceName);
        if (xaPds == null) {
            UCPErrorHandler.throwSQLException(73, null);
        }
        return xaPds;
    }

    public static boolean isPoolCreatedUsingXmlConfig(String poolName) {
        return parsedUcpConfigMap != null ? parsedUcpConfigMap.containsKey(poolName) : false;
    }

    static Map<String, Object> getPoolConfigFromXML(String poolName) {
        return parsedUcpConfigMap != null ? (Map)parsedUcpConfigMap.get(poolName) : null;
    }

    static Map<String, PoolDataSource> getPoolDataSources() {
        return poolDataSources;
    }

    static Map<String, PoolXADataSource> getPoolXADataSources() {
        return poolXADataSources;
    }

    static {
        poolDataSources = new HashMap<String, PoolDataSource>();
        poolXADataSources = new HashMap<String, PoolXADataSource>();
    }
}

