/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MappedGetter<KEY, VALUE> {
    private volatile Map<KEY, VALUE> map = new HashMap<KEY, VALUE>();
    private final ReentrantLock lock = new ReentrantLock(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VALUE computeIfAbsent(KEY key, Function<? super KEY, ? extends VALUE> mappingFunction) {
        assert (null != key) : "key should be non-null";
        assert (null != mappingFunction) : "mapping function should be non-null";
        VALUE v = this.map.get(key);
        if (null == v) {
            try {
                this.lock.lock();
                v = this.map.get(key);
                if (null == v) {
                    HashMap<KEY, VALUE> newMap = new HashMap<KEY, VALUE>(this.map);
                    v = newMap.computeIfAbsent(key, mappingFunction);
                    this.map = newMap;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return v;
    }

    public void forEach(BiConsumer<? super KEY, ? super VALUE> action) {
        Map<KEY, VALUE> curMap = this.map;
        curMap.forEach(action);
    }

    public String toString() {
        Map<KEY, VALUE> curMap = this.map;
        return curMap.toString();
    }
}

