/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ.xml;

import java.io.OutputStream;
import java.io.PrintWriter;

public class AQxmlDebug {
    static OutputStream logstream = System.out;
    static PrintWriter pstream = new PrintWriter(logstream);
    static boolean DEBUG = false;
    private static int TRACE_LEVEL = 0;
    public static final int AQ_ORA_TR1 = 1;
    public static final int AQ_ORA_TR2 = 2;
    public static final int AQ_ORA_TR3 = 3;
    public static final int AQ_ORA_TR4 = 4;
    public static final int AQ_ORA_TR5 = 5;

    private AQxmlDebug() {
    }

    public static void setDebug(boolean val) {
        DEBUG = val;
    }

    public static void setTraceLevel(int level) {
        TRACE_LEVEL = level > 5 ? 5 : (level < 0 ? 0 : level);
    }

    public static int getTraceLevel() {
        return TRACE_LEVEL;
    }

    public static OutputStream getLogStream() {
        return logstream;
    }

    public static PrintWriter getPrintWriter() {
        return pstream;
    }

    public static void setLogStream(OutputStream output_stream) {
        logstream = output_stream;
        pstream = new PrintWriter(logstream);
    }

    static void trace(int trace_level, String component, String message) {
        if (TRACE_LEVEL >= trace_level) {
            pstream.println(Thread.currentThread().getName() + "  " + component + ":  " + message);
            pstream.flush();
        }
    }

    static void traceEx(int trace_level, String message, Exception ex) {
        if (TRACE_LEVEL >= trace_level) {
            pstream.println(Thread.currentThread().getName() + "  " + message + ": Exception: " + ex);
            if (TRACE_LEVEL >= 5 && ex != null) {
                ex.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void traceErr(int trace_level, String message, Error err) {
        if (TRACE_LEVEL >= trace_level) {
            pstream.println(Thread.currentThread().getName() + "  " + message + ": Error: " + err);
            if (TRACE_LEVEL >= 5 && err != null) {
                err.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void print(String message) {
        if (DEBUG) {
            pstream.print(message);
            pstream.flush();
        }
    }

    static void println(String message) {
        if (DEBUG) {
            pstream.println(Thread.currentThread().getName() + "  " + message);
            pstream.flush();
        }
    }
}

