/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.jakarta.jms.AQjmsConnection;
import oracle.jakarta.jms.AQjmsException;
import oracle.jakarta.jms.AQjmsGeneralDBConnection;
import oracle.jakarta.jms.AQjmsJDBCConnInfo;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsUtil;
import oracle.jdbc.OracleConnection;

class AQjmsExceptionListener
extends Thread
implements ExceptionListener {
    public static final long DEFAULT_PING_PERIOD = 120000L;
    private static final String PING_QUERY = "SELECT banner FROM v$version where 1<>1";
    private PreparedStatement m_pstmt;
    private ExceptionListener m_el;
    private long m_period = 120000L;
    private boolean m_stop = false;
    private boolean m_suspended = true;
    private boolean m_registered = false;
    private Connection m_dbConn;
    private AQjmsGeneralDBConnection m_genConn;
    private Object expLock = new Object();
    private JMSException expFromMessageListener;
    private AQjmsJDBCConnInfo jdbcInfo = null;
    private AQjmsConnection parentJmsConn = null;
    private Set<String> queueSet = new HashSet<String>();

    AQjmsExceptionListener(AQjmsGeneralDBConnection genConn) throws JMSException {
        this.m_genConn = genConn;
        this.m_dbConn = genConn.getDBConnection();
        this.jdbcInfo = AQjmsUtil.getJDBCConnInfo((OracleConnection)this.m_dbConn);
        try {
            this.m_pstmt = this.m_dbConn.prepareStatement(PING_QUERY);
            this.m_pstmt.setQueryTimeout(1);
        }
        catch (SQLException sqlEx) {
            AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener constructor", sqlEx);
            throw new AQjmsException(sqlEx);
        }
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", "Setup Exception Listener DB Connection: " + this.jdbcInfo + "Time Now " + new Date());
    }

    synchronized void setExceptionListener(ExceptionListener el) {
        if (el == null) {
            this.m_registered = false;
        } else {
            this.m_registered = true;
            if (!this.isAlive()) {
                this.start();
            }
        }
        this.m_el = el;
    }

    ExceptionListener getExceptionListener() {
        return this.m_el;
    }

    void setParentJmsConn(AQjmsConnection pJmsConn) {
        this.parentJmsConn = pJmsConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jmsEx) {
        block15: {
            try {
                if (this.parentJmsConn == null || this.parentJmsConn.queueSet == null) break block15;
                this.queueSet.clear();
                Set<String> set = this.parentJmsConn.queueSet;
                synchronized (set) {
                    this.queueSet.addAll(this.parentJmsConn.queueSet);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + ": calling onException for : " + this.jdbcInfo + "Queue List: " + this.queueSet + "Time Now " + new Date());
        ExceptionListener excpLsnrObj = null;
        AQjmsExceptionListener aQjmsExceptionListener = this;
        synchronized (aQjmsExceptionListener) {
            excpLsnrObj = this.m_el;
        }
        if (excpLsnrObj != null) {
            try {
                Exception linkedException = jmsEx.getLinkedException();
                if (linkedException != null && linkedException.getMessage() == null) {
                    String className = linkedException.getClass().getName();
                    String exMessage = "Exception from " + className;
                    AQjmsException newLinkedException = new AQjmsException(exMessage, linkedException);
                    jmsEx.setLinkedException((Exception)((Object)newLinkedException));
                }
            }
            catch (Exception linkedException) {
                // empty catch block
            }
            try {
                excpLsnrObj.onException(jmsEx);
                AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + ": invoked onException for : " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
            }
            catch (RuntimeException rte) {
                AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener: " + this.m_el + ": Exception thrown by onException().JDBC INFO: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date(), rte);
                throw rte;
            }
            catch (Error err) {
                AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener:" + this.m_el + ": Exception thrown by onException() : " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date(), err);
                throw err;
            }
        }
        AQjmsOracleDebug.traceEx(0, "AQjmsExceptionListener:: Exception Listener obj is NULL :" + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date(), jmsEx);
    }

    void setPingPeriod(long period) {
        if (period <= 0L) {
            return;
        }
        this.m_period = period;
    }

    long getPingPeriod() {
        return this.m_period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i = 0;
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + ":START: " + this.jdbcInfo + "Queue List" + this.queueSet + "Time Now " + new Date());
        while (!this.m_stop) {
            try {
                Object object = this;
                synchronized (object) {
                    this.wait(this.m_period);
                }
                try {
                    if (this.parentJmsConn != null && this.parentJmsConn.queueSet != null) {
                        this.queueSet.clear();
                        object = this.parentJmsConn.queueSet;
                        synchronized (object) {
                            this.queueSet.addAll(this.parentJmsConn.queueSet);
                        }
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", this.m_el + ":HeartBeat: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.m_registered || this.m_suspended) continue;
                ++i;
                if (this.checkNotifiedJMSException()) break;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", this.m_el + "executing query: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                this.m_pstmt.executeQuery();
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", this.m_el + "done executing query: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                if (!this.checkNotifiedJMSException()) continue;
                break;
            }
            catch (InterruptedException intEx) {
                if (!this.m_stop) continue;
                AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "run stopped " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                return;
            }
            catch (SQLException sqlEx) {
                JMSException jmsEx = new JMSException(sqlEx.toString());
                this.onException(jmsEx);
                this.m_stop = true;
            }
        }
        AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "CLOSED: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
    }

    synchronized void resumeExceptionListener() {
        if (this.m_suspended) {
            this.m_suspended = false;
        }
    }

    synchronized void suspendExceptionListener() {
        this.m_suspended = true;
    }

    void close() {
        try {
            try {
                AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "CLOSING: " + this.jdbcInfo + "Queue List " + this.queueSet + "Time Now " + new Date());
                if (AQjmsOracleDebug.getTraceLevel() >= 1) {
                    Object stackTrace = "";
                    boolean skip = true;
                    String stackNow = "";
                    for (StackTraceElement stElem : Thread.currentThread().getStackTrace()) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        stackNow = stElem.toString();
                        if (stackNow.contains("oracle.jakarta.jms")) continue;
                        stackTrace = (String)stackTrace + stackNow + "\n";
                    }
                    AQjmsOracleDebug.trace(1, "AQjmsExceptionListener", this.m_el + "CLOSE INVOKED FROM " + (String)stackTrace);
                }
            }
            catch (Exception stackTrace) {
                // empty catch block
            }
            if (!this.m_stop) {
                this.m_stop = true;
                if (this.isAlive()) {
                    final AQjmsExceptionListener expThread = this;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            expThread.interrupt();
                            return null;
                        }
                    });
                    try {
                        this.join(500L);
                    }
                    catch (InterruptedException intExp) {
                        AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "in close, InterruptedException caught");
                    }
                }
            }
            if (this.m_pstmt != null) {
                try {
                    this.m_pstmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.m_pstmt = null;
            }
            try {
                this.m_genConn.close();
            }
            catch (JMSException jMSException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void feedJMSException(JMSException exp) {
        Object object = this.expLock;
        synchronized (object) {
            this.expFromMessageListener = exp;
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNotifiedJMSException() {
        Object object = this.expLock;
        synchronized (object) {
            if (this.expFromMessageListener != null) {
                JMSException jmsExp = this.expFromMessageListener;
                this.expFromMessageListener = null;
                this.onException(jmsExp);
            }
        }
        return this.m_stop;
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

