/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import oracle.jakarta.jms.AQjmsConnection;
import oracle.jakarta.jms.AQjmsError;
import oracle.jakarta.jms.AQjmsJMSProducer;
import oracle.jakarta.jms.AQjmsOracleDebug;
import oracle.jakarta.jms.AQjmsProducer;
import oracle.jakarta.jms.AQjmsSession;

public class AQjmsJMSContext
implements JMSContext,
AutoCloseable {
    private AQjmsConnection connection;
    private AQjmsSession session;
    private int sessionMode;
    private boolean autoStart;
    private AtomicLong sessionCount;
    private AQjmsProducer producer;

    AQjmsJMSContext(AQjmsConnection connection, int sessionMode) throws JMSException {
        new AQjmsJMSContext(connection, sessionMode, new AtomicLong(1L));
    }

    AQjmsJMSContext(AQjmsConnection connection, int sessionMode, AtomicLong sessionCount) throws JMSException {
        this.connection = connection;
        this.sessionMode = sessionMode;
        try {
            this.session = this.createSession();
            this.sessionCount = sessionCount;
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(1, "AQjmsConnection.createSession", e);
            throw e;
        }
    }

    public void acknowledge() {
        try {
            AQjmsError.throwEx(102);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.session.close();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to close the session", e.getErrorCode());
        }
        if (this.sessionCount.decrementAndGet() == 0L) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                throw new JMSRuntimeException("Failed to close the connection", e.getErrorCode());
            }
        }
    }

    public void commit() {
        try {
            this.getSession().commit();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to commit the session", e.getErrorCode());
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        try {
            return this.getSession().createBrowser(queue);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create queue browser", e.getErrorCode());
        }
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        try {
            return this.getSession().createBrowser(queue, messageSelector);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create queue browser with message selector : " + messageSelector, e.getErrorCode());
        }
    }

    public BytesMessage createBytesMessage() {
        try {
            return this.getSession().createBytesMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Bytes Message ", e.getErrorCode());
        }
    }

    public JMSConsumer createConsumer(Destination destination) {
        return null;
    }

    public JMSConsumer createConsumer(Destination arg0, String arg1) {
        return null;
    }

    public JMSConsumer createConsumer(Destination arg0, String arg1, boolean arg2) {
        return null;
    }

    public JMSContext createContext(int sessionMode) {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.sessionCount.getAndIncrement();
                return new AQjmsJMSContext(this.connection, sessionMode, this.sessionCount);
            }
            AQjmsError.throwIllegalStateEx(114, null);
        }
        catch (JMSException e) {
            AQjmsOracleDebug.traceEx(1, "AQjmsJMSContext.createSession", e);
        }
        return null;
    }

    public JMSConsumer createDurableConsumer(Topic arg0, String arg1) {
        return null;
    }

    public JMSConsumer createDurableConsumer(Topic arg0, String arg1, String arg2, boolean arg3) {
        return null;
    }

    public MapMessage createMapMessage() {
        try {
            return this.getSession().createMapMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Map message", e.getErrorCode());
        }
    }

    public Message createMessage() {
        try {
            return this.getSession().createMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Message", e.getErrorCode());
        }
    }

    public ObjectMessage createObjectMessage() {
        try {
            return this.getSession().createObjectMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Object Message", e.getErrorCode());
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        try {
            return this.getSession().createObjectMessage(object);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Object Message", e.getErrorCode());
        }
    }

    public JMSProducer createProducer() {
        try {
            if (this.producer == null) {
                this.producer = (AQjmsProducer)this.getSession().createProducer(null);
            }
            return new AQjmsJMSProducer(this.getSession(), this.producer);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Producer", e.getErrorCode());
        }
    }

    public Queue createQueue(String queueName) {
        try {
            return this.getSession().createQueue(queueName);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Queue " + queueName, e.getErrorCode());
        }
    }

    public JMSConsumer createSharedConsumer(Topic arg0, String arg1) {
        return null;
    }

    public JMSConsumer createSharedConsumer(Topic arg0, String arg1, String arg2) {
        return null;
    }

    public JMSConsumer createSharedDurableConsumer(Topic arg0, String arg1) {
        return null;
    }

    public JMSConsumer createSharedDurableConsumer(Topic arg0, String arg1, String arg2) {
        return null;
    }

    public StreamMessage createStreamMessage() {
        try {
            return this.getSession().createStreamMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Stream Message", e.getErrorCode());
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        try {
            return this.getSession().createTemporaryQueue();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Temporary Queue", e.getErrorCode());
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        try {
            return this.getSession().createTemporaryTopic();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Temporary Topic", e.getErrorCode());
        }
    }

    public TextMessage createTextMessage() {
        try {
            return this.getSession().createTextMessage();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Text Message", e.getErrorCode());
        }
    }

    public TextMessage createTextMessage(String text) {
        try {
            return this.getSession().createTextMessage(text);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Text Message", e.getErrorCode());
        }
    }

    public Topic createTopic(String topicName) {
        try {
            return this.getSession().createTopic(topicName);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to create Topic " + topicName, e.getErrorCode());
        }
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to get clientID ", e.getErrorCode());
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to get exceptionListener ", e.getErrorCode());
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to get metadata ", e.getErrorCode());
        }
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public boolean getTransacted() {
        if (this.getSession() != null) {
            try {
                return this.getSession().getTransacted();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void recover() {
        if (this.getSession() != null) {
            try {
                this.getSession().recover();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public void rollback() {
        if (this.getSession() != null) {
            try {
                this.getSession().rollback();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to set clientID " + clientID, e.getErrorCode());
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to set exceptionListener ", e.getErrorCode());
        }
    }

    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to start the connection", e.getErrorCode());
        }
    }

    public void stop() {
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to stop the connection", e.getErrorCode());
        }
    }

    public void unsubscribe(String subscriberName) {
        try {
            this.getSession().unsubscribe(subscriberName);
        }
        catch (JMSException e) {
            throw new JMSRuntimeException("Failed to unsubscribe for subscriber name : " + subscriberName, e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AQjmsSession createSession() throws JMSException {
        if (this.session == null) {
            AQjmsJMSContext aQjmsJMSContext = this;
            synchronized (aQjmsJMSContext) {
                if (this.session == null) {
                    try {
                        this.session = (AQjmsSession)this.connection.createSession(this.getTransacted(), this.sessionMode);
                    }
                    catch (JMSException e) {
                        AQjmsOracleDebug.traceEx(1, "AQjmsJMSContext.getSession", e);
                        throw e;
                    }
                }
            }
        }
        return this.session;
    }

    AQjmsSession getSession() {
        return this.session;
    }
}

