/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ;

import jakarta.jms.JMSException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.jakarta.AQ.AQAgent;
import oracle.jakarta.AQ.AQDequeueOption;
import oracle.jakarta.AQ.AQDriverManager;
import oracle.jakarta.AQ.AQEnqueueOption;
import oracle.jakarta.AQ.AQException;
import oracle.jakarta.AQ.AQMessage;
import oracle.jakarta.AQ.AQMessageProperty;
import oracle.jakarta.AQ.AQOracleAgent;
import oracle.jakarta.AQ.AQOracleDebug;
import oracle.jakarta.AQ.AQOracleMessage;
import oracle.jakarta.AQ.AQOracleObjectPayload;
import oracle.jakarta.AQ.AQOracleQueueTable;
import oracle.jakarta.AQ.AQOracleRawPayload;
import oracle.jakarta.AQ.AQOracleSQLException;
import oracle.jakarta.AQ.AQOracleSession;
import oracle.jakarta.AQ.AQQueue;
import oracle.jakarta.AQ.AQQueueProperty;
import oracle.jakarta.AQ.AQQueueTable;
import oracle.jakarta.AQ.AQSession;
import oracle.jakarta.AQ.AQSignature;
import oracle.jakarta.AQ.AQUtil;
import oracle.jakarta.jms.AQjmsSession;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleStruct;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.TIMESTAMP;

public class AQOracleQueue
implements AQQueue {
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    AQQueueProperty property;
    Integer queue_type;
    private AQOracleSession aq_sess;
    private CallableStatement alterq_stmt;
    private CallableStatement rems_stmt;
    private CallableStatement adds_stmt;
    private CallableStatement alts_stmt;
    private PreparedStatement allq_stmt;
    private PreparedStatement allqo_stmt;
    private CallableStatement alprop_stmt;
    private CallableStatement unscprop_stmt;
    private CallableStatement enprop_stmt;
    private CallableStatement disprop_stmt;
    private OracleCallableStatement enqr_norcp_stmt;
    private OracleCallableStatement enqr_rcp_stmt;
    private OracleCallableStatement enqo_norcp_stmt;
    private OracleCallableStatement enqo_rcp_stmt;
    private OracleCallableStatement deq_raw_stmt;
    private OracleCallableStatement deq_obj_stmt;
    private Hashtable trans_list;
    private boolean secure;

    AQOracleQueue(AQOracleSession conn, String q_owner, String q_name, String q_table, AQQueueProperty q_prop, int payload_type, String payload_object_type, boolean secure) throws AQException {
        this.owner = q_owner;
        this.table = q_table;
        this.aq_sess = conn;
        if (q_name == null || q_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, q_name);
        } else {
            this.name = q_name;
        }
        if (q_prop == null) {
            AQUtil.throwAQEx(185);
        } else {
            this.property = q_prop;
        }
        if (payload_type == 2 || payload_type == 3 || payload_type == 4) {
            this.p_data_type = null;
        } else if (payload_type == 1) {
            if (payload_object_type == null || payload_object_type.equals("")) {
                AQUtil.throwAQEx(122, "payload object type must be specified");
            }
            this.p_data_type = payload_object_type;
        } else {
            AQUtil.throwAQEx(129);
        }
        this.pload_type = payload_type;
        this.queue_type = null;
        this.alterq_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        this.rems_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.alprop_stmt = null;
        this.unscprop_stmt = null;
        this.enprop_stmt = null;
        this.disprop_stmt = null;
        this.enqr_norcp_stmt = null;
        this.enqr_rcp_stmt = null;
        this.enqo_norcp_stmt = null;
        this.enqo_rcp_stmt = null;
        this.deq_obj_stmt = null;
        this.deq_raw_stmt = null;
        this.trans_list = new Hashtable();
        this.secure = secure;
    }

    public AQOracleQueue(AQjmsSession jms_session, String q_owner, String q_name, String q_table, AQQueueProperty q_prop, int payload_type, String payload_object_type, boolean secure) throws JMSException, AQException {
        Connection db_conn = null;
        this.owner = q_owner;
        this.table = q_table;
        if (q_name == null || q_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, q_name);
        } else {
            this.name = q_name;
        }
        db_conn = jms_session.getDBConnection();
        if (q_prop == null) {
            AQUtil.throwAQEx(185);
        } else {
            this.property = q_prop;
        }
        this.aq_sess = new AQOracleSession(db_conn);
        if (payload_type == 2) {
            AQUtil.throwAQEx(193);
        }
        if ((payload_object_type == null || payload_object_type.equals("")) && !q_prop.isSharded()) {
            AQUtil.throwAQEx(122, "payload object type must be specified");
        }
        this.pload_type = payload_type;
        this.alterq_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        this.rems_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.alprop_stmt = null;
        this.unscprop_stmt = null;
        this.enprop_stmt = null;
        this.disprop_stmt = null;
        this.enqr_norcp_stmt = null;
        this.enqr_rcp_stmt = null;
        this.enqo_norcp_stmt = null;
        this.enqo_rcp_stmt = null;
        this.deq_obj_stmt = null;
        this.deq_raw_stmt = null;
        this.trans_list = new Hashtable();
        this.secure = secure;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    void setOwner(String q_owner) throws AQException {
        this.owner = q_owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String q_name) throws AQException {
        this.name = q_name;
    }

    public String getCompleteName() {
        Object ret = null;
        ret = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return ret;
    }

    public AQSession getAQSession() {
        return this.aq_sess;
    }

    public void setAQSession(AQOracleSession sess) throws AQException {
        if (sess != null) {
            AQOracleDebug.trace(3, "AQOracleQueue.setAQSession", "entry");
            this.aq_sess = sess;
            this.alterq_stmt = null;
            this.adds_stmt = null;
            this.alts_stmt = null;
            this.rems_stmt = null;
            this.allq_stmt = null;
            this.allqo_stmt = null;
            this.alprop_stmt = null;
            this.unscprop_stmt = null;
            this.enprop_stmt = null;
            this.disprop_stmt = null;
            this.enqr_norcp_stmt = null;
            this.enqr_rcp_stmt = null;
            this.enqo_norcp_stmt = null;
            this.enqo_rcp_stmt = null;
            this.deq_obj_stmt = null;
            this.deq_raw_stmt = null;
        } else {
            AQUtil.throwAQEx(122, "Session cannot be null");
        }
    }

    public int getPayloadType() throws AQException {
        return this.pload_type;
    }

    void setPayloadType(int payload_type) throws AQException {
        this.pload_type = payload_type;
    }

    public String getObjectPayloadType() throws AQException {
        return this.p_data_type;
    }

    @Override
    public String getQueueTableName() throws AQException {
        return this.table;
    }

    void setQueueTableName(String q_table) throws AQException {
        this.table = q_table;
    }

    @Override
    public synchronized AQQueueProperty getProperty() throws AQException {
        Connection db_conn = null;
        ResultSet rset = null;
        String ret_time = "";
        boolean isMigrating = false;
        AQOracleDebug.trace(4, "AQOracleQueue.getProperty", "entry-no params");
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            try {
                if (this.owner == null || this.owner.equals("")) {
                    if (this.allq_stmt == null) {
                        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "before prepare-1");
                        this.allq_stmt = this.aq_sess.is23compatible() ? db_conn.prepareStatement("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t1.migration from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner") : db_conn.prepareStatement("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner");
                    } else {
                        this.allq_stmt.clearParameters();
                    }
                    this.allq_stmt.setString(1, this.name.toUpperCase());
                    rset = this.allq_stmt.executeQuery();
                } else {
                    if (this.allqo_stmt == null) {
                        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "before prepare-2");
                        this.allqo_stmt = this.aq_sess.is23compatible() ? db_conn.prepareStatement("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t1.migration from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table") : db_conn.prepareStatement("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table");
                    } else {
                        this.allqo_stmt.clearParameters();
                    }
                    this.allqo_stmt.setString(1, this.owner.toUpperCase());
                    this.allqo_stmt.setString(2, this.name.toUpperCase());
                    this.allqo_stmt.setString(3, this.owner.toUpperCase());
                    AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "before execute");
                    rset = this.allqo_stmt.executeQuery();
                }
            }
            catch (SQLException sqlex) {
                AQOracleDebug.traceEx(3, "AQOracleQueue.getProperty-1", sqlex);
                if (this.owner == null || this.owner.equals("")) {
                    try {
                        this.allq_stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.allq_stmt = null;
                } else {
                    try {
                        this.allqo_stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.allqo_stmt = null;
                }
                throw sqlex;
            }
            if (rset.next()) {
                String mig_flag;
                if (rset.getString(4).equals("EXCEPTION_QUEUE")) {
                    this.property.setQueueType(1);
                }
                this.property.setMaxRetries(rset.getInt(5));
                this.property.setRetryInterval(rset.getInt(6));
                ret_time = rset.getString(7).trim();
                if (ret_time.equals("FOREVER")) {
                    this.property.setRetentionTime(-1.0);
                } else {
                    this.property.setRetentionTime(rset.getDouble(7));
                }
                this.property.setComment(rset.getString(8));
                if (this.aq_sess.is23compatible() && (mig_flag = rset.getString(10)).equalsIgnoreCase("ON")) {
                    isMigrating = true;
                }
                this.property.setMigrating(isMigrating);
            } else if (this.owner == null || this.owner.equals("")) {
                AQUtil.throwAQEx(190, this.name);
            } else {
                AQUtil.throwAQEx(190, this.owner + "." + this.name);
            }
            if (rset.next()) {
                AQUtil.throwAQEx(182);
            }
            try {
                rset.close();
            }
            catch (Exception mig_flag) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getProperty-2", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "exit");
        return this.property;
    }

    public AQQueueProperty getProperty(boolean cached) throws AQException {
        if (cached) {
            AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "return cached prop");
            return this.property;
        }
        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "get prop from db");
        return this.getProperty();
    }

    void setProperty(AQQueueProperty q_property) throws AQException {
        this.property = q_property;
    }

    @Override
    public void start(boolean enqueue, boolean dequeue) throws AQException {
        this.start(enqueue, dequeue, false);
    }

    public void start(boolean enqueue, boolean dequeue, boolean autonomous) throws AQException {
        block14: {
            Statement startq_stmt = null;
            Connection db_conn = null;
            Object q_name = "";
            String eq_flag = "true";
            String dq_flag = "true";
            if (this.name == null || this.name.equals("")) {
                AQUtil.throwAQEx(122, "name invalid");
            }
            q_name = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
            try {
                try {
                    db_conn = this.aq_sess.getDBConnection();
                }
                catch (Exception ex) {
                    AQUtil.throwAQEx(184);
                }
                if (!enqueue) {
                    eq_flag = "false";
                }
                if (!dequeue) {
                    dq_flag = "false";
                }
                Object stmtStr = "";
                if (autonomous) {
                    stmtStr = (String)stmtStr + "declare PRAGMA AUTONOMOUS_TRANSACTION; ";
                }
                startq_stmt = db_conn.prepareCall((String)stmtStr + "begin dbms_aqadm.start_queue(queue_name => ?, enqueue => " + eq_flag + ", dequeue => " + dq_flag + "); end;");
                startq_stmt.setString(1, (String)q_name);
                startq_stmt.execute();
                try {
                    startq_stmt.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sqlex) {
                boolean throw_err;
                boolean bl = throw_err = sqlex.getErrorCode() != 24210;
                if (throw_err) {
                    AQOracleDebug.traceEx(3, "AQOracleQueue.start", sqlex);
                } else {
                    AQOracleDebug.traceEx(3, "AQOracleQueue.start ignored error: ", sqlex);
                }
                try {
                    startq_stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!throw_err) break block14;
                throw new AQOracleSQLException(sqlex);
            }
        }
    }

    @Override
    public void start() throws AQException {
        this.start(true, true);
    }

    @Override
    public void startEnqueue() throws AQException {
        this.start(true, false);
    }

    @Override
    public void startDequeue() throws AQException {
        this.start(false, true);
    }

    @Override
    public void stop(boolean enqueue, boolean dequeue, boolean wait) throws AQException {
        this.stop(enqueue, dequeue, wait, false);
    }

    public void stop(boolean enqueue, boolean dequeue, boolean wait, boolean autonomous) throws AQException {
        block15: {
            Statement stopq_stmt = null;
            Connection db_conn = null;
            Object q_name = "";
            String eq_flag = "true";
            String dq_flag = "true";
            String wt_flag = "false";
            if (this.name == null || this.name.equals("")) {
                AQUtil.throwAQEx(122, "invalid name");
            }
            q_name = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
            try {
                try {
                    db_conn = this.aq_sess.getDBConnection();
                }
                catch (Exception ex) {
                    AQUtil.throwAQEx(184);
                }
                if (!enqueue) {
                    eq_flag = "false";
                }
                if (!dequeue) {
                    dq_flag = "false";
                }
                if (wait) {
                    wt_flag = "true";
                }
                Object stmtStr = "";
                if (autonomous) {
                    stmtStr = (String)stmtStr + "declare PRAGMA AUTONOMOUS_TRANSACTION; ";
                }
                stopq_stmt = db_conn.prepareCall((String)stmtStr + "begin dbms_aqadm.stop_queue(queue_name => ?, enqueue => " + eq_flag + ", dequeue => " + dq_flag + ", wait => " + wt_flag + "); end;");
                stopq_stmt.setString(1, (String)q_name);
                stopq_stmt.execute();
                try {
                    stopq_stmt.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sqlex) {
                boolean throw_err;
                boolean bl = throw_err = sqlex.getErrorCode() != 24210;
                if (throw_err) {
                    AQOracleDebug.traceEx(3, "AQOracleQueue.stop", sqlex);
                } else {
                    AQOracleDebug.traceEx(3, "AQOracleQueue.stop ignored error: ", sqlex);
                }
                try {
                    stopq_stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!throw_err) break block15;
                throw new AQOracleSQLException(sqlex);
            }
        }
    }

    @Override
    public void stop(boolean wait) throws AQException {
        this.stop(true, true, wait);
    }

    @Override
    public void stopEnqueue(boolean wait) throws AQException {
        this.stop(true, false, wait);
    }

    @Override
    public void stopDequeue(boolean wait) throws AQException {
        this.stop(false, true, wait);
    }

    @Override
    public void alterQueue(AQQueueProperty q_property) throws AQException {
        CallableStatement aq_stmt = null;
        Connection db_conn = null;
        Object new_queue = null;
        Object q_name = "";
        String ac_flag = "true";
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (!q_property.isAutoCommitEnabled()) {
                ac_flag = "false";
                aq_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_queue(queue_name => ?, max_retries => ?, retry_delay => ?, retention_time => ?, auto_commit => false, comment => ?); end;");
            } else {
                if (this.alterq_stmt != null) {
                    this.alterq_stmt.clearParameters();
                } else {
                    this.alterq_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_queue(queue_name => ?, max_retries => ?, retry_delay => ?, retention_time => ?, auto_commit => true, comment => ?); end;");
                }
                aq_stmt = this.alterq_stmt;
            }
            aq_stmt.setString(1, (String)q_name);
            if (q_property.max_retries != null) {
                ((OracleCallableStatement)aq_stmt).setObject(2, (Object)q_property.max_retries, 4);
            } else {
                ((OracleCallableStatement)aq_stmt).setNull(2, 4);
            }
            if (q_property.retry_interval != null) {
                ((OracleCallableStatement)aq_stmt).setObject(3, (Object)q_property.retry_interval, 8);
            } else {
                ((OracleCallableStatement)aq_stmt).setNull(3, 8);
            }
            if (q_property.retention_time != null) {
                ((OracleCallableStatement)aq_stmt).setObject(4, (Object)q_property.retention_time, 8);
            } else {
                ((OracleCallableStatement)aq_stmt).setNull(4, 8);
            }
            aq_stmt.setString(5, q_property.getComment());
            aq_stmt.execute();
            if (!q_property.equals(this.property)) {
                this.property.setMaxRetries(q_property.getMaxRetries());
                this.property.setRetryInterval(q_property.getRetryInterval());
                this.property.setRetentionTime(q_property.getRetentionTime());
                this.property.setComment(q_property.getComment());
            }
        }
        catch (SQLException sqlex) {
            if (ac_flag.equals("true")) {
                try {
                    this.alterq_stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.alterq_stmt = null;
            }
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterQueue", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public AQMessage createMessage() throws AQException {
        AQOracleMessage message = null;
        AQOracleRawPayload r_payload = null;
        AQOracleObjectPayload o_payload = null;
        AQMessageProperty property = null;
        property = new AQMessageProperty();
        if (this.pload_type == 2) {
            r_payload = new AQOracleRawPayload();
            message = new AQOracleMessage(this.pload_type, r_payload, property);
        } else if (this.pload_type == 1) {
            o_payload = new AQOracleObjectPayload();
            message = new AQOracleMessage(this.pload_type, o_payload, property);
        } else {
            AQUtil.throwAQEx(129);
        }
        return message;
    }

    @Override
    public void drop() throws AQException {
        Statement dq_stmt = null;
        Connection db_conn = null;
        Object q_name = "";
        boolean auto_commit = true;
        String ac_flag = "true";
        q_name = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (!auto_commit) {
                ac_flag = "false";
            }
            Object statementString = "";
            statementString = this.property.isSharded() ? "begin dbms_aqadm.drop_sharded_queue(queue_name => ?); end;" : "begin dbms_aqadm.drop_queue(queue_name => ?, auto_commit =>" + ac_flag + "); end;";
            dq_stmt = db_conn.prepareCall((String)statementString);
            dq_stmt.setString(1, (String)q_name);
            dq_stmt.execute();
            try {
                dq_stmt.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dropQueue", sqlex);
            try {
                dq_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        this.aq_sess = null;
    }

    @Override
    public byte[] enqueue(AQEnqueueOption enq_option, AQMessage message) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        OracleCallableStatement enq_stmt = null;
        AQMessageProperty property = null;
        AQAgent sender = null;
        AQOracleRawPayload raw_pload = null;
        AQOracleObjectPayload obj_pload = null;
        byte[] b_array = null;
        byte[] msg_id = null;
        String str_mid = null;
        Integer visib = null;
        Integer prior = null;
        Integer delay = null;
        Object expire = null;
        Integer p_type = null;
        Hashtable map = null;
        Vector recp_list = null;
        int num_recps = 0;
        OracleArray recp_array = null;
        AQSignature signature = null;
        int index = 0;
        if (message == null) {
            AQUtil.throwAQEx(133);
        }
        if (enq_option == null) {
            AQUtil.throwAQEx(176);
        }
        q_name = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        property = message.getMessageProperty();
        sender = property.getSender();
        signature = property.getSignature();
        try {
            db_conn = this.aq_sess.getDBConnection();
            map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
        }
        catch (Exception ex) {
            AQUtil.throwAQEx(184);
        }
        try {
            map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
        }
        catch (Exception ex2) {
            AQUtil.throwAQEx(146, ex2);
        }
        raw_pload = (AQOracleRawPayload)message.getRawPayload();
        if (raw_pload != null && this.pload_type != 2) {
            AQUtil.throwAQEx(171, "RAW");
        }
        if ((obj_pload = (AQOracleObjectPayload)message.getObjectPayload()) != null && this.pload_type != 1) {
            AQUtil.throwAQEx(171, "OBJECT");
        }
        if ((recp_list = property.getRecipientList()) != null && !recp_list.isEmpty()) {
            num_recps = recp_list.size();
        }
        try {
            if (raw_pload != null) {
                enq_stmt = this.getEnqRawStmt(num_recps, db_conn);
                b_array = raw_pload.getBytes();
                enq_stmt.setBytes(15, b_array);
                p_type = new Integer(2);
            } else if (obj_pload != null) {
                enq_stmt = this.getEnqObjStmt(num_recps, db_conn);
                if (obj_pload.getCustomDatum() != null) {
                    enq_stmt.setCustomDatum(15, obj_pload.getCustomDatum());
                } else if (obj_pload.getOracleData() != null) {
                    enq_stmt.setObject(15, (Object)obj_pload.getOracleData());
                } else if (obj_pload.getSqlData() != null) {
                    Class<?> ocl = obj_pload.getClass();
                    map.put(this.p_data_type, ocl.getName());
                    enq_stmt.setObject(15, (Object)obj_pload.getSqlData(), 2002);
                } else if (obj_pload.getStruct() != null) {
                    enq_stmt.setObject(15, (Object)obj_pload.getStruct(), 2002);
                } else if (obj_pload.getORAData() != null) {
                    enq_stmt.setObject(15, (Object)obj_pload.getORAData());
                } else {
                    AQOracleDebug.trace(3, "AQOracleQueue.enqueue-3", "Null object payload");
                    AQUtil.throwAQEx(104);
                }
                p_type = new Integer(1);
            } else {
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue-2", "Null payload");
                AQUtil.throwAQEx(104);
            }
            enq_stmt.setString(1, (String)q_name);
            if (sender != null) {
                enq_stmt.setString(2, sender.getName());
                enq_stmt.setString(3, sender.getAddress());
                enq_stmt.setInt(4, sender.getProtocol());
            } else {
                enq_stmt.setString(2, null);
                enq_stmt.setString(3, null);
                enq_stmt.setInt(4, 0);
            }
            if (property.getOrigMessageId() != null) {
                enq_stmt.setObject(5, (Object)property.getOrigMessageId(), -2);
            } else {
                enq_stmt.setNull(5, -2);
            }
            enq_stmt.setString(6, property.getCorrelation());
            visib = new Integer(enq_option.getVisibility());
            enq_stmt.setObject(7, (Object)visib, 4);
            prior = new Integer(property.getPriority());
            enq_stmt.setObject(8, (Object)prior, 4);
            delay = new Integer(property.getDelay());
            enq_stmt.setObject(9, (Object)delay, 4);
            enq_stmt.setLong(10, property.getExpiration());
            if (enq_option.getRelMessageId() == null) {
                enq_stmt.setNull(11, -2);
            } else {
                enq_stmt.setBytes(11, enq_option.getRelMessageId());
            }
            if (enq_option.seq_deviation == null) {
                enq_stmt.setNull(12, 2);
            } else {
                enq_stmt.setObject(12, (Object)enq_option.seq_deviation, 4);
            }
            enq_stmt.setString(13, property.getExceptionQueue());
            enq_stmt.setObject(14, (Object)p_type, 4);
            enq_stmt.registerOutParameter(16, -2);
            if (num_recps > 0) {
                recp_array = this.createRecpArrayfromVector(recp_list);
                enq_stmt.setObject(17, (Object)recp_array, 2003);
            }
            if (this.aq_sess.is82compatible()) {
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue", "82 compatible");
                index = num_recps > 0 ? 18 : 17;
                if (signature != null) {
                    enq_stmt.setObject(index, (Object)signature);
                } else {
                    enq_stmt.setNull(index, 2002, "SYS.AQ$_SIG_PROP");
                }
                enq_stmt.setString(++index, enq_option.getTransformation());
            }
            enq_stmt.execute();
            msg_id = enq_stmt.getBytes(16);
            ((AQOracleMessage)message).setMessageId(msg_id);
            if (AQOracleDebug.DEBUG) {
                str_mid = enq_stmt.getString(16);
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue", str_mid);
            }
            if (!AQDriverManager.isStmtCachingEnabled()) {
                this.destroyStmt(enq_stmt);
            }
        }
        catch (AQException aqex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.enqueue-4", aqex);
            this.destroyStmt(enq_stmt);
            throw aqex;
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.enqueue-5", sqlex);
            this.destroyStmt(enq_stmt);
            throw new AQOracleSQLException(sqlex);
        }
        return msg_id;
    }

    @Override
    public AQMessage dequeue(AQDequeueOption deq_option) throws AQException {
        if (this.pload_type == 1) {
            AQUtil.throwAQEx(174);
        }
        return this.dequeue(deq_option, null, null, false);
    }

    @Override
    public AQMessage dequeue(AQDequeueOption deq_option, CustomDatumFactory payload_fact) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (payload_fact == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(deq_option, payload_fact, null, false);
    }

    public AQMessage dequeue(AQDequeueOption deq_option, ORADataFactory payload_fact) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (payload_fact == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(deq_option, payload_fact, null, false);
    }

    @Override
    public AQMessage dequeue(AQDequeueOption deq_option, OracleDataFactory payload_fact) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (payload_fact == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(deq_option, payload_fact, null, false);
    }

    @Override
    public AQMessage dequeue(AQDequeueOption deq_option, Class sql_data_cl) throws AQException {
        Object cl = null;
        String cl_name = null;
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (sql_data_cl == null) {
            AQUtil.throwAQEx(169);
        }
        if ((cl_name = sql_data_cl.getName()).equals("java.sql.SQLData")) {
            AQUtil.throwAQEx(191);
        }
        return this.dequeue(deq_option, null, sql_data_cl, false);
    }

    AQMessage dequeue(AQDequeueOption deq_option, Object payload_fact, Class sql_data_cl, boolean get_recpl) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        OracleCallableStatement deq_stmt = null;
        Object sel_stmt = null;
        byte[] b_array = null;
        byte[] msg_id = null;
        Object sel_rset = null;
        AQMessageProperty property = null;
        AQOracleMessage message = null;
        AQAgent sender = null;
        AQOracleRawPayload rawpayload = null;
        AQOracleObjectPayload objpayload = null;
        Integer navig = null;
        Integer visib = null;
        Integer dq_mode = null;
        Integer wt_mode = null;
        Integer p_type = null;
        String s_name = null;
        TIMESTAMP ts = null;
        Timestamp etime = null;
        Hashtable map = null;
        long secs = 0L;
        long msecs = 0L;
        CustomDatum obj_cust_data = null;
        ORAData obj_ora_data = null;
        OracleData obj_oracle_data = null;
        Object obj_sql_data = null;
        OracleStruct obj_str_data = null;
        OracleArray recp_list = null;
        AQAgent[] agent_list = null;
        Vector<AQAgent> recp_vec = null;
        int idx = 0;
        int agidx = 0;
        String user_payload_type = null;
        int sign_out_idx = 0;
        if (deq_option == null) {
            AQUtil.throwAQEx(175);
        }
        q_name = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        if (this.pload_type == 1 && payload_fact == null && sql_data_cl == null) {
            AQUtil.throwAQEx(167);
        }
        if (payload_fact != null && sql_data_cl != null) {
            AQUtil.throwAQEx(168);
        }
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex2) {
                AQUtil.throwAQEx(146, ex2);
            }
            if (this.pload_type == 2) {
                deq_stmt = this.getDeqRawStmt(db_conn);
                p_type = new Integer(2);
                deq_stmt.registerOutParameter(24, -2);
            } else if (this.pload_type == 1) {
                deq_stmt = this.getDeqObjStmt(db_conn);
                p_type = new Integer(1);
                deq_stmt.registerOutParameter(24, -2);
                if (deq_option.getTransformation() != null) {
                    user_payload_type = this.getTransfxmDest(deq_option.getTransformation());
                    AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "transfxm:" + deq_option.getTransformation());
                    AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "user_payload_type: " + user_payload_type);
                    if (user_payload_type.equalsIgnoreCase("SYS.XMLTYPE")) {
                        deq_stmt.registerOutParameter(25, 2007, user_payload_type);
                    } else {
                        deq_stmt.registerOutParameter(25, 2002, user_payload_type);
                    }
                } else if (this.p_data_type.equalsIgnoreCase("SYS.XMLTYPE")) {
                    deq_stmt.registerOutParameter(25, 2007, this.p_data_type);
                } else {
                    deq_stmt.registerOutParameter(25, 2002, this.p_data_type);
                }
            } else {
                AQUtil.throwAQEx(129);
            }
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "q_name=" + (String)q_name);
            deq_stmt.setString(1, (String)q_name);
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "cons_name=" + deq_option.getConsumerName());
            deq_stmt.setString(2, deq_option.getConsumerName());
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "message_id=" + String.valueOf(deq_option.getMessageId()));
            if (deq_option.getMessageId() == null) {
                deq_stmt.setNull(3, -2);
            } else {
                deq_stmt.setBytes(3, deq_option.getMessageId());
            }
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "corr_id=" + deq_option.getCorrelation());
            deq_stmt.setString(4, deq_option.getCorrelation());
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "deq_mode=" + deq_option.getDequeueMode());
            dq_mode = new Integer(deq_option.getDequeueMode());
            deq_stmt.setObject(5, (Object)dq_mode, 4);
            navig = new Integer(deq_option.getNavigationMode());
            deq_stmt.setObject(6, (Object)navig, 4);
            visib = new Integer(deq_option.getVisibility());
            deq_stmt.setObject(7, (Object)visib, 4);
            wt_mode = new Integer(deq_option.getWaitTime());
            deq_stmt.setObject(8, (Object)wt_mode, 4);
            if (this.aq_sess.is100compatible()) {
                deq_stmt.registerOutParameter(9, 93);
            } else {
                deq_stmt.registerOutParameter(9, 91);
            }
            deq_stmt.registerOutParameter(10, 4);
            deq_stmt.registerOutParameter(11, -2);
            deq_stmt.registerOutParameter(12, 12);
            deq_stmt.registerOutParameter(13, 4);
            deq_stmt.registerOutParameter(14, 4);
            deq_stmt.registerOutParameter(15, 4);
            deq_stmt.registerOutParameter(16, 4);
            deq_stmt.registerOutParameter(17, 12);
            deq_stmt.registerOutParameter(18, 2003, "SYS.AQ$_RECIPIENTS");
            deq_stmt.registerOutParameter(19, 12);
            deq_stmt.registerOutParameter(20, 12);
            deq_stmt.registerOutParameter(21, 4);
            deq_stmt.registerOutParameter(22, -2);
            deq_stmt.setObject(23, (Object)p_type, 4);
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "bound all pre82 params");
            if (this.aq_sess.is82compatible()) {
                AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "binding v82 params");
                if (this.pload_type == 2) {
                    idx = 25;
                } else if (this.pload_type == 1) {
                    idx = 26;
                }
                AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "idx: " + idx + " condition: " + deq_option.getCondition());
                deq_stmt.setString(idx++, deq_option.getCondition());
                if (deq_option.getSignature() != null) {
                    deq_stmt.setObject(idx++, (Object)deq_option.getSignature());
                } else {
                    deq_stmt.setNull(idx++, 2002, "SYS.AQ$_SIG_PROP");
                }
                deq_stmt.registerOutParameter(idx, 2002, "SYS.AQ$_SIG_PROP");
                sign_out_idx = idx++;
                deq_stmt.setString(idx, deq_option.getTransformation());
            }
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "before execute");
            deq_stmt.execute();
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "after execute");
            property = new AQMessageProperty();
            if (this.aq_sess.is100compatible()) {
                ts = deq_stmt.getTIMESTAMP(9);
                etime = ts.timestampValue();
            } else {
                etime = deq_stmt.getTimestamp(9);
            }
            secs = etime.getTime();
            msecs = secs + (long)(etime.getNanos() / 1000000);
            Date dt = new Date(msecs);
            property.setEnqueueTime(dt);
            property.setState(deq_stmt.getInt(10));
            msg_id = deq_stmt.getBytes(11);
            property.setCorrelation(deq_stmt.getString(12));
            property.setPriority(deq_stmt.getInt(13));
            property.setDelay(deq_stmt.getInt(14));
            property.setExpiration(deq_stmt.getLong(15));
            property.setAttempts(deq_stmt.getInt(16));
            property.setExceptionQueue(deq_stmt.getString(17));
            if (get_recpl && (recp_list = (OracleArray)deq_stmt.getArray(18)) != null && recp_list.length() > 0) {
                agent_list = this.createAgentListfromSubsArray(recp_list);
                recp_vec = new Vector<AQAgent>(agent_list.length);
                for (agidx = 0; agidx < agent_list.length; ++agidx) {
                    recp_vec.addElement(agent_list[agidx]);
                }
                property.setRecipientList(recp_vec);
            }
            if ((s_name = deq_stmt.getString(19)) != null && !s_name.equals("")) {
                sender = new AQAgent(s_name, deq_stmt.getString(20), deq_stmt.getInt(21));
                property.setSender(sender);
            }
            property.setOrigMessageId(deq_stmt.getBytes(22));
            if (this.pload_type == 2) {
                b_array = deq_stmt.getBytes(24);
                rawpayload = new AQOracleRawPayload(b_array, b_array.length);
                message = new AQOracleMessage(this.pload_type, rawpayload, property);
            } else {
                if (payload_fact != null) {
                    AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "payload_fact != null");
                    if (payload_fact instanceof CustomDatumFactory) {
                        AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "payload_fact == CustomDatumFactory");
                        obj_cust_data = (CustomDatum)deq_stmt.getCustomDatum(25, (CustomDatumFactory)payload_fact);
                        objpayload = new AQOracleObjectPayload(obj_cust_data);
                    } else if (payload_fact instanceof ORADataFactory) {
                        AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "payload_fact == ORADataFactory");
                        obj_ora_data = (ORAData)deq_stmt.getORAData(25, (ORADataFactory)payload_fact);
                        objpayload = new AQOracleObjectPayload(obj_ora_data);
                    } else {
                        AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "payload_fact == OracleDataFactory");
                        obj_oracle_data = (OracleData)deq_stmt.getObject(25, (OracleDataFactory)payload_fact);
                        objpayload = new AQOracleObjectPayload(obj_oracle_data);
                    }
                } else if (sql_data_cl != null) {
                    String cl_name = sql_data_cl.getName();
                    AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "sql_data_cl!= null:" + cl_name);
                    if (cl_name.equals("oracle.jdbc.OracleStruct")) {
                        obj_str_data = (OracleStruct)deq_stmt.getObject(25, (Map)null);
                        objpayload = new AQOracleObjectPayload(obj_str_data);
                    } else {
                        if (deq_option.getTransformation() != null) {
                            map.put(user_payload_type, sql_data_cl);
                        } else {
                            map.put(this.p_data_type, sql_data_cl);
                        }
                        objpayload = new AQOracleObjectPayload();
                        objpayload.setPayloadData(deq_stmt.getObject(25));
                    }
                }
                AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "before constructing message");
                message = new AQOracleMessage(this.pload_type, objpayload, property);
                AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "after constructing message");
            }
            message.setMessageId(msg_id);
            if (this.aq_sess.is82compatible()) {
                property.setSignature((AQSignature)deq_stmt.getObject(sign_out_idx, AQSignature.getFactory()));
            }
            if (!AQDriverManager.isStmtCachingEnabled()) {
                this.destroyStmt(deq_stmt);
            }
        }
        catch (AQException aqex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dequeue-2", aqex);
            this.destroyStmt(deq_stmt);
            throw aqex;
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dequeue-3", sqlex);
            this.destroyStmt(deq_stmt);
            throw new AQOracleSQLException(sqlex);
        }
        return message;
    }

    @Override
    public void addSubscriber(AQAgent subscriber, String rule) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        Hashtable map = null;
        AQOracleAgent agt = null;
        if (subscriber == null) {
            AQUtil.throwAQEx(149);
        }
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            agt = new AQOracleAgent(subscriber.getName(), subscriber.getAddress(), subscriber.getProtocol());
            if (this.adds_stmt != null) {
                this.adds_stmt.clearParameters();
            } else {
                this.adds_stmt = db_conn.prepareCall("begin dbms_aqadm.add_subscriber(queue_name => ?, subscriber => ?, rule => ?); end;");
            }
            this.adds_stmt.setString(1, (String)q_name);
            this.adds_stmt.setObject(2, (Object)agt, 2002);
            this.adds_stmt.setString(3, rule);
            this.adds_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.adds_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.adds_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.addSubscriber", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void removeSubscriber(AQAgent subscriber) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        Hashtable map = null;
        AQOracleAgent agt = null;
        if (subscriber == null) {
            AQUtil.throwAQEx(149);
        }
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            agt = new AQOracleAgent(subscriber.getName(), subscriber.getAddress(), subscriber.getProtocol());
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else {
                this.rems_stmt = db_conn.prepareCall("begin dbms_aqadm.remove_subscriber(queue_name => ?, subscriber => ?); end;");
            }
            this.rems_stmt.setString(1, (String)q_name);
            this.rems_stmt.setObject(2, (Object)agt, 2002);
            this.rems_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.rems_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rems_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.removeSubscriber", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void alterSubscriber(AQAgent subscriber, String rule) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        Hashtable map = null;
        AQOracleAgent agt = null;
        if (subscriber == null) {
            AQUtil.throwAQEx(149);
        }
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            agt = new AQOracleAgent(subscriber.getName(), subscriber.getAddress(), subscriber.getProtocol());
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                this.alts_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_subscriber(queue_name => ?, subscriber => ?, rule => ?); end;");
            }
            this.alts_stmt.setString(1, (String)q_name);
            this.alts_stmt.setObject(2, (Object)agt, 2002);
            this.alts_stmt.setString(3, rule);
            this.alts_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alts_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterSubscriber", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public AQAgent[] getSubscribers() throws AQException {
        Connection db_conn = null;
        OracleCallableStatement gsubs_stmt = null;
        Hashtable map = null;
        Object q_name = "";
        OracleArray subs_list = null;
        AQAgent[] agent_list = null;
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
                map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.jakarta.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(146, ex);
            }
            gsubs_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_queue_subscribers(?, ?); end;");
            gsubs_stmt.setString(1, (String)q_name);
            gsubs_stmt.registerOutParameter(2, 2003, "SYS.AQ$_SUBSCRIBERS");
            gsubs_stmt.execute();
            subs_list = (OracleArray)gsubs_stmt.getArray(2);
            if (subs_list != null && subs_list.length() > 0) {
                AQOracleDebug.println("Array is of length: " + subs_list.length());
                AQOracleDebug.println("Array is of type " + subs_list.getSQLTypeName());
                AQOracleDebug.println("Array element is of type code " + subs_list.getBaseType());
                AQOracleDebug.println("Array element is of type name " + subs_list.getBaseTypeName());
                agent_list = this.createAgentListfromSubsArray(subs_list);
            }
            try {
                gsubs_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getSubscribers", sqlex);
            try {
                gsubs_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        return agent_list;
    }

    @Override
    public void schedulePropagation(String destination, Date start_time, Double duration, String next_time, Double latency) throws AQException {
        this.schedulePropagation(destination, null, start_time, duration, next_time, latency);
    }

    @Override
    public synchronized void schedulePropagation(String destination, String dest_queue, Date start_time, Double duration, String next_time, Double latency) throws AQException {
        Connection db_conn = null;
        Statement scprop_stmt = null;
        Object st_time = null;
        Object q_name = "";
        Double lat_val = null;
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (dest_queue != null && !this.aq_sess.is102compatible()) {
                AQUtil.throwAQEx(102);
            }
            if (scprop_stmt == null) {
                scprop_stmt = this.aq_sess.is102compatible() ? (start_time == null ? db_conn.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?, destination_queue => ?); end;") : db_conn.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?, start_time => ?, destination_queue => ?); end;")) : (start_time == null ? db_conn.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?); end;") : db_conn.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?, start_time => ?); end;"));
            } else {
                scprop_stmt.clearParameters();
            }
            scprop_stmt.setString(1, (String)q_name);
            scprop_stmt.setString(2, destination);
            scprop_stmt.setObject(3, duration, 8);
            scprop_stmt.setString(4, next_time);
            if (latency != null) {
                scprop_stmt.setObject(5, latency, 8);
            } else {
                lat_val = new Double(60.0);
                scprop_stmt.setObject(5, lat_val, 8);
            }
            int destIndex = 6;
            if (start_time != null) {
                scprop_stmt.setTimestamp(6, new Timestamp(start_time.getTime()));
                destIndex = 7;
            }
            if (this.aq_sess.is102compatible()) {
                scprop_stmt.setString(destIndex, dest_queue);
            }
            scprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.schedulePropagation", sqlex);
            try {
                scprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            scprop_stmt = null;
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void unschedulePropagation(String destination) throws AQException {
        this.unschedulePropagation(destination, null);
    }

    @Override
    public void unschedulePropagation(String destination, String dest_queue) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (dest_queue != null && !this.aq_sess.is102compatible()) {
                AQUtil.throwAQEx(102);
            }
            if (this.unscprop_stmt == null) {
                this.unscprop_stmt = this.aq_sess.is102compatible() ? db_conn.prepareCall("begin dbms_aqadm.unschedule_propagation(queue_name => ?, destination => ?, destination_queue => ?); end;") : db_conn.prepareCall("begin dbms_aqadm.unschedule_propagation(queue_name => ?, destination => ?); end;");
            } else {
                this.unscprop_stmt.clearParameters();
            }
            this.unscprop_stmt.setString(1, (String)q_name);
            this.unscprop_stmt.setString(2, destination);
            if (this.aq_sess.is102compatible()) {
                this.unscprop_stmt.setString(3, dest_queue);
            }
            this.unscprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.unscprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unscprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.unschedulePropagation", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void alterPropagationSchedule(String destination, Double duration, String next_time, Double latency) throws AQException {
        this.alterPropagationSchedule(destination, null, duration, next_time, latency);
    }

    @Override
    public void alterPropagationSchedule(String destination, String dest_queue, Double duration, String next_time, Double latency) throws AQException {
        Connection db_conn = null;
        Object st_time = null;
        Object q_name = "";
        Double lat_val = null;
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (dest_queue != null && !this.aq_sess.is102compatible()) {
                AQUtil.throwAQEx(102);
            }
            if (this.alprop_stmt != null) {
                this.alprop_stmt.clearParameters();
            } else {
                this.alprop_stmt = this.aq_sess.is102compatible() ? db_conn.prepareCall("begin dbms_aqadm.alter_propagation_schedule(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?, destination_queue => ?); end;") : db_conn.prepareCall("begin dbms_aqadm.alter_propagation_schedule(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?); end;");
            }
            this.alprop_stmt.setString(1, (String)q_name);
            this.alprop_stmt.setString(2, destination);
            this.alprop_stmt.setObject(3, (Object)duration, 8);
            this.alprop_stmt.setString(4, next_time);
            if (latency != null) {
                this.alprop_stmt.setObject(5, (Object)latency, 8);
            } else {
                lat_val = new Double(60.0);
                this.alprop_stmt.setObject(5, (Object)lat_val, 8);
            }
            if (this.aq_sess.is102compatible()) {
                this.alprop_stmt.setString(6, dest_queue);
            }
            this.alprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.alprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterPropagationSchedule", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void enablePropagationSchedule(String destination) throws AQException {
        this.enablePropagationSchedule(destination, null);
    }

    @Override
    public void enablePropagationSchedule(String destination, String dest_queue) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (dest_queue != null && !this.aq_sess.is102compatible()) {
                AQUtil.throwAQEx(102);
            }
            if (this.enprop_stmt != null) {
                this.enprop_stmt.clearParameters();
            } else {
                this.enprop_stmt = this.aq_sess.is102compatible() ? db_conn.prepareCall("begin dbms_aqadm.enable_propagation_schedule(queue_name => ?, destination => ?, destination_queue => ?); end;") : db_conn.prepareCall("begin dbms_aqadm.enable_propagation_schedule(queue_name => ?, destination => ?); end;");
            }
            this.enprop_stmt.setString(1, (String)q_name);
            this.enprop_stmt.setString(2, destination);
            if (this.aq_sess.is102compatible()) {
                this.enprop_stmt.setString(3, dest_queue);
            }
            this.enprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.enprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.enprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.enablePropagationSchedule", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void disablePropagationSchedule(String destination) throws AQException {
        this.disablePropagationSchedule(destination, null);
    }

    @Override
    public void disablePropagationSchedule(String destination, String dest_queue) throws AQException {
        Connection db_conn = null;
        Object q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (dest_queue != null && !this.aq_sess.is102compatible()) {
                AQUtil.throwAQEx(102);
            }
            if (this.disprop_stmt != null) {
                this.disprop_stmt.clearParameters();
            } else {
                this.disprop_stmt = this.aq_sess.is102compatible() ? db_conn.prepareCall("begin dbms_aqadm.disable_propagation_schedule(queue_name => ?, destination => ?, destination_queue => ?); end;") : db_conn.prepareCall("begin dbms_aqadm.disable_propagation_schedule(queue_name => ?, destination => ?); end;");
            }
            this.disprop_stmt.setString(1, (String)q_name);
            this.disprop_stmt.setString(2, destination);
            if (this.aq_sess.is102compatible()) {
                this.disprop_stmt.setString(3, dest_queue);
            }
            this.disprop_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.disprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.disprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.disablePropagationSchedule", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void grantQueuePrivilege(String privilege, String grantee, boolean grant_option) throws AQException {
        Connection db_conn = null;
        Statement grant_stmt = null;
        Object q_name = "";
        String grant_flag = "false";
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            if (grant_option) {
                grant_flag = "true";
            }
            grant_stmt = db_conn.prepareCall("begin dbms_aqadm.grant_queue_privilege(privilege => ?, queue_name => ?, grantee => ?, grant_option => " + grant_flag + "); end;");
            grant_stmt.setString(1, privilege);
            grant_stmt.setString(2, (String)q_name);
            grant_stmt.setString(3, grantee);
            grant_stmt.execute();
            try {
                grant_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.grantQueuePrivilege", sqlex);
            try {
                grant_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public void grantQueuePrivilege(String privilege, String grantee) throws AQException {
        this.grantQueuePrivilege(privilege, grantee, false);
    }

    @Override
    public void revokeQueuePrivilege(String privilege, String grantee) throws AQException {
        Connection db_conn = null;
        CallableStatement revoke_stmt = null;
        Object q_name = "";
        q_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(184);
            }
            revoke_stmt = db_conn.prepareCall("begin dbms_aqadm.revoke_queue_privilege(privilege => ?, queue_name => ?, grantee => ?); end;");
            revoke_stmt.setString(1, privilege);
            revoke_stmt.setString(2, (String)q_name);
            revoke_stmt.setString(3, grantee);
            revoke_stmt.execute();
            try {
                revoke_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.revokeQueuePrivilege", sqlex);
            try {
                revoke_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
    }

    @Override
    public byte[] propEnqueue(AQEnqueueOption enq_option, AQMessage message) throws AQException {
        return this.enqueue(enq_option, message);
    }

    @Override
    public AQMessage propDequeue(AQDequeueOption deq_option) throws AQException {
        if (this.pload_type == 1) {
            AQUtil.throwAQEx(174);
        }
        return this.dequeue(deq_option, null, null, true);
    }

    @Override
    public AQMessage propDequeue(AQDequeueOption deq_option, Class sql_data_cl) throws AQException {
        Class<?> cl = null;
        String cl_name = null;
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (sql_data_cl == null) {
            AQUtil.throwAQEx(169);
        }
        if ((cl_name = sql_data_cl.getName()).equals("java.sql.SQLData")) {
            AQUtil.throwAQEx(191);
        }
        try {
            cl = Class.forName("java.sql.SQLData");
        }
        catch (Exception ex) {
            AQUtil.throwAQEx(109);
        }
        if (!cl.isAssignableFrom(sql_data_cl)) {
            AQUtil.throwAQEx(191);
        }
        return this.dequeue(deq_option, null, sql_data_cl, true);
    }

    @Override
    public AQMessage propDequeue(AQDequeueOption deq_option, CustomDatumFactory payload_fact) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (payload_fact == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(deq_option, payload_fact, null, true);
    }

    @Override
    public AQMessage propDequeue(AQDequeueOption deq_option, OracleDataFactory payload_fact) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (payload_fact == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(deq_option, payload_fact, null, true);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQQueue]");
        buf.append("\n  owner            : " + this.owner);
        buf.append("\n  name             : " + this.name);
        buf.append("\n  queue table      : " + this.table);
        if (this.property != null) {
            buf.append("\n" + this.property.toString());
        }
        if (this.pload_type == 2) {
            buf.append("\n  Payload type     : RAW");
        } else if (this.pload_type == 1) {
            buf.append("\n  Payload type     : OBJECT");
        } else {
            buf.append("\n  Payload type     : UNKNOWN");
        }
        buf.append("\n");
        return buf.toString();
    }

    public boolean isMultiConsumer() throws AQException {
        int q_type;
        if (this.queue_type == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.isMultiConsumer", "queue_type==null");
            String q_table_name = this.getQueueTableName();
            q_table_name = q_table_name.substring(q_table_name.indexOf(".") + 1, q_table_name.length());
            AQQueueTable q_table = this.aq_sess.getQueueTable(this.getOwner(), q_table_name);
            this.queue_type = ((AQOracleQueueTable)q_table).isMulticonsumerEnabled() ? new Integer(2) : new Integer(1);
        }
        return (q_type = this.queue_type.intValue()) == 2;
    }

    private OracleArray createRecpArrayfromVector(Vector recp_list) throws AQException {
        Connection db_conn = null;
        Object[] obj_array = null;
        OracleArray recp_array = null;
        int num_recps = 0;
        AQOracleAgent ora_agt = null;
        AQAgent agt = null;
        int i = 0;
        if (recp_list == null || recp_list.isEmpty()) {
            AQUtil.throwAQEx(145);
        }
        num_recps = recp_list.size();
        obj_array = new Object[num_recps];
        for (i = 0; i < num_recps; ++i) {
            agt = (AQAgent)recp_list.elementAt(i);
            ora_agt = new AQOracleAgent(agt.getName(), agt.getAddress(), agt.getProtocol());
            obj_array[i] = ora_agt;
        }
        try {
            db_conn = this.aq_sess.getDBConnection();
        }
        catch (Exception ex) {
            AQUtil.throwAQEx(184);
        }
        try {
            recp_array = (OracleArray)((OracleConnection)db_conn).createOracleArray("SYS.AQ$_RECIPIENTS", (Object)obj_array);
        }
        catch (SQLException sqlex) {
            throw new AQOracleSQLException(sqlex);
        }
        return recp_array;
    }

    private AQAgent[] createAgentListfromSubsArray(OracleArray recp_array) throws AQException {
        Connection db_conn = null;
        Object[] values = null;
        int num_recps = 0;
        AQOracleAgent ora_agt = null;
        Object agt = null;
        AQAgent[] agt_list = null;
        Hashtable map = null;
        int i = 0;
        try {
            db_conn = this.aq_sess.getDBConnection();
            map = (Hashtable)((OracleConnection)db_conn).getTypeMap();
        }
        catch (Exception ex) {
            AQUtil.throwAQEx(184);
        }
        try {
            if (recp_array == null || recp_array.length() == 0) {
                AQUtil.throwAQEx(145);
            }
            num_recps = recp_array.length();
            agt_list = new AQAgent[num_recps];
            values = (Object[])recp_array.getArray((Map)map);
        }
        catch (SQLException sqlex) {
            throw new AQOracleSQLException(sqlex);
        }
        for (i = 0; i < num_recps; ++i) {
            ora_agt = (AQOracleAgent)values[i];
            AQOracleDebug.println("Agent: " + ora_agt.name + "  " + ora_agt.address + "  " + ora_agt.protocol);
            agt_list[i] = new AQAgent(ora_agt.name, ora_agt.address, ora_agt.protocol);
        }
        return agt_list;
    }

    OracleCallableStatement getEnqRawStmt(int num_recps, Connection db_conn) throws AQException, SQLException {
        OracleCallableStatement enq_stmt;
        AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "num_recps=" + num_recps);
        if (num_recps > 0) {
            if (this.enqr_rcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "recp list - stmt=null");
                this.enqr_rcp_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_raw( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?, object_user_data => null, recipients => ?, signature => ?, transformation => ?); end; ") : (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_raw( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?, object_user_data => null, recipients => ?); end; ");
            } else {
                this.enqr_rcp_stmt.clearParameters();
            }
            enq_stmt = this.enqr_rcp_stmt;
        } else {
            if (this.enqr_norcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "no recp list - stmt=null");
                this.enqr_norcp_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_raw_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?, signature => ?, transformation => ?); end; ") : (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_raw_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?); end; ");
            } else {
                this.enqr_norcp_stmt.clearParameters();
            }
            enq_stmt = this.enqr_norcp_stmt;
        }
        return enq_stmt;
    }

    OracleCallableStatement getEnqObjStmt(int num_recps, Connection db_conn) throws AQException, SQLException {
        OracleCallableStatement enq_stmt;
        AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "num_recps=" + num_recps);
        if (num_recps > 0) {
            if (this.enqo_rcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "recp list - stmt=null");
                if (this.aq_sess.is82compatible()) {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "82 compatible");
                    this.enqo_rcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ?, signature => ?, transformation => ?); end;");
                } else {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "not 82 compatible");
                    this.enqo_rcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ?); end;");
                }
            } else {
                this.enqo_rcp_stmt.clearParameters();
            }
            enq_stmt = this.enqo_rcp_stmt;
        } else {
            if (this.enqo_norcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "no recp list - stmt=null");
                if (this.aq_sess.is82compatible()) {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "82 compatible");
                    this.enqo_norcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, signature => ?, transformation => ?); end; ");
                } else {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "not 82 compatible");
                    this.enqo_norcp_stmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?); end; ");
                }
            } else {
                this.enqo_norcp_stmt.clearParameters();
            }
            enq_stmt = this.enqo_norcp_stmt;
        }
        return enq_stmt;
    }

    OracleCallableStatement getDeqRawStmt(Connection db_conn) throws AQException, SQLException {
        AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "entry");
        if (this.deq_raw_stmt == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "stmt=null");
            this.deq_raw_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_raw( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ") : (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_raw( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_raw_stmt.clearParameters();
        }
        return this.deq_raw_stmt;
    }

    OracleCallableStatement getDeqObjStmt(Connection db_conn) throws AQException, SQLException {
        AQOracleDebug.trace(4, "AQOracleQueue.getDeqObjStmt", "entry");
        if (this.deq_obj_stmt == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.getDeqObjStmt", "stmt=null");
            this.deq_obj_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ") : (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_obj_stmt.clearParameters();
        }
        return this.deq_obj_stmt;
    }

    void destroyStmt(OracleCallableStatement stmt) throws AQException {
        if (stmt == null) {
            return;
        }
        try {
            if (stmt == this.enqo_rcp_stmt) {
                this.enqo_rcp_stmt = null;
            } else if (stmt == this.enqo_norcp_stmt) {
                this.enqo_norcp_stmt = null;
            } else if (stmt == this.enqr_rcp_stmt) {
                this.enqr_rcp_stmt = null;
            } else if (stmt == this.enqr_norcp_stmt) {
                this.enqr_norcp_stmt = null;
            } else if (stmt == this.deq_raw_stmt) {
                this.deq_raw_stmt = null;
            } else if (stmt == this.deq_obj_stmt) {
                this.deq_obj_stmt = null;
            } else {
                AQOracleDebug.trace(1, "AQOracleQueue.destroyStmt", "internal error - stmt not found");
                AQUtil.throwAQEx(122, "stmt not found");
            }
            stmt.close();
        }
        catch (SQLException sql_ex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.destroystmterror during stmt close", sql_ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.alterq_stmt != null) {
                this.alterq_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.rems_stmt != null) {
                this.rems_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.adds_stmt != null) {
                this.adds_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.alts_stmt != null) {
                this.alts_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.allq_stmt != null) {
                this.allq_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.allqo_stmt != null) {
                this.allqo_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.alprop_stmt != null) {
                this.alprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.unscprop_stmt != null) {
                this.unscprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enprop_stmt != null) {
                this.enprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.disprop_stmt != null) {
                this.disprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enqr_norcp_stmt != null) {
                this.enqr_norcp_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enqo_rcp_stmt != null) {
                this.enqo_rcp_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enqo_norcp_stmt != null) {
                this.enqo_norcp_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enqr_rcp_stmt != null) {
                this.enqr_rcp_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.deq_raw_stmt != null) {
                this.deq_raw_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.deq_obj_stmt != null) {
                this.deq_obj_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aq_sess = null;
    }

    String getTransfxmDest(String transfxm) {
        int commapos = -1;
        OracleCallableStatement pstmt = null;
        String dest_type = null;
        String src_type = null;
        String transfxm_schema = null;
        String transfxm_name = null;
        Connection db_conn = null;
        commapos = transfxm.indexOf(".", 1);
        AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "enter:" + transfxm);
        try {
            if (commapos == -1) {
                transfxm_schema = ((OracleConnection)db_conn).getUserName();
                transfxm_name = transfxm;
            } else {
                transfxm_schema = transfxm.substring(0, commapos);
                transfxm_name = transfxm.substring(commapos + 1);
            }
            AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "schema" + transfxm_schema + " name: " + transfxm_name);
            dest_type = (String)this.trans_list.get(transfxm_schema + "." + transfxm_name);
            if (dest_type != null) {
                AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "dest_type cached:" + dest_type);
                return dest_type;
            }
            db_conn = this.aq_sess.getDBConnection();
            pstmt = (OracleCallableStatement)db_conn.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ?, ?); end;");
            pstmt.setString(1, transfxm_schema.toUpperCase());
            pstmt.setString(2, transfxm_name.toUpperCase());
            pstmt.registerOutParameter(3, 12);
            pstmt.registerOutParameter(4, 12);
            pstmt.execute();
            src_type = pstmt.getString(3);
            dest_type = pstmt.getString(4);
            AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "dest_type:" + dest_type);
        }
        catch (SQLException ex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getTransfxmDest ex1", ex);
        }
        catch (AQException ex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getTransfxmDest ex2", ex);
        }
        try {
            pstmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dest_type != null) {
            this.trans_list.put(transfxm_schema + "." + transfxm_name, dest_type);
        }
        return dest_type;
    }

    void setTransTable(Hashtable t_list) {
        this.trans_list = t_list;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public synchronized AQOracleQueue cloneQueue() throws AQException {
        AQOracleQueue clone_q = new AQOracleQueue((AQOracleSession)null, this.owner, this.name, this.table, this.property, this.pload_type, this.p_data_type, this.secure);
        clone_q.setTransTable((Hashtable)this.trans_list.clone());
        clone_q.queue_type = this.queue_type;
        return clone_q;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

