/*
 * Decompiled with CFR 0.152.
 */
package oracle.jakarta.AQ;

import java.io.Serializable;
import oracle.jakarta.AQ.AQException;

public class AQQueueProperty
implements Serializable {
    public static final int NORMAL_QUEUE = 0;
    public static final int EXCEPTION_QUEUE = 1;
    static final int DEFAULT_QUEUE_TYPE = 0;
    static final int DEFAULT_MAX_RETRIES = 0;
    static final int DEFAULT_RETRY_INTERVAL = 0;
    static final int DEFAULT_RETENTION_TIME = 0;
    static final boolean DEFAULT_DEP_TRACKING = false;
    static final boolean DEFAULT_AUTO_COMMIT = true;
    public static final int INFINITE = -1;
    protected int type = 0;
    Integer max_retries = null;
    Double retry_interval = null;
    Double retention_time = null;
    private boolean dep_tracking = false;
    private String comment = null;
    private boolean auto_commit = true;
    private boolean sharded;
    private boolean migration;
    private boolean isJson;

    public int getQueueType() {
        return this.type;
    }

    public void setQueueType(int q_type) throws AQException {
        if (q_type != 0 && q_type != 1) {
            throw new AQException(0, "Invalid queue type");
        }
        this.type = q_type;
    }

    public int getMaxRetries() {
        if (this.max_retries == null) {
            return 0;
        }
        return this.max_retries;
    }

    public void setMaxRetries(int retries) {
        this.max_retries = new Integer(retries);
    }

    public void setMaxRetries(Integer retries) {
        this.max_retries = retries;
    }

    public double getRetryInterval() {
        if (this.retry_interval == null) {
            return 0.0;
        }
        return this.retry_interval;
    }

    public void setRetryInterval(double interval) {
        this.retry_interval = new Double(interval);
    }

    public void setRetryInterval(Double interval) {
        this.retry_interval = interval;
    }

    public double getRetentionTime() {
        if (this.retention_time == null) {
            return 0.0;
        }
        return this.retention_time;
    }

    public void setRetentionTime(double r_time) {
        this.retention_time = new Double(r_time);
    }

    public void setRetentionTime(Double r_time) {
        this.retention_time = r_time;
    }

    boolean isDepTrackingEnabled() {
        return this.dep_tracking;
    }

    void setDepTracking(boolean flag) throws AQException {
        if (flag) {
            throw new AQException(0, "Dependency tracking cannot be TRUE");
        }
        this.dep_tracking = flag;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String qt_comment) {
        this.comment = qt_comment;
    }

    public boolean isSharded() {
        return this.sharded;
    }

    public void setSharded(boolean flag) {
        this.sharded = flag;
    }

    public boolean isMigrating() {
        return this.migration;
    }

    public void setMigrating(boolean flag) {
        this.migration = flag;
    }

    public boolean isJson() {
        return this.isJson;
    }

    public void setJson(boolean flag) {
        this.isJson = flag;
    }

    boolean isAutoCommitEnabled() throws AQException {
        return this.auto_commit;
    }

    void setAutoCommit(boolean flag) throws AQException {
        this.auto_commit = flag;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQQueueProperty]");
        if (this.type == 0) {
            buf.append("\n  type             : NORMAL");
        } else {
            buf.append("\n  type             : EXCEPTION");
        }
        buf.append("\n  max_retries      : " + this.max_retries);
        buf.append("\n  retry_interval   : " + this.retry_interval);
        buf.append("\n  retention_time   : " + this.retention_time);
        buf.append("\n  dep_tracking     : " + this.dep_tracking);
        buf.append("\n  comment          : " + this.comment);
        buf.append("\n  auto_commit      : " + this.auto_commit);
        buf.append("\n");
        return buf.toString();
    }
}

