/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;

public class Streamer {
    private static int s_timeout = 1200000;
    private static long[] IDX = new long[]{System.currentTimeMillis()};
    private static Map<String, StreamRecord> m_streams = Collections.synchronizedMap(new HashMap());

    public static String addInputStream(InputStream is) {
        return Streamer.addInputStream(is, 0);
    }

    public static String addInputStream(InputStream is, int timeout) {
        return Streamer._addStream(timeout, new StreamRecord(is));
    }

    public static String addOutputStream(OutputStream os, NotificationListener nh, Notification n, Object handback) {
        return Streamer.addOutputStream(os, nh, n, handback, 0);
    }

    public static String addOutputStream(OutputStream os, NotificationListener nh, Notification n, Object handback, int timeout) {
        return Streamer.addOutputStream(os, nh, n, handback, null, null, timeout);
    }

    public static String addOutputStream(OutputStream os, NotificationListener nh, Notification n, Object handback, Notification n_c, Object handback_c, int timeout) {
        return Streamer._addStream(timeout, new StreamRecord(os, nh, n, handback, n_c, handback_c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _addStream(int timeout, StreamRecord sr) {
        long[] lArray = IDX;
        synchronized (IDX) {
            long l = IDX[0];
            IDX[0] = l + 1L;
            String key = Long.toString(l, 36);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            sr.m_key = key;
            m_streams.put(key, sr);
            if (timeout == 0) {
                timeout = s_timeout;
            }
            if (timeout > 0) {
                sr.startNewThread(timeout);
            }
            return key;
        }
    }

    private static void _removeStream(String handle, StreamRecord sr, Object param, NotificationType notificationType) throws IOException {
        if (param != null) {
            throw new IllegalArgumentException("Expected param to be null for CLOSE_READ, CLOSE_WRITE and CANCEL_WRITE operation");
        }
        if (sr.m_is != null) {
            sr.m_is.close();
        }
        if (sr.m_os != null) {
            sr.m_os.close();
        }
        sr.stopTheThread();
        m_streams.remove(handle);
        if (sr.m_nh != null) {
            if (notificationType == NotificationType.CLOSE_NOTIFICATION && (sr.m_n != null || sr.m_handback != null)) {
                sr.m_nh.handleNotification(sr.m_n, sr.m_handback);
            } else if (notificationType == NotificationType.CANCEL_NOTIFICATION && (sr.m_n_c != null || sr.m_handback_c != null)) {
                sr.m_nh.handleNotification(sr.m_n_c, sr.m_handback_c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object handleOperation(String handle, int operation, Object param) throws IOException {
        Object result = null;
        StreamRecord sr = m_streams.get(handle);
        try {
            if (sr != null) {
                sr.enter();
            }
            if (sr == null || operation < 0 && sr.m_is == null || operation >= 0 && sr.m_os == null) {
                throw new IOException("Cannot perform operation on a closed stream");
            }
            if (operation == -1) {
                if (param == null || !(param instanceof Integer)) {
                    throw new IllegalArgumentException("Expected param to be an Integer for READ operation");
                }
                result = new byte[((Integer)param).intValue()];
                int r = sr.m_is.read((byte[])result);
                if (r < ((byte[])result).length) {
                    if (r < 0) {
                        result = null;
                    } else {
                        byte[] nb = new byte[r];
                        System.arraycopy(result, 0, nb, 0, r);
                        result = nb;
                    }
                }
            } else if (operation == 1) {
                if (param == null || !(param instanceof byte[])) {
                    throw new IllegalArgumentException("Expected param to be a byte[] for WRITE operation");
                }
                OutputStream os = sr.m_os;
                os.write((byte[])param);
            } else if (operation == -3) {
                if (param == null || !(param instanceof Long)) {
                    throw new IllegalArgumentException("Expected param to be a Long for SKIP_READ operation");
                }
                result = new Long(sr.m_is.skip((Long)param));
            } else if (operation == -2) {
                Streamer._removeStream(handle, sr, param, NotificationType.CLOSE_NOTIFICATION);
            } else if (operation == 2) {
                Streamer._removeStream(handle, sr, param, NotificationType.CLOSE_NOTIFICATION);
            } else if (operation == 3) {
                Streamer._removeStream(handle, sr, param, NotificationType.CANCEL_NOTIFICATION);
            } else {
                throw new UnsupportedOperationException("Unsupported streaming operation: " + operation);
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (sr != null) {
                sr.leave();
            }
        }
    }

    protected static class StreamRecord
    implements Runnable {
        public int[] m_mutex = new int[]{0};
        int m_timeout;
        public Thread m_killer;
        public InputStream m_is;
        public OutputStream m_os;
        public NotificationListener m_nh;
        public Notification m_n;
        public Object m_handback;
        public Notification m_n_c;
        public Object m_handback_c;
        public String m_key;
        boolean m_isForcedStop = false;

        public StreamRecord(InputStream is) {
            this.m_is = is;
        }

        public StreamRecord(OutputStream os, NotificationListener nh, Notification n, Object handback, Notification n_c, Object handback_c) {
            this.m_os = os;
            this.m_nh = nh;
            this.m_n = n;
            this.m_handback = handback;
            this.m_n_c = n_c;
            this.m_handback_c = handback_c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enter() {
            int[] nArray = this.m_mutex;
            synchronized (this.m_mutex) {
                if (this.m_killer != null) {
                    this.m_killer.interrupt();
                }
                this.m_mutex[0] = this.m_mutex[0] + 1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void leave() {
            int[] nArray = this.m_mutex;
            synchronized (this.m_mutex) {
                if (this.m_killer != null) {
                    this.m_killer.interrupt();
                }
                if (this.m_mutex[0] > 0) {
                    this.m_mutex[0] = this.m_mutex[0] - 1;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startNewThread(int timeout) {
            this.m_timeout = timeout;
            this.m_killer = new Thread((Runnable)this, "oracle.as.management.streaming.Streamer - stream shepherd <" + this.hashCode() + ">");
            int[] nArray = this.m_mutex;
            synchronized (this.m_mutex) {
                this.m_isForcedStop = false;
                this.m_killer.setDaemon(true);
                this.m_killer.start();
                try {
                    this.m_mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopTheThread() {
            if (this.m_killer == null) {
                return;
            }
            int[] nArray = this.m_mutex;
            synchronized (this.m_mutex) {
                this.m_isForcedStop = true;
                this.m_mutex.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int[] nArray = this.m_mutex;
            synchronized (this.m_mutex) {
                this.m_mutex.notifyAll();
                while (true) {
                    try {
                        if (this.m_timeout < 0 || this.m_mutex[0] != 0) {
                            this.m_mutex.wait();
                            break;
                        }
                        this.m_mutex.wait(this.m_timeout);
                    }
                    catch (InterruptedException ie) {
                        if (!this.m_isForcedStop) continue;
                    }
                    break;
                }
                this.m_killer = null;
                try {
                    if (this.m_isForcedStop) {
                        Streamer._removeStream(this.m_key, this, null, NotificationType.NO_NOTIFICATION);
                    } else {
                        Streamer._removeStream(this.m_key, this, null, NotificationType.CANCEL_NOTIFICATION);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    private static enum NotificationType {
        CLOSE_NOTIFICATION,
        CANCEL_NOTIFICATION,
        NO_NOTIFICATION;

    }
}

