/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.translation;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.ECParameter;
import oracle.dms.context.ExecutionContext;

public class NLSupport {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String m_defaultResourceLocation;
    private ClassLoader m_loader = null;
    static final Logger LOGGER = Logger.getLogger("oracle.dms.util", "oracle.dms.util.dms");

    private NLSupport(String defaultResourceLocation, ClassLoader loader) {
        if (defaultResourceLocation == null || defaultResourceLocation.length() == 0) {
            throw new IllegalArgumentException("defaultResourceLocation=" + defaultResourceLocation);
        }
        this.m_defaultResourceLocation = defaultResourceLocation;
        this.m_loader = loader;
    }

    public static NLSupport getNLSupport(String defaultResourceLocation, ClassLoader loader) {
        if (defaultResourceLocation == null || defaultResourceLocation.length() == 0) {
            throw new IllegalArgumentException("defaultResourceLocation=" + defaultResourceLocation);
        }
        return new NLSupport(defaultResourceLocation, loader);
    }

    public String getTranslation(String key, String resourceLocation, List tokens, Locale locale) throws MissingResourceException {
        Object[] arguments = tokens != null && tokens.size() > 0 ? tokens.toArray() : EMPTY_ARGS;
        return this.getTranslation(key, resourceLocation, arguments, locale);
    }

    public String getTranslation(String key, String resourceLocation, Object[] tokens, Locale locale) throws MissingResourceException {
        String translation;
        if (tokens == null) {
            tokens = EMPTY_ARGS;
        }
        if ((translation = this._getResource(key, resourceLocation, locale)) == null || translation.length() == 0) {
            return translation;
        }
        translation = MessageFormat.format(translation, tokens);
        return translation;
    }

    public String getTranslation(String key, String resourceLocation, Locale locale) throws MissingResourceException {
        return this.getTranslation(key, resourceLocation, (Object[])null, locale);
    }

    public String getTranslation(String key, String resourceLocation) throws MissingResourceException {
        return this.getTranslation(key, resourceLocation, NLSupport.getClientLocale());
    }

    public String getTranslation(String key, List tokens) throws MissingResourceException {
        return this.getTranslation(key, this.m_defaultResourceLocation, tokens, NLSupport.getClientLocale());
    }

    public String getTranslation(String key, Object[] tokens) throws MissingResourceException {
        return this.getTranslation(key, this.m_defaultResourceLocation, tokens, NLSupport.getClientLocale());
    }

    public String getTranslation(String key, List tokens, Locale locale) throws MissingResourceException {
        return this.getTranslation(key, this.m_defaultResourceLocation, tokens, locale);
    }

    public String getTranslation(String key, Object[] tokens, Locale locale) throws MissingResourceException {
        return this.getTranslation(key, this.m_defaultResourceLocation, tokens, locale);
    }

    public String getTranslation(String key) throws MissingResourceException {
        return this.getTranslation(key, this.m_defaultResourceLocation, NLSupport.getClientLocale());
    }

    public String getTranslation(String key, Locale locale) throws MissingResourceException {
        return this.getTranslation(key, this.m_defaultResourceLocation, locale);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NLSupport)) {
            return false;
        }
        NLSupport nls = (NLSupport)obj;
        return this.m_defaultResourceLocation.equals(nls.m_defaultResourceLocation) && this.m_loader == nls.m_loader;
    }

    public int hashCode() {
        return this.m_defaultResourceLocation.hashCode();
    }

    public static Locale getServerLocale() {
        String localeStr = ExecutionContext.get().getGlobalValue(ECParameter.mas_serverLocale.toString());
        return NLSupport.getLocale(localeStr);
    }

    public static Locale getClientLocale() {
        String localeStr = ExecutionContext.get().getGlobalValue(ECParameter.mas_clientLocale.toString());
        return NLSupport.getLocale(localeStr);
    }

    public static Locale getLocale(String localeStr) {
        if (localeStr == null || localeStr.equals("")) {
            return Locale.getDefault();
        }
        int firstSprtr = localeStr.indexOf(95);
        String lang = null;
        String country = null;
        String variant = null;
        if (firstSprtr < 0) {
            lang = localeStr;
        } else if (firstSprtr > 0) {
            lang = localeStr.substring(0, firstSprtr);
            int lastSprtr = localeStr.lastIndexOf(95);
            if (lastSprtr == firstSprtr) {
                country = localeStr.substring(lastSprtr + 1);
            } else {
                country = localeStr.substring(firstSprtr + 1, lastSprtr);
                variant = localeStr.substring(lastSprtr + 1);
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Cannot obtain the correct Locale from the given String: " + localeStr);
            }
            return Locale.getDefault();
        }
        if (variant != null) {
            return new Locale(lang, country, variant);
        }
        if (country != null) {
            return new Locale(lang, country);
        }
        return new Locale(lang);
    }

    private String _getResource(String key, String location, Locale locale) throws MissingResourceException {
        if (key == null || key.length() == 0) {
            return key;
        }
        ResourceBundle bundle = this._getResource(location, locale);
        if (bundle == null || !bundle.containsKey(key)) {
            return null;
        }
        return bundle.getString(key);
    }

    private ResourceBundle _getResource(String resourceLocation, Locale inLocale) throws MissingResourceException {
        if (inLocale == null) {
            inLocale = NLSupport.getClientLocale();
        }
        if (resourceLocation == null || resourceLocation.length() == 0) {
            resourceLocation = this.m_defaultResourceLocation;
        }
        if (this.m_loader == null) {
            return ResourceBundle.getBundle(resourceLocation, inLocale);
        }
        return ResourceBundle.getBundle(resourceLocation, inLocale, this.m_loader);
    }
}

