/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

public class ExecutionContextDump
extends ComponentDiagnosticDump {
    private static final String ECID_ARG = "ecid";
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();

    public ExecutionContextDump() {
        this.defineArgument(ECID_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_ECIDCTX_ECID_ARG");
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        DumpWriter dw = new DumpWriter(context);
        String ecid = context.getArguments().getString(ECID_ARG);
        if (ecid != null && ecid.length() > 0) {
            this.dumpExecutionContext(ecid, dw);
        } else {
            String[] ecids = DMSContextManager.getEcids();
            if (ecids != null) {
                for (String e : ecids) {
                    this.dumpExecutionContext(e, dw);
                }
            }
        }
        return dw.getDumpResult();
    }

    @Override
    public String getName() {
        return "ecidctx";
    }

    @Override
    public String getOwner() {
        return "dms";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.PERFORMANCE);
    }

    @Override
    public String getDumpDescription() {
        return this.getMsg("DFW_ECIDCTX_DESCRIPTION", null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_ECIDCTX_DESCRIPTION", locale);
    }

    @Override
    public DiagnosticDump.DumpRunMode getRunMode() {
        return DiagnosticDump.DumpRunMode.SYNCHRONOUS;
    }

    private void dumpExecutionContext(String ecid, DumpWriter dw) {
        Map<String, ExecutionContext> map = DMSContextManager.getContexts(ecid);
        if (map != null) {
            for (Map.Entry<String, ExecutionContext> entry : map.entrySet()) {
                dw.dumpln(entry.getValue().getPrettyInstanceStateSummary(Level.FINER));
                dw.dumpln();
            }
        }
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }
}

