/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.LogUtil;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.incident.IncidentFacts;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

public class UncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler,
DiagnosticsListener {
    private Thread.UncaughtExceptionHandler m_predecessor;
    private DiagnosticsDataExtractor m_dde;
    private boolean m_enable;
    public static final String DESC_PREFIX = ") exited due to an uncaught Exception: ";

    public UncaughtExceptionHandler(DiagnosticsDataExtractor dde) {
        this.m_dde = dde;
        this.m_enable = false;
        DiagnosticsEventManager.registerListener(this);
    }

    private static String buildDescription(Throwable uncaughtException, Thread threadDetails) {
        return "Thread " + threadDetails.getId() + "(" + threadDetails.getName() + DESC_PREFIX + uncaughtException.toString() + ".";
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Logger logger;
        block6: {
            logger = LoggerFactory.getFrameworkLogger();
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Detected uncaught exception.", e);
                }
                String message = UncaughtExceptionHandler.buildDescription(e, t);
                String compId = this.identifyComponentFrom(e);
                String moduleId = e.getClass().getName();
                IncidentFacts facts = IncidentFacts.createUnhandledExceptionIncidentFacts(0L, null, compId, moduleId, false, e);
                facts.setDescription(message);
                ExecutionContext ctx = DMSContextManager.getContext(t.getId());
                if (ctx != null) {
                    facts.setExecutionContextId(ctx.getECID());
                }
                this.m_dde.createIncident(facts, false);
            }
            catch (Throwable th) {
                if (!logger.isLoggable(Level.FINE)) break block6;
                logger.log(Level.FINE, "Unable to create a uncaught exception incident. ", th);
            }
        }
        if (this.m_predecessor != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Invoke predessor uncaught exception handler: " + this.m_predecessor);
            }
            this.m_predecessor.uncaughtException(t, e);
        }
    }

    private String identifyComponentFrom(Throwable uncaughtExp) {
        String componentClassname = "Unknown";
        try {
            StackTraceElement[] frames = uncaughtExp.getStackTrace();
            for (int i = 0; i < frames.length; ++i) {
                String classname = frames[i].getClassName();
                if (classname.startsWith("java.") || classname.startsWith("sun.") || classname.startsWith("javax.") || classname.startsWith("com.sun.")) continue;
                componentClassname = classname;
                break;
            }
        }
        catch (Throwable th) {
            componentClassname = "Unknown";
        }
        return componentClassname;
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    public void setEnable(boolean enableDetection) {
        try {
            if (enableDetection) {
                if (this.m_enable) {
                    return;
                }
                Thread.UncaughtExceptionHandler predecessor = Thread.getDefaultUncaughtExceptionHandler();
                if (this != predecessor) {
                    UncaughtExceptionHandler.setDefaultUncaughtExceptionHandler(this);
                    this.m_predecessor = predecessor;
                    this.m_enable = true;
                }
            } else {
                if (!this.m_enable) {
                    return;
                }
                UncaughtExceptionHandler.setDefaultUncaughtExceptionHandler(this.m_predecessor);
                this.m_predecessor = null;
                this.m_enable = false;
            }
        }
        catch (Exception ex) {
            LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40208", null, (Throwable)ex);
        }
    }

    private static void setDefaultUncaughtExceptionHandler(final Thread.UncaughtExceptionHandler handler) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.setDefaultUncaughtExceptionHandler(handler);
                return null;
            }
        });
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof DiagnosticsConfigurationChangedEvent) {
            DiagnosticsConfiguration config = ((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration();
            try {
                if (config != null) {
                    boolean enableDetection = config.isUncaughtExceptionDetectionEnabled();
                    this.setEnable(enableDetection);
                }
            }
            catch (Exception ex) {
                LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40208", null, (Throwable)ex);
            }
        }
    }
}

