/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.jmx;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.management.DynamicMBean;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import oracle.as.jmx.framework.PortableMBeanFactory;
import oracle.as.management.streaming.Streamer;
import oracle.as.management.streaming.StreamingMBean;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.impl.jmx.InternalUtilMXBean;
import oracle.dfw.impl.jmx.JMXDumpManager;
import oracle.dfw.impl.jmx.JMXIncidentManager;
import oracle.dfw.impl.jmx.JMXInternalUtil;
import oracle.dfw.impl.jmx.StreamIntf;
import oracle.dfw.jmx.DumpManagerMXBean;
import oracle.dfw.jmx.IncidentManagerMXBean;

public class Streaming
extends StandardMBean
implements StreamIntf,
DynamicMBean,
MBeanRegistration {
    private static Hashtable<String, RemoteInfo> m_remoteHandles;
    private Object m_lock = new Object();
    private long m_lastClean = System.currentTimeMillis();
    private static long CLEANUP_INTERVAL;
    private static final String DUMP_MANAGER_ON = "oracle.dfw:type=oracle.dfw.jmx.DumpManagerMXBean,name=DumpManager";
    private static final String INCIDENT_MANAGER_ON = "oracle.dfw:type=oracle.dfw.jmx.IncidentManagerMXBean,name=IncidentManager";
    private static final String INTERNAL_UTIL_ON = "oracle.dfw:type=oracle.dfw.impl.jmx.InternalUtilMXBean,name=InternalUtil";

    public Streaming() throws Exception {
        super(StreamingMBean.class);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name != null && name.getKeyProperty("name").equals("Streamer")) {
            try {
                PortableMBeanFactory portableMBeanFactory = new PortableMBeanFactory();
                MBeanServer ps = portableMBeanFactory.getMBeanServer();
                DiagnosticsFramework df = new DiagnosticsFramework();
                JMXDumpManager dm = new JMXDumpManager(df.getDumpManager(), df.getIncidentManager());
                Object dbean = portableMBeanFactory.createMBean((Object)dm, DumpManagerMXBean.class);
                ps.registerMBean(dbean, new ObjectName(DUMP_MANAGER_ON));
                if (df.getIncidentManager() != null) {
                    ADRInfo defaultADR = ADRInfo.getADRInfo(df.getADRBase(), df.getProductType(), df.getProductId(), df.getInstanceId());
                    JMXIncidentManager im = new JMXIncidentManager(df.getIncidentManager(), df.getDDE(), df.getOracleHome(), defaultADR);
                    Object ibean = portableMBeanFactory.createMBean((Object)im, IncidentManagerMXBean.class);
                    ps.registerMBean(ibean, new ObjectName(INCIDENT_MANAGER_ON));
                }
                Object iubean = portableMBeanFactory.createMBean((Object)new JMXInternalUtil(df.getDDE()), InternalUtilMXBean.class);
                ps.registerMBean(iubean, new ObjectName(INTERNAL_UTIL_ON));
            }
            catch (Exception e) {
                LoggerFactory.getFrameworkLogger().log(Level.WARNING, "failure registering diagnostic framework runtime mbeans", e);
            }
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    public static void addRemoteHandle(String handle, StreamingMBean remoteStreamer) {
        if (handle == null || remoteStreamer == null) {
            throw new IllegalArgumentException("Invalid arguments to addRemoteHandle. handle=" + handle + "remoteStreamer=" + remoteStreamer);
        }
        if (m_remoteHandles == null) {
            m_remoteHandles = new Hashtable();
        }
        m_remoteHandles.put(handle, new RemoteInfo(handle, remoteStreamer));
    }

    @Override
    public Object streamingOperation(String handle, int operation, Object param) throws IOException {
        Object ret = null;
        if (m_remoteHandles != null && m_remoteHandles.containsKey(handle)) {
            RemoteInfo remoteInfo = m_remoteHandles.get(handle);
            if (remoteInfo != null && remoteInfo.m_streamer != null) {
                ret = remoteInfo.m_streamer.streamingOperation(handle, operation, param);
                if (operation == 2 || operation == 3 || operation == -2) {
                    m_remoteHandles.remove(handle);
                }
            }
            this.cleanupRemoteHandles();
        } else {
            ret = Streamer.handleOperation(handle, operation, param);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupRemoteHandles() {
        Object object = this.m_lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - this.m_lastClean > CLEANUP_INTERVAL) {
                Enumeration<RemoteInfo> handles = m_remoteHandles.elements();
                while (handles.hasMoreElements()) {
                    RemoteInfo info = handles.nextElement();
                    if (now - info.m_timestamp <= CLEANUP_INTERVAL) continue;
                    m_remoteHandles.remove(info.m_handle);
                }
                this.m_lastClean = now;
            }
        }
    }

    static {
        CLEANUP_INTERVAL = 900000L;
    }

    private static class RemoteInfo {
        String m_handle;
        StreamingMBean m_streamer;
        long m_timestamp;

        RemoteInfo(String handle, StreamingMBean streamer) {
            this.m_handle = handle;
            this.m_streamer = streamer;
            this.m_timestamp = System.currentTimeMillis();
        }
    }
}

