/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.ContextComponentsFactory;
import oracle.dms.context.ContextParameterFactory;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.ExecutionContextStub;
import oracle.dms.context.RID;
import oracle.dms.context.WrappedContextDecoder;
import oracle.dms.context.internal.AbstractContextManager;
import oracle.dms.context.internal.ActivationException;
import oracle.dms.context.internal.ContextComponentsFactoryImpl;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.context.internal.jse.JSEContextManager;
import oracle.dms.context.internal.was.WASContextManager;
import oracle.dms.context.internal.wls.WLSContextManager;
import oracle.dms.ext.soa.SOADMSCtxParamDescriptors;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;

public class DMSContextManager {
    public static final int MAX_STASH_MINUTES = 1440;
    public static final int MAX_SUSPEND_MINUTES = 1440;
    @Deprecated
    public static final String URI = "URI";
    @Deprecated
    public static final String SPC = "wlmPC";
    @Deprecated
    public static final String WRC = "wlmWRC";
    @Deprecated
    public static final String SQLTRACE = "sqltrace";
    @Deprecated
    public static final String TRACE = "dmsTrace";
    @Deprecated
    public static final String ACTION = "Action";
    @Deprecated
    public static final String MODULE = "Module";
    @Deprecated
    public static final String CLIENTID = "client_identifier";
    @Deprecated
    public static final String WLS_DIAG_CTX_ID = "dcid";
    @Deprecated
    public static final int DEFAULT_MIN_LIFE = 0;
    @Deprecated
    public static final int MIN_LIFE = 0;
    @Deprecated
    public static final int MAX_LIFE = 900;
    public static final long CLEANER_SLEEP_SECONDS = 300L;
    public static final int LOG = 1;
    @Deprecated
    public static final int PROPAGATE = 2;
    @Deprecated
    public static final int LIMIT = 3;
    public static final String LOGGER_NAME = "oracle.dms.context";
    private static Logger s_logger = Logger.getLogger("oracle.dms.context", "oracle.dms.context.ContextResourceBundle");
    private static Object s_initLock = new Object();
    private static boolean s_initialized = false;
    private static boolean s_lazyInitializationPermitted = true;
    private static boolean sPostInitPerformed = false;
    private static DomainContextManager sDomainContextManager = null;
    private static ContextComponentsFactory sContextComponentsFactory = new ContextComponentsFactoryImpl();

    private DMSContextManager() {
    }

    @Deprecated
    public static boolean init(String[] params, int maxBytes, int minLife) {
        if (s_initialized) {
            return false;
        }
        InitOptions options = InitOptions.create(true);
        DMSContextManager.init(options);
        DMSContextManager.setMinLife(minLife);
        return true;
    }

    @Deprecated
    public static boolean init(String[] params, int maxBytes) {
        InitOptions options = InitOptions.create(true);
        return DMSContextManager.init(options);
    }

    public static boolean init() {
        InitOptions options = InitOptions.create(true);
        return DMSContextManager.init(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean init(InitOptions options) {
        boolean retVal = false;
        Object object = s_initLock;
        synchronized (object) {
            if (s_initialized) {
                return false;
            }
            if (options.isExplicitInitialization() || s_lazyInitializationPermitted) {
                boolean isEnabled = DMSContextManager.determineIfEnabled();
                if (isEnabled) {
                    DomainContextManager dcm = DMSContextManager.selectAppropriateContextManager();
                    if (dcm == null) {
                        isEnabled = false;
                    } else {
                        dcm.initNoLogging();
                    }
                    sDomainContextManager = dcm;
                }
                s_initialized = true;
                retVal = true;
            }
        }
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.log(Level.FINE, "DMSContextManager is being initialized at {0}\n{1}", new String[]{Long.toString(System.currentTimeMillis()), ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
        if (sDomainContextManager != null) {
            object = sDomainContextManager;
            synchronized (object) {
                if (!sPostInitPerformed) {
                    sDomainContextManager.postInit();
                    sPostInitPerformed = true;
                }
            }
        }
        if (sDomainContextManager != null) {
            SOADMSCtxParamDescriptors.init();
        }
        return retVal;
    }

    public static ExecutionContext getContext() {
        return DMSContextManager.getContext(true);
    }

    static ExecutionContext getContext(boolean inheritable) {
        if (!s_initialized) {
            DMSContextManager.init(InitOptions.create(false));
        }
        ExecutionContext retVal = null;
        if (sDomainContextManager == null) {
            retVal = ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.DISABLED);
        } else {
            if (sDomainContextManager != null) {
                try {
                    Object dctx = sDomainContextManager.getContext(inheritable);
                    retVal = dctx == null ? null : dctx.getAsMutableExecutionContext();
                }
                catch (ActivationException e) {
                    s_logger.log(Level.WARNING, "DMS-57014", e);
                    retVal = ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.UNAVAILABLE_DUE_TO_ERROR);
                }
            }
            if (retVal == null) {
                retVal = ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.UNKNOWN);
            }
        }
        return retVal;
    }

    public static ExecutionContext getContext(long threadId) {
        Object dctx;
        ExecutionContext retVal = null;
        if (sDomainContextManager != null && (dctx = sDomainContextManager.getContext(threadId)) != null) {
            retVal = dctx.getAsImmutableExecutionContext();
        }
        return retVal;
    }

    @Deprecated
    public static ExecutionContext getContext(String ecid, RID rid) {
        Object dctx;
        ExecutionContext retVal = null;
        if (ecid != null && rid != null && sDomainContextManager != null && (dctx = sDomainContextManager.findContext(ecid, rid)) != null) {
            retVal = dctx.getAsImmutableExecutionContext();
        }
        return retVal;
    }

    public static ExecutionContext getContext(String ecid, String ridStr) {
        Object dctx;
        ExecutionContext retVal = null;
        if (ecid != null && ridStr != null && sDomainContextManager != null && (dctx = sDomainContextManager.findContext(ecid, ridStr)) != null) {
            retVal = dctx.getAsImmutableExecutionContext();
        }
        return retVal;
    }

    static void stash(Object key) {
        if (sDomainContextManager != null) {
            try {
                sDomainContextManager.stashNewChild(key);
            }
            catch (ActivationException e) {
                s_logger.log(Level.WARNING, "DMS-57014", e);
            }
        }
    }

    static boolean removeStashedContext(Object key) {
        Object ctx;
        boolean retVal = false;
        if (sDomainContextManager != null && (ctx = sDomainContextManager.removeStashedContext(key)) != null) {
            retVal = true;
        }
        return retVal;
    }

    static ExecutionContext activateStashedContext(Object key) {
        ExecutionContext retVal = null;
        try {
            if (sDomainContextManager != null) {
                Object dctx = sDomainContextManager.activateStashedContext(key);
                if (dctx == null) {
                    dctx = sDomainContextManager.getContext(true);
                    if (dctx != null) {
                        retVal = dctx.getAsMutableExecutionContext();
                    }
                } else {
                    retVal = dctx.getAsMutableExecutionContext();
                }
            } else {
                retVal = ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.DISABLED);
            }
        }
        catch (ActivationException e) {
            s_logger.log(Level.WARNING, "DMS-57014", e);
            retVal = ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.UNAVAILABLE_DUE_TO_ERROR);
        }
        if (retVal == null) {
            retVal = ExecutionContextStub.getTheStub(ExecutionContextStub.StubType.UNKNOWN);
        }
        return retVal;
    }

    static boolean resumeSuspendedContext(Object key) {
        if (sDomainContextManager != null) {
            try {
                return sDomainContextManager.resumeSuspendedContext(key);
            }
            catch (ActivationException e) {
                s_logger.log(Level.WARNING, "DMS-57014", e);
            }
        }
        return false;
    }

    @Deprecated
    public static int getNewKidCount(String ecid) {
        return 0;
    }

    @Deprecated
    public static Map<String, ExecutionContext> getContexts(String ecid) {
        HashMap<String, ExecutionContext> retVal = null;
        if (ecid != null && sDomainContextManager != null) {
            Map m1 = sDomainContextManager.getContexts(ecid);
            retVal = new HashMap<String, ExecutionContext>();
            for (Map.Entry entry : m1.entrySet()) {
                if (entry.getValue() == null) continue;
                retVal.put(entry.getKey(), ((DomainExecutionContext)entry.getValue()).getAsImmutableExecutionContext());
            }
        }
        return retVal;
    }

    public static String[] getEcids() {
        if (sDomainContextManager != null) {
            return sDomainContextManager.getEcids();
        }
        return null;
    }

    @Deprecated
    public static boolean logContext(String ecid, long rid) {
        return !DMSContextManager.isInitialized();
    }

    @Deprecated
    public static boolean logContext(String ecid, String ridStr) {
        return !DMSContextManager.isInitialized();
    }

    public static int getLogLevelCount() {
        if (sDomainContextManager != null) {
            return sDomainContextManager.getLogLevelCount();
        }
        return 0;
    }

    public static boolean hasContext() {
        if (sDomainContextManager != null) {
            return sDomainContextManager.hasContext();
        }
        return false;
    }

    public static ExecutionContext createContext() {
        ExecutionContext retVal = null;
        if (sDomainContextManager != null) {
            Object ctx = sDomainContextManager.newFamily(WrapUtils.createECID(), new RID());
            retVal = ctx.getAsMutableExecutionContext();
        }
        return retVal;
    }

    public static ExecutionContext getActiveContext() {
        if (sDomainContextManager != null) {
            Object dctx = sDomainContextManager.getActiveContext();
            return dctx == null ? null : dctx.getAsMutableExecutionContext();
        }
        return null;
    }

    public static int getActiveCount(String ecid) {
        int retVal = 0;
        if (ecid != null && sDomainContextManager != null) {
            retVal = sDomainContextManager.getActiveCount(ecid);
        }
        return retVal;
    }

    @Deprecated
    public static int getContextCount(String ecid) {
        int retVal = 0;
        if (sDomainContextManager != null && ecid != null) {
            retVal = sDomainContextManager.getContextCount(ecid);
        }
        return retVal;
    }

    @Deprecated
    public static int getMinLife() {
        return 0;
    }

    @Deprecated
    public static int setMinLife(int seconds) {
        return 0;
    }

    public static void setMaxStashMinutes(int minutes) {
        if (sDomainContextManager != null) {
            sDomainContextManager.setMaxStashMinutes(minutes);
        }
    }

    static void setMaxStashSeconds(int seconds) {
        if (sDomainContextManager != null) {
            sDomainContextManager.setMaxStashSeconds(seconds);
        }
    }

    public static void setMaxSuspendMinutes(int minutes) {
        if (sDomainContextManager != null) {
            sDomainContextManager.setMaxSuspendMinutes(minutes);
        }
    }

    static void setMaxSuspendSeconds(int seconds) {
        if (sDomainContextManager != null) {
            sDomainContextManager.setMaxSuspendSeconds(seconds);
        }
    }

    public static long getMaxStashMillis() {
        if (sDomainContextManager != null) {
            return sDomainContextManager.getMaxStashMillis();
        }
        return -1L;
    }

    public static long getMaxSuspendMillis() {
        if (sDomainContextManager != null) {
            return sDomainContextManager.getMaxSuspendMillis();
        }
        return -1L;
    }

    public static void setCleanerSleepSecs(long seconds) {
        if (!s_initialized) {
            DMSContextManager.init(InitOptions.create(false));
        }
        if (sDomainContextManager != null) {
            sDomainContextManager.setCleanerSleepSecs(seconds);
        }
    }

    public static long getCleanerSleepMillis() {
        if (sDomainContextManager != null) {
            return sDomainContextManager.getCleanerSleepMillis();
        }
        return -1L;
    }

    public static Object getValue(String ecid, RID rid, String key) {
        Object retVal = null;
        if (ecid != null && rid != null && key != null && sDomainContextManager != null) {
            retVal = sDomainContextManager.getValue(ecid, rid, key);
        }
        return retVal;
    }

    public static Object getValue(String ecid, String ridStr, String key) {
        if (sDomainContextManager != null) {
            return sDomainContextManager.getValue(ecid, ridStr, key);
        }
        return null;
    }

    @Deprecated
    public static Object getValue(String ecid, long rid, String key) {
        return null;
    }

    public static int getMaxBytes() {
        if (sDomainContextManager != null) {
            return sDomainContextManager.getMaxBytes();
        }
        return 0;
    }

    public static boolean isInitialized() {
        return s_initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void shutdown(ShutdownOptions options) {
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.log(Level.FINE, "DMSContextManager is being shutdown at {0}\n{1}", new String[]{Long.toString(System.currentTimeMillis()), ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
        Object object = s_initLock;
        synchronized (object) {
            if (!s_initialized) {
                return;
            }
            ExecutionContext.deactivateContext();
            if (sDomainContextManager != null) {
                sDomainContextManager.shutdown();
            }
            sDomainContextManager = null;
            s_initialized = false;
            sPostInitPerformed = false;
            s_lazyInitializationPermitted = true;
            if (options != null) {
                s_lazyInitializationPermitted = options.getAllowLazyReinitialization();
            }
        }
    }

    public static void shutdown() {
        DMSContextManager.shutdown(ShutdownOptions.getDefaultOptions());
    }

    public static void setKeyAttribute(String key, int attribute) {
        ContextParameterDescriptorInternal desc;
        if (key != null && sDomainContextManager != null && (desc = sDomainContextManager.findContextParameterDescriptor(key)) == null) {
            if (attribute == 1) {
                sDomainContextManager.setParameterAttribute(key, DomainContextManager.ParameterAttribute.LOGGABLE);
            } else if (attribute == 2) {
                sDomainContextManager.setParameterAttribute(key, DomainContextManager.ParameterAttribute.PROPAGATED_VIA_WRAP);
                sDomainContextManager.setParameterAttribute(key, DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
            } else if (attribute == 3) {
                sDomainContextManager.setParameterAttribute(key, DomainContextManager.ParameterAttribute.INCLUDED_IN_LIMITED_WRAP);
            }
        }
    }

    public static boolean isEnabled() {
        return sDomainContextManager != null;
    }

    public static Logger getLogger() {
        return s_logger;
    }

    static boolean unwrap(String wrap, boolean createUniqueChild) {
        if (!s_initialized) {
            DMSContextManager.init(InitOptions.create(false));
        }
        if (sDomainContextManager != null) {
            sDomainContextManager.deactivateContext();
            WrapUtils.UnwrapResult ur = WrapUtils.unwrap(sDomainContextManager, wrap, createUniqueChild, true, true, false, Level.WARNING);
            return ur.getUnwrapSuccess();
        }
        return true;
    }

    static DomainExecutionContext getDomainExecutionContext() throws ActivationException {
        DomainExecutionContext dctx = null;
        if (sDomainContextManager == null && !s_initialized) {
            DMSContextManager.init(InitOptions.create(false));
        }
        if (sDomainContextManager != null) {
            dctx = (DomainExecutionContext)sDomainContextManager.getContext();
        }
        return dctx;
    }

    private static DomainContextManager selectAppropriateContextManager() {
        AbstractContextManager retVal = null;
        PlatformSupport platformSupport = PlatformSupportFactory.getPlatformSupport();
        Platform platform = platformSupport.getPlatform();
        s_logger.log(Level.FINE, "Platform reported to DMSContextManager.selectAppropriateContextManager is " + (Object)((Object)platform));
        try {
            switch (platform) {
                case Default: {
                    retVal = new JSEContextManager();
                    break;
                }
                case WebLogic: 
                case WebLogicAS: {
                    retVal = new WLSContextManager();
                    break;
                }
                case WebSphere: 
                case WebSphereAS: 
                case WebSphereND: {
                    retVal = new WASContextManager();
                    break;
                }
                default: {
                    s_logger.log(Level.SEVERE, "DMS-57010");
                    retVal = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, "DMS-57009", e);
            retVal = null;
        }
        return retVal;
    }

    @Deprecated
    public static DomainContextManager getDomainContextManager() {
        if (!s_initialized) {
            DMSContextManager.init(InitOptions.create(false));
        }
        return sDomainContextManager;
    }

    private static boolean determineIfEnabled() {
        boolean retVal = true;
        String oldOffPropVal = DMSProperties.getProperty("oracle.dms.context.dumbasastump");
        String onPropValue = DMSProperties.getProperty(LOGGER_NAME);
        if (onPropValue != null) {
            if ("OFF".equalsIgnoreCase(onPropValue)) {
                retVal = false;
            }
        } else if (oldOffPropVal != null && "true".equalsIgnoreCase(oldOffPropVal)) {
            retVal = false;
        }
        return retVal;
    }

    public static WrappedContextDecoder getWrappedContextDecoder(String wrappedContext) {
        return new WrapUtils.WrapStringDecoderImpl(wrappedContext);
    }

    public static ContextComponentsFactory getContextComponentsFactory() {
        return sContextComponentsFactory;
    }

    public static ContextParameterFactory getContextParameterFactory() {
        ContextParameterFactory retVal = null;
        if (sDomainContextManager != null) {
            retVal = sDomainContextManager.getContextParameterFactory();
        }
        return retVal;
    }

    @Deprecated
    public static class InitOptions {
        boolean mExplicitInitialization;

        private InitOptions() {
        }

        public static InitOptions create(boolean explicitInitialization) {
            InitOptions retVal = new InitOptions();
            retVal.mExplicitInitialization = explicitInitialization;
            return retVal;
        }

        private boolean isExplicitInitialization() {
            return this.mExplicitInitialization;
        }
    }

    @Deprecated
    public static class ShutdownOptions {
        boolean mAllowLazyReinitialization = true;

        private ShutdownOptions() {
        }

        public static ShutdownOptions create(boolean allowReinitialization) {
            ShutdownOptions retVal = new ShutdownOptions();
            retVal.mAllowLazyReinitialization = allowReinitialization;
            return retVal;
        }

        public static ShutdownOptions getDefaultOptions() {
            ShutdownOptions retVal = ShutdownOptions.create(true);
            return retVal;
        }

        private boolean getAllowLazyReinitialization() {
            return this.mAllowLazyReinitialization;
        }
    }
}

