/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.ActivationException;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.ParameterValueListener;

public class ECForJDBC
implements ParameterValueListener {
    public static final String E2E_CONTEXT = "E2E_CONTEXT";
    public static final String CLIENT_CONTEXT = "CLIENTIDCONTEXT";
    private IdentityHashMap<String, Map<String, String>> m_jdbcMap = null;
    private IdentityHashMap<String, String> m_e2eMap = null;
    private DomainExecutionContext m_ctx = null;
    private HashSet<String> m_changedKeys = new HashSet();
    private ReentrantLock m_changedKeysLock = new ReentrantLock();
    private static Logger s_logger = DMSContextManager.getLogger();
    public static final String SPC = "wlmPC";
    public static final String WRC = "wlmWRC";
    public static final String URI = "URI";
    public static final String SQLTRACE = "sqltrace";
    public static final String TRACE = "dmsTrace";
    public static final String ACTION = "Action";
    public static final String MODULE = "Module";
    public static final String CLIENTID = "client_identifier";
    public static final String ECID = "ECID_UID";
    public static final String DB_RID = "dbRID";
    private IdentityHashMap<String, String> m_map = new IdentityHashMap();
    private boolean m_first = true;
    @Deprecated
    private static HashSet<String> s_e2eKey = new HashSet();

    private ECForJDBC() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parameterValueTouched(ExecutionContext ctx, String key, String value) {
        s_logger.log(Level.FINEST, "The key {0} has been touched to signal that its value should be transmitted in the next transmission.", key);
        this.m_changedKeysLock.lock();
        try {
            this.m_changedKeys.add(key.intern());
        }
        finally {
            this.m_changedKeysLock.unlock();
        }
    }

    public ECForJDBC(DomainExecutionContext dctx) {
        this.m_ctx = dctx;
    }

    private static ECForJDBC get() {
        DomainExecutionContext dctx = null;
        try {
            dctx = DMSContextManager.getDomainExecutionContext();
        }
        catch (ActivationException e) {
            DMSContextManager.getLogger().log(Level.WARNING, "DMS-57014", e);
        }
        if (dctx == null) {
            return null;
        }
        return dctx.getECForJDBC();
    }

    public static boolean updateSqlText() {
        DomainExecutionContext dctx = null;
        try {
            dctx = DMSContextManager.getDomainExecutionContext();
        }
        catch (ActivationException e) {
            DMSContextManager.getLogger().log(Level.WARNING, "DMS-57014", e);
        }
        if (dctx == null) {
            return false;
        }
        return dctx.isUpdateSqlText();
    }

    private String getRID() {
        if (this.m_ctx == null) {
            return null;
        }
        String rid = this.m_ctx.getRID().createChildRID().toString();
        this.m_ctx.setLocalValue(DB_RID, rid);
        return rid;
    }

    public static void finished() {
        DomainExecutionContext dctx = null;
        ECForJDBC jctx = null;
        try {
            dctx = DMSContextManager.getDomainExecutionContext();
            if (dctx != null) {
                jctx = dctx.getECForJDBC();
            }
        }
        catch (ActivationException e) {
            DMSContextManager.getLogger().log(Level.WARNING, "DMS-57014", e);
        }
        if (dctx == null || jctx == null) {
            return;
        }
        dctx.setLocalValue(DB_RID, null);
    }

    public static Map<String, Map<String, String>> getMap() {
        ECForJDBC jctx = ECForJDBC.get();
        if (jctx == null) {
            return Collections.EMPTY_MAP;
        }
        return jctx.getJdbcMap();
    }

    private Map<String, Map<String, String>> getJdbcMap() {
        if (this.m_jdbcMap == null) {
            this.initJdbcAndE2eMaps();
        }
        this.refreshE2eMap();
        return this.m_jdbcMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshE2eMap() {
        this.m_e2eMap.put(DB_RID, this.getRID());
        Set<String> propKeys = this.m_ctx.getParameterNames(DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
        this.m_changedKeysLock.lock();
        try {
            for (String key : this.m_changedKeys) {
                if (!propKeys.contains(key)) continue;
                String value = this.m_ctx.getLocalOrGlobalValue(key);
                if (value != null) {
                    this.m_e2eMap.put(key, value);
                    continue;
                }
                this.m_e2eMap.remove(key);
            }
            this.m_changedKeys.clear();
        }
        finally {
            this.m_changedKeysLock.unlock();
        }
    }

    private void initJdbcAndE2eMaps() {
        this.m_jdbcMap = new IdentityHashMap();
        this.m_e2eMap = new IdentityHashMap();
        this.m_e2eMap.put(ECID, this.m_ctx.getECID());
        Set<String> propKeys = this.m_ctx.getParameterNames(DomainContextManager.ParameterAttribute.PROPAGATED_TO_DB);
        if (propKeys != null) {
            for (String key : propKeys) {
                String value = this.m_ctx.getLocalOrGlobalValue(key);
                if (value == null) continue;
                this.m_e2eMap.put(key, value.intern());
            }
        }
        this.m_jdbcMap.put(E2E_CONTEXT, this.m_e2eMap);
    }

    public static String getAsString() {
        ECForJDBC jctx = ECForJDBC.get();
        return jctx.toString();
    }

    public String toString() {
        if (this.m_jdbcMap == null) {
            return "";
        }
        String retVal = new String();
        for (String mapkey : this.m_jdbcMap.keySet()) {
            retVal = retVal + mapkey;
            retVal = retVal + ": ";
            Map<String, String> map = this.m_jdbcMap.get(mapkey);
            if (map != null) {
                for (String key : map.keySet()) {
                    String value = map.get(key);
                    if (value == null) continue;
                    String add = new String(key + "," + value + "~");
                    retVal = retVal + add;
                }
            }
            retVal = retVal + "\n";
        }
        return retVal;
    }

    @Deprecated
    public static IdentityHashMap getContextMap() {
        ECForJDBC jctx = ECForJDBC.get();
        if (jctx == null) {
            return null;
        }
        return jctx.getDiffMap();
    }

    @Deprecated
    private IdentityHashMap getDiffMap() {
        if (this.m_first) {
            this.m_map.put("ECID", this.m_ctx.getECID());
        } else {
            this.m_map.clear();
        }
        this.m_map.put(DB_RID, this.getRID());
        HashSet<String> keySet = this.getKeys();
        for (String key : keySet) {
            String value = this.m_ctx.getLocalOrGlobalValue(key);
            this.m_map.put(key, value);
        }
        keySet.clear();
        this.m_first = false;
        return this.m_map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private HashSet<String> getKeys() {
        if (this.m_first) {
            for (String key : s_e2eKey) {
                if (this.m_ctx.getLocalOrGlobalValue(key) == null) continue;
                HashSet<String> hashSet = this.m_changedKeys;
                synchronized (hashSet) {
                    this.m_changedKeys.add(key);
                }
            }
        }
        return this.m_changedKeys;
    }

    static {
        s_e2eKey.add(URI);
        s_e2eKey.add(SPC);
        s_e2eKey.add(WRC);
        s_e2eKey.add(SQLTRACE);
        s_e2eKey.add(TRACE);
        s_e2eKey.add(ACTION);
        s_e2eKey.add(MODULE);
        s_e2eKey.add(CLIENTID);
    }
}

