/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.LongSummaryStatistics;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Logger;
import oracle.jdbc.AccessToken;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.JsonWebToken;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.nt.Clock;
import oracle.net.nt.TimeoutInterruptHandler;

public final class JsonWebTokenCache
implements Supplier<JsonWebToken> {
    private static final long EXPIRATION_THRESHOLD = 30000L;
    private static final long UPDATE_THRESHOLD = 60000L;
    private final Supplier<JsonWebToken> tokenSupplier;
    private final Executor executor;
    private final LongSummaryStatistics latency = new LongSummaryStatistics();
    private final AtomicInteger getCount = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition updateCondition = this.lock.newCondition();
    private boolean isUpdating = false;
    private JsonWebToken token = null;
    private RuntimeException failure;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public static JsonWebTokenCache create(Supplier<? extends AccessToken> supplier) {
        try {
            return new JsonWebTokenCache(OracleDriver.getExecutorService(), () -> JsonWebTokenCache.requireJsonWebToken((AccessToken)supplier.get()));
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException);
        }
    }

    private JsonWebTokenCache(Executor executor, @Blind Supplier<JsonWebToken> supplier) {
        this.executor = executor;
        this.tokenSupplier = supplier;
    }

    @Override
    @Blind
    public JsonWebToken get() {
        this.getCount.incrementAndGet();
        JsonWebToken jsonWebToken = this.token;
        if (jsonWebToken != null && !JsonWebTokenCache.isExpiring(jsonWebToken)) {
            return jsonWebToken;
        }
        this.lock.lock();
        try {
            while (jsonWebToken == this.token && this.failure == null) {
                if (!this.isUpdating) {
                    this.isUpdating = true;
                    this.requestUpdate();
                }
                this.updateCondition.await();
            }
            if (this.failure != null) {
                RuntimeException runtimeException = this.failure;
                this.failure = null;
                throw runtimeException;
            }
            JsonWebToken jsonWebToken2 = this.token;
            return jsonWebToken2;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void requestUpdate() {
        this.executor.execute(() -> {
            try {
                long l2 = System.nanoTime();
                JsonWebToken jsonWebToken = this.tokenSupplier.get();
                this.latency.accept(System.nanoTime() - l2);
                this.update(jsonWebToken, null);
            }
            catch (RuntimeException runtimeException) {
                this.update(null, runtimeException);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@Blind JsonWebToken jsonWebToken, RuntimeException runtimeException) {
        boolean bl = this.getCount.getAndSet(0) != 0 && runtimeException == null;
        this.lock.lock();
        try {
            this.token = jsonWebToken;
            this.failure = runtimeException;
            this.isUpdating = bl;
            this.updateCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            this.scheduleUpdate(TimeUnit.SECONDS.toMillis(jsonWebToken.exp()));
        }
    }

    private void scheduleUpdate(long l2) {
        long l3 = TimeUnit.NANOSECONDS.toMillis(Math.round(this.latency.getAverage() * 1.2));
        long l4 = l2 - 60000L - System.currentTimeMillis();
        TimeoutInterruptHandler.scheduleTask(this::requestUpdate, Math.max(0L, l4 - l3));
    }

    private static boolean isExpiring(@Blind JsonWebToken jsonWebToken) {
        return Clock.currentTimeMillis() + 30000L >= TimeUnit.SECONDS.toMillis(jsonWebToken.exp());
    }

    @Blind
    private static JsonWebToken requireJsonWebToken(@Blind AccessToken accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("token supplier has output a null value");
        }
        if (!(accessToken instanceof JsonWebToken)) {
            throw new IllegalArgumentException("token supplier has output an unrecognized object type: " + accessToken.getClass());
        }
        return (JsonWebToken)accessToken;
    }

    static {
        try {
            $$$methodRef$$$10 = JsonWebTokenCache.class.getDeclaredConstructor(Executor.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonWebTokenCache.class.getDeclaredMethod("lambda$create$0", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonWebTokenCache.class.getDeclaredMethod("lambda$requestUpdate$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonWebTokenCache.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonWebTokenCache.class.getDeclaredMethod("requireJsonWebToken", AccessToken.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonWebTokenCache.class.getDeclaredMethod("isExpiring", JsonWebToken.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonWebTokenCache.class.getDeclaredMethod("scheduleUpdate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonWebTokenCache.class.getDeclaredMethod("update", JsonWebToken.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonWebTokenCache.class.getDeclaredMethod("requestUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonWebTokenCache.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonWebTokenCache.class.getDeclaredMethod("create", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

