/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFDCNQueryChanges;
import oracle.jdbc.driver.NTFDCNTableChanges;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFDCNEvent
extends DatabaseChangeEvent {
    private static final long serialVersionUID = -1176415051550965782L;
    private int notifVersion = 0;
    private int notifRegid = 0;
    private DatabaseChangeEvent.EventType eventType;
    private DatabaseChangeEvent.AdditionalEventType additionalEventType = DatabaseChangeEvent.AdditionalEventType.NONE;
    private String databaseName = null;
    private byte[] notifXid = new byte[8];
    private int notifScn1 = 0;
    private int notifScn2 = 0;
    private int numberOfTables = 0;
    private NTFDCNTableChanges[] tcdesc = null;
    private int numberOfQueries = 0;
    private NTFDCNQueryChanges[] qdesc = null;
    private long registrationId;
    private NTFConnection conn;
    private int csid;
    private boolean isReady = false;
    private ByteBuffer dataBuffer;
    private boolean isDeregistrationEvent = false;
    private short databaseVersion;
    private boolean isClientInitiatedConnection = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    NTFDCNEvent(long l2, byte[] byArray, short s2, int n2) {
        super(new Object());
        this.dataBuffer = ByteBuffer.wrap(byArray);
        this.databaseVersion = s2;
        this.isClientInitiatedConnection = true;
        this.registrationId = l2;
        this.csid = n2;
    }

    NTFDCNEvent(NTFConnection nTFConnection, short s2) throws IOException, InterruptedException {
        super(nTFConnection);
        this.conn = nTFConnection;
        this.csid = this.conn.charset.getOracleId();
        int n2 = this.conn.readInt();
        byte[] byArray = new byte[n2];
        this.conn.readBuffer(byArray, 0, n2);
        this.dataBuffer = ByteBuffer.wrap(byArray);
        this.databaseVersion = s2;
    }

    private void initEvent() {
        short s2;
        if (!this.isClientInitiatedConnection) {
            s2 = this.dataBuffer.get();
            int n2 = this.dataBuffer.getInt();
            byte[] byArray = new byte[n2];
            this.dataBuffer.get(byArray, 0, n2);
            String string = null;
            try {
                string = new String(byArray, "UTF-8");
                string = string.replaceFirst("CHNF", "");
                this.registrationId = Long.parseLong(string);
            }
            catch (Exception exception) {
            }
            byte by = this.dataBuffer.get();
            int n3 = this.dataBuffer.getInt();
            byte[] byArray2 = new byte[n3];
            this.dataBuffer.get(byArray2, 0, n3);
            byte by2 = this.dataBuffer.get();
            int n4 = this.dataBuffer.getInt();
        }
        if (this.dataBuffer.hasRemaining()) {
            this.notifVersion = this.dataBuffer.getShort();
            this.notifRegid = this.dataBuffer.getInt();
            this.eventType = DatabaseChangeEvent.EventType.getEventType(this.dataBuffer.getInt());
            s2 = this.dataBuffer.getShort();
            byte[] byArray = new byte[s2];
            this.dataBuffer.get(byArray, 0, s2);
            try {
                this.databaseName = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dataBuffer.get(this.notifXid);
            this.notifScn1 = this.dataBuffer.getInt();
            this.notifScn2 = this.dataBuffer.getShort();
            if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
                this.numberOfTables = this.dataBuffer.getShort();
                this.tcdesc = new NTFDCNTableChanges[this.numberOfTables];
                for (int i2 = 0; i2 < this.tcdesc.length; ++i2) {
                    this.tcdesc[i2] = new NTFDCNTableChanges(this.dataBuffer, this.csid);
                }
            } else if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
                this.numberOfQueries = this.dataBuffer.getShort();
                this.qdesc = new NTFDCNQueryChanges[this.numberOfQueries];
                for (int i3 = 0; i3 < this.numberOfQueries; ++i3) {
                    this.qdesc[i3] = new NTFDCNQueryChanges(this.dataBuffer, this.csid);
                }
            }
        }
        this.isReady = true;
    }

    @Override
    public String getDatabaseName() {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.databaseName;
    }

    @Override
    public TableChangeDescription[] getTableChangeDescription() {
        if (!this.isReady) {
            this.initEvent();
        }
        if (this.eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
            return this.tcdesc;
        }
        return null;
    }

    @Override
    public QueryChangeDescription[] getQueryChangeDescription() {
        if (!this.isReady) {
            this.initEvent();
        }
        if (this.eventType == DatabaseChangeEvent.EventType.QUERYCHANGE) {
            return this.qdesc;
        }
        return null;
    }

    @Override
    public byte[] getTransactionId() {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.notifXid;
    }

    @Override
    public String getTransactionId(boolean bl) {
        long l2;
        int n2;
        int n3;
        if (!this.isReady) {
            this.initEvent();
        }
        if (!bl) {
            n3 = (this.notifXid[0] & 0xFF) << 8 | this.notifXid[1] & 0xFF;
            n2 = (this.notifXid[2] & 0xFF) << 8 | this.notifXid[3] & 0xFF;
            l2 = ((this.notifXid[4] & 0xFF) << 24 | (this.notifXid[5] & 0xFF) << 16 | (this.notifXid[6] & 0xFF) << 8 | this.notifXid[7] & 0xFF) & 0xFFFFFFFF;
        } else {
            n3 = (this.notifXid[1] & 0xFF) << 8 | this.notifXid[0] & 0xFF;
            n2 = (this.notifXid[3] & 0xFF) << 8 | this.notifXid[2] & 0xFF;
            l2 = ((this.notifXid[7] & 0xFF) << 24 | (this.notifXid[6] & 0xFF) << 16 | (this.notifXid[5] & 0xFF) << 8 | this.notifXid[4] & 0xFF) & 0xFFFFFFFF;
        }
        String string = n3 + "." + n2 + "." + l2;
        return string;
    }

    void setEventType(DatabaseChangeEvent.EventType eventType) throws IOException {
        if (!this.isReady) {
            this.initEvent();
        }
        this.eventType = eventType;
        if (this.eventType == DatabaseChangeEvent.EventType.DEREG) {
            this.isDeregistrationEvent = true;
        }
    }

    void setAdditionalEventType(DatabaseChangeEvent.AdditionalEventType additionalEventType) {
        this.additionalEventType = additionalEventType;
    }

    @Override
    public DatabaseChangeEvent.EventType getEventType() {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.eventType;
    }

    @Override
    public DatabaseChangeEvent.AdditionalEventType getAdditionalEventType() {
        return this.additionalEventType;
    }

    boolean isDeregistrationEvent() {
        return this.isDeregistrationEvent;
    }

    @Override
    public String getConnectionInformation() {
        if (this.conn == null) {
            return null;
        }
        return this.conn.connectionDescription;
    }

    @Override
    public int getRegistrationId() {
        if (!this.isReady) {
            this.initEvent();
        }
        return (int)this.registrationId;
    }

    @Override
    public long getRegId() {
        if (!this.isReady) {
            this.initEvent();
        }
        return this.registrationId;
    }

    @Override
    @DisableTrace
    public String toString() {
        QueryChangeDescription[] queryChangeDescriptionArray;
        TableChangeDescription[] tableChangeDescriptionArray;
        if (!this.isReady) {
            this.initEvent();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.conn != null) {
            stringBuffer.append("Connection information  : " + this.conn.connectionDescription + "\n");
        }
        stringBuffer.append("Registration ID         : " + this.registrationId + "\n");
        stringBuffer.append("Notification version    : " + this.notifVersion + "\n");
        stringBuffer.append("Event type              : " + this.eventType + "\n");
        if (this.additionalEventType != DatabaseChangeEvent.AdditionalEventType.NONE) {
            stringBuffer.append("Additional event type   : " + this.additionalEventType + "\n");
        }
        if (this.databaseName != null) {
            stringBuffer.append("Database name           : " + this.databaseName + "\n");
        }
        if ((tableChangeDescriptionArray = this.getTableChangeDescription()) != null) {
            stringBuffer.append("Table Change Description (length=" + this.numberOfTables + ")\n");
            for (int i2 = 0; i2 < tableChangeDescriptionArray.length; ++i2) {
                stringBuffer.append(tableChangeDescriptionArray[i2].toString());
            }
        }
        if ((queryChangeDescriptionArray = this.getQueryChangeDescription()) != null) {
            stringBuffer.append("Query Change Description (length=" + this.numberOfQueries + ")\n");
            for (int i3 = 0; i3 < queryChangeDescriptionArray.length; ++i3) {
                stringBuffer.append(queryChangeDescriptionArray[i3].toString());
            }
        }
        return stringBuffer.toString();
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$15 = NTFDCNEvent.class.getDeclaredConstructor(NTFConnection.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NTFDCNEvent.class.getDeclaredConstructor(Long.TYPE, byte[].class, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NTFDCNEvent.class.getDeclaredMethod("getRegId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFDCNEvent.class.getDeclaredMethod("getRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFDCNEvent.class.getDeclaredMethod("getConnectionInformation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFDCNEvent.class.getDeclaredMethod("isDeregistrationEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFDCNEvent.class.getDeclaredMethod("getAdditionalEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFDCNEvent.class.getDeclaredMethod("getEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFDCNEvent.class.getDeclaredMethod("setAdditionalEventType", DatabaseChangeEvent.AdditionalEventType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFDCNEvent.class.getDeclaredMethod("setEventType", DatabaseChangeEvent.EventType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFDCNEvent.class.getDeclaredMethod("getTransactionId", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFDCNEvent.class.getDeclaredMethod("getTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFDCNEvent.class.getDeclaredMethod("getQueryChangeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNEvent.class.getDeclaredMethod("getTableChangeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNEvent.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNEvent.class.getDeclaredMethod("initEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

