/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;

public class StatisticsTracker
implements Serializable {
    private final LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> acStatistics = new LinkedList();
    private final Monitor acStatisticsMonitor = Monitor.newInstance();
    private AtomicBoolean dsNameSet = new AtomicBoolean(false);
    private String dsName = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public ReplayStatistics getReplayStatistics() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        int[] nArray = new int[31];
        try (Serializable serializable = this.acStatisticsMonitor.acquireCloseableLock();){
            for (oracle.jdbc.replay.internal.ReplayStatistics replayStatistics : this.acStatistics) {
                l2 += replayStatistics.getTotalRequests();
                l3 += replayStatistics.getTotalCompletedRequests();
                l4 += replayStatistics.getTotalCalls();
                l5 += replayStatistics.getTotalProtectedCalls();
                l6 += replayStatistics.getTotalCallsAffectedByOutages();
                l7 += replayStatistics.getTotalCallsTriggeringReplay();
                l8 += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
                l9 += replayStatistics.getSuccessfulReplayCount();
                l10 += replayStatistics.getFailedReplayCount();
                l11 += replayStatistics.getReplayDisablingCount();
                l12 += replayStatistics.getTotalReplayAttempts();
                int[] nArray2 = replayStatistics.getRequestSizeHistogram();
                if (nArray2 == null || nArray2.length <= 0) continue;
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    int n2 = i2;
                    nArray[n2] = nArray[n2] + nArray2[i2];
                }
            }
        }
        serializable = new ReplayStatisticsImpl(l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, 0);
        ((ReplayStatisticsImpl)serializable).setRequestSizeHistogram(nArray);
        return serializable;
    }

    @DisableTrace
    public String getReplayStatisticsString() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        int[] nArray = new int[31];
        StringBuilder stringBuilder = new StringBuilder().append("All current in-flight AC request sizes:").append("\n===============================================");
        try (Serializable serializable = this.acStatisticsMonitor.acquireCloseableLock();){
            for (oracle.jdbc.replay.internal.ReplayStatistics replayStatistics : this.acStatistics) {
                l2 += replayStatistics.getTotalRequests();
                l3 += replayStatistics.getTotalCompletedRequests();
                l4 += replayStatistics.getTotalCalls();
                l5 += replayStatistics.getTotalProtectedCalls();
                l6 += replayStatistics.getTotalCallsAffectedByOutages();
                l7 += replayStatistics.getTotalCallsTriggeringReplay();
                l8 += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
                l9 += replayStatistics.getSuccessfulReplayCount();
                l10 += replayStatistics.getFailedReplayCount();
                l11 += replayStatistics.getReplayDisablingCount();
                l12 += replayStatistics.getTotalReplayAttempts();
                stringBuilder.append("\n  ").append(replayStatistics.getCurrentRequestSize());
                int[] nArray2 = replayStatistics.getRequestSizeHistogram();
                if (nArray2 == null || nArray2.length <= 0) continue;
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    int n2 = i2;
                    nArray[n2] = nArray[n2] + nArray2[i2];
                }
            }
        }
        serializable = new ReplayStatisticsImpl(l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, 0);
        ((ReplayStatisticsImpl)serializable).setRequestSizeHistogram(nArray);
        stringBuilder.append("\n===============================================").append("\n\n").append(((ReplayStatisticsImpl)serializable).toString()).append("\n\n").append(((ReplayStatisticsImpl)serializable).getRequestSizeHistogramString()).append("\n\n");
        return stringBuilder.toString();
    }

    public void clearReplayStatistics() {
        try (Monitor.CloseableLock closeableLock = this.acStatisticsMonitor.acquireCloseableLock();){
            for (oracle.jdbc.replay.internal.ReplayStatistics replayStatistics : this.acStatistics) {
                replayStatistics.clear();
            }
        }
    }

    public void updateReplayStatistics(String string, oracle.jdbc.replay.internal.ReplayStatistics replayStatistics) {
        if (this.dsNameSet.compareAndSet(false, true) && string != null) {
            this.dsName = string;
        }
        try (Monitor.CloseableLock closeableLock = this.acStatisticsMonitor.acquireCloseableLock();){
            this.acStatistics.add(replayStatistics);
        }
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    static {
        try {
            $$$methodRef$$$4 = StatisticsTracker.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = StatisticsTracker.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = StatisticsTracker.class.getDeclaredMethod("updateReplayStatistics", String.class, oracle.jdbc.replay.internal.ReplayStatistics.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = StatisticsTracker.class.getDeclaredMethod("clearReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = StatisticsTracker.class.getDeclaredMethod("getReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

