/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;

public class JsonSerializerImpl
extends AbstractGenerator {
    private static final byte[] CHAR_TYPES;
    private static final byte CHAR_OTHER = 0;
    private static final byte CHAR_CONTROL = 1;
    private static final byte CHAR_LF = 2;
    private static final byte CHAR_QUOTATION = 3;
    private static final byte CHAR_REVERSE_SOLIDUS = 4;
    private static final byte CHAR_SURROGATE = 5;
    private static final byte CHAR_BACKSPACE = 6;
    private static final byte CHAR_FORMFEED = 7;
    private static final byte CHAR_CR = 8;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_ASCII = 10;
    private static final int ASCII_MAX = 127;
    private JsonOutput writer;
    private StreamContext ctx;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;

    public JsonSerializerImpl(OutputStream outputStream) {
        this.writer = new UTF8JsonOutput(outputStream);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    public JsonSerializerImpl(Writer writer) {
        this.writer = new WriterJsonOutput(writer);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.writeSeparator();
        this.ctx.startObject();
        this.writeAscii('{');
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.writeSeparator();
        this.ctx.startArray();
        this.writeAscii('[');
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        if (this.ctx.inObject()) {
            this.ctx.end();
            this.writeAscii('}');
        } else {
            this.ctx.end();
            this.writeAscii(']');
        }
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string) {
        this.primitive();
        JsonSerializerImpl.writeQuotedString(string, this.writer, this.getExceptionFactory());
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String string) {
        this.writeSeparator();
        this.ctx.pendingKey();
        JsonSerializerImpl.writeQuotedString(string, this.writer, this.getExceptionFactory());
        this.writeAscii(':');
        return this;
    }

    private static void writeQuotedString(String string, JsonOutput jsonOutput, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        try {
            jsonOutput.writeAscii((byte)34);
            JsonSerializerImpl.writeEscaped(string, jsonOutput);
            jsonOutput.writeAscii((byte)34);
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(exceptionFactory, iOException, new Object[0]);
        }
    }

    public static String serializeString(String string) {
        StringWriter stringWriter = new StringWriter();
        WriterJsonOutput writerJsonOutput = new WriterJsonOutput(stringWriter);
        JsonSerializerImpl.writeQuotedString(string, writerJsonOutput, null);
        try {
            writerJsonOutput.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringWriter.toString();
    }

    @Override
    public OracleJsonGenerator write(BigDecimal bigDecimal) {
        this.primitive();
        this.writeBigDecimal(bigDecimal);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger bigInteger) {
        this.primitive();
        this.writeBigInteger(bigInteger);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int n2) {
        this.primitive();
        this.writeInt(n2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long l2) {
        this.primitive();
        this.writeLong(l2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double d2) {
        this.assertFinite(d2);
        this.primitive();
        this.writeDouble(d2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float f2) {
        this.assertFinite(f2);
        this.primitive();
        this.writeFloat(f2);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean bl) {
        this.primitive();
        this.writeBoolean(bl);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.primitive();
        this.writeNullInternal();
        return this;
    }

    @Override
    public void close() {
        this.ctx.close();
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    protected OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary oracleJsonBinary) {
        return this.write(((OracleJsonBinaryImpl)oracleJsonBinary).getString());
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble oracleJsonDouble) {
        return this.writeNumber(oracleJsonDouble);
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat oracleJsonFloat) {
        return this.writeNumber(oracleJsonFloat);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal oracleJsonDecimal) {
        return this.writeNumber(oracleJsonDecimal);
    }

    private OracleJsonGenerator writeNumber(OracleJsonNumber oracleJsonNumber) {
        this.primitive();
        try {
            this.writer.writeAscii(this.numberToString(oracleJsonNumber));
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
        return this;
    }

    private String numberToString(OracleJsonNumber oracleJsonNumber) {
        if (oracleJsonNumber instanceof OracleJsonNumberImpl) {
            return ((OracleJsonNumberImpl)((Object)oracleJsonNumber)).getString();
        }
        return oracleJsonNumber.toString();
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp oracleJsonTimestamp) {
        return this.write(((OracleJsonTimestampImpl)oracleJsonTimestamp).getString());
    }

    @Override
    protected OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ oracleJsonTimestampTZ) {
        return this.write(((OracleJsonTimestampTZImpl)oracleJsonTimestampTZ).getString());
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate oracleJsonDate) {
        return this.write(((OracleJsonDateImpl)oracleJsonDate).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS oracleJsonIntervalDS) {
        return this.write(((OracleJsonIntervalDSImpl)oracleJsonIntervalDS).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM oracleJsonIntervalYM) {
        return this.write(((OracleJsonIntervalYMImpl)oracleJsonIntervalYM).getString());
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString oracleJsonString) {
        return this.write(oracleJsonString.getString());
    }

    private void writeAscii(CharSequence charSequence) {
        try {
            this.writer.writeAscii(charSequence);
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    private void writeBigDecimal(BigDecimal bigDecimal) {
        this.writeAscii(bigDecimal.toString());
    }

    private void writeBigInteger(BigInteger bigInteger) {
        this.writeAscii(new BigDecimal(bigInteger).toString());
    }

    private void writeInt(int n2) {
        this.writeAscii(new BigDecimal(n2).toString());
    }

    private void writeLong(long l2) {
        this.writeAscii(new BigDecimal(l2).toString());
    }

    private void writeFloat(float f2) {
        this.writeAscii(Float.toString(f2));
    }

    private void writeDouble(double d2) {
        this.writeAscii(Double.toString(d2));
    }

    private void writeBoolean(boolean bl) {
        this.writeAscii(String.valueOf(bl));
    }

    private void writeNullInternal() {
        this.writeAscii("null");
    }

    private void writeAscii(char c2) {
        try {
            this.writer.writeAscii((byte)c2);
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    private void primitive() {
        this.writeSeparator();
        this.ctx.primitive();
    }

    private void writeSeparator() {
        if (this.ctx.hasChildren() && !this.ctx.pendingKey) {
            this.writeAscii(',');
        }
    }

    private static void writeEscaped(String string, JsonOutput jsonOutput) throws IOException {
        int n2 = string.length();
        block13: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (CHAR_TYPES[c2]) {
                case 10: {
                    jsonOutput.writeAscii((byte)c2);
                    continue block13;
                }
                case 0: {
                    jsonOutput.write(c2);
                    continue block13;
                }
                case 2: {
                    jsonOutput.writeAscii("\\n");
                    continue block13;
                }
                case 6: {
                    jsonOutput.writeAscii("\\b");
                    continue block13;
                }
                case 7: {
                    jsonOutput.writeAscii("\\f");
                    continue block13;
                }
                case 8: {
                    jsonOutput.writeAscii("\\r");
                    continue block13;
                }
                case 9: {
                    jsonOutput.writeAscii("\\t");
                    continue block13;
                }
                case 3: {
                    jsonOutput.writeAscii("\\\"");
                    continue block13;
                }
                case 4: {
                    jsonOutput.writeAscii("\\\\");
                    continue block13;
                }
                case 1: {
                    JsonSerializerImpl.escape(c2, jsonOutput);
                    continue block13;
                }
                case 5: {
                    jsonOutput.writeSurrogates(string.charAt(i2), string.charAt(i2 + 1));
                    ++i2;
                }
            }
        }
    }

    private void assertFinite(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new NumberFormatException(Double.toString(d2));
        }
    }

    private static void escape(int n2, JsonOutput jsonOutput) throws IOException {
        for (char c2 : Character.toChars(n2)) {
            String string = Integer.toHexString(c2).toUpperCase();
            jsonOutput.writeAscii("\\u");
            for (int i2 = 0; i2 < 4 - string.length(); ++i2) {
                jsonOutput.writeAscii((byte)48);
            }
            jsonOutput.writeAscii(string);
        }
    }

    @Override
    public OracleJsonGenerator write(LocalDateTime localDateTime) {
        byte[] byArray = OsonPrimitiveConversions.toOracleTimestamp(this.getExceptionFactory(), localDateTime);
        this.write(OsonPrimitiveConversions.timestampToString(this.getExceptionFactory(), byArray));
        return this;
    }

    @Override
    public OracleJsonGenerator write(OffsetDateTime offsetDateTime) {
        byte[] byArray = OsonPrimitiveConversions.toOracleTimestampTZ(this.getExceptionFactory(), offsetDateTime);
        this.write(OsonPrimitiveConversions.timestampTZToString(this.getExceptionFactory(), byArray));
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, LocalDateTime localDateTime) {
        this.writeKey(string);
        this.write(localDateTime);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, OffsetDateTime offsetDateTime) {
        this.writeKey(string);
        this.write(offsetDateTime);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String string, byte[] byArray) {
        this.writeKey(string);
        this.write(byArray);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] byArray) {
        return this.write(OracleJsonBinaryImpl.getString(byArray, false));
    }

    @Override
    public OracleJsonGenerator writeId(byte[] byArray) {
        return this.write(OracleJsonBinaryImpl.getString(byArray, true));
    }

    @Override
    public OracleJsonGenerator write(Period period) {
        return this.write(OracleJsonIntervalYMImpl.serializePeriod(period, this.getExceptionFactory()));
    }

    @Override
    public OracleJsonGenerator write(Duration duration) {
        return this.write(OracleJsonIntervalDSImpl.serializeDuration(duration, this.getExceptionFactory()));
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser oracleJsonParser) {
        if (!this.writer.utf8() || !(oracleJsonParser instanceof OsonParserImpl)) {
            this.write(oracleJsonParser.getString());
            return;
        }
        this.primitive();
        OsonParserImpl osonParserImpl = (OsonParserImpl)oracleJsonParser;
        byte[] byArray = osonParserImpl.getContext().b.buffer.array();
        this.writeQuotedUTF8String(byArray, osonParserImpl.getCurrentStringPos(), osonParserImpl.getCurrentStringLen());
    }

    private void writeQuotedUTF8String(byte[] byArray, int n2, int n3) {
        try {
            this.writeAscii('\"');
            int n4 = n2 + n3;
            block13: for (int i2 = n2; i2 < n4; ++i2) {
                byte by = byArray[i2];
                switch (CHAR_TYPES[by & 0xFF]) {
                    case 10: {
                        this.writer.writeAscii(by);
                        continue block13;
                    }
                    case 2: {
                        this.writer.writeAscii("\\n");
                        continue block13;
                    }
                    case 6: {
                        this.writer.writeAscii("\\b");
                        continue block13;
                    }
                    case 7: {
                        this.writer.writeAscii("\\f");
                        continue block13;
                    }
                    case 8: {
                        this.writer.writeAscii("\\r");
                        continue block13;
                    }
                    case 9: {
                        this.writer.writeAscii("\\t");
                        continue block13;
                    }
                    case 3: {
                        this.writer.writeAscii("\\\"");
                        continue block13;
                    }
                    case 4: {
                        this.writer.writeAscii("\\\\");
                        continue block13;
                    }
                    case 1: {
                        JsonSerializerImpl.escape(by, this.writer);
                        continue block13;
                    }
                    default: {
                        if ((by & 0xE0) == 192) {
                            this.writer.utf8(byArray, i2, 2);
                            ++i2;
                            continue block13;
                        }
                        if ((by & 0xF0) == 224) {
                            this.writer.utf8(byArray, i2, 3);
                            i2 += 2;
                            continue block13;
                        }
                        this.writer.utf8(byArray, i2, 4);
                        i2 += 3;
                    }
                }
            }
            this.writeAscii('\"');
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser oracleJsonParser) {
        this.primitive();
        try {
            this.writer.writeAscii(oracleJsonParser.getString());
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    static {
        int n2;
        try {
            $$$methodRef$$$58 = JsonSerializerImpl.class.getDeclaredConstructor(Writer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = JsonSerializerImpl.class.getDeclaredConstructor(OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = JsonSerializerImpl.class.getDeclaredMethod("writeDecimalFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = JsonSerializerImpl.class.getDeclaredMethod("writeQuotedUTF8String", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = JsonSerializerImpl.class.getDeclaredMethod("writeStringFromParser", OracleJsonParser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = JsonSerializerImpl.class.getDeclaredMethod("write", Duration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = JsonSerializerImpl.class.getDeclaredMethod("write", Period.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = JsonSerializerImpl.class.getDeclaredMethod("writeId", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = JsonSerializerImpl.class.getDeclaredMethod("write", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class, OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class, LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = JsonSerializerImpl.class.getDeclaredMethod("write", OffsetDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = JsonSerializerImpl.class.getDeclaredMethod("write", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = JsonSerializerImpl.class.getDeclaredMethod("escape", Integer.TYPE, JsonOutput.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = JsonSerializerImpl.class.getDeclaredMethod("assertFinite", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = JsonSerializerImpl.class.getDeclaredMethod("writeEscaped", String.class, JsonOutput.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = JsonSerializerImpl.class.getDeclaredMethod("writeSeparator", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = JsonSerializerImpl.class.getDeclaredMethod("primitive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = JsonSerializerImpl.class.getDeclaredMethod("writeAscii", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = JsonSerializerImpl.class.getDeclaredMethod("writeNullInternal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = JsonSerializerImpl.class.getDeclaredMethod("writeBoolean", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = JsonSerializerImpl.class.getDeclaredMethod("writeDouble", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = JsonSerializerImpl.class.getDeclaredMethod("writeFloat", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = JsonSerializerImpl.class.getDeclaredMethod("writeLong", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = JsonSerializerImpl.class.getDeclaredMethod("writeInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = JsonSerializerImpl.class.getDeclaredMethod("writeBigInteger", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = JsonSerializerImpl.class.getDeclaredMethod("writeBigDecimal", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = JsonSerializerImpl.class.getDeclaredMethod("writeAscii", CharSequence.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = JsonSerializerImpl.class.getDeclaredMethod("writeString", OracleJsonString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = JsonSerializerImpl.class.getDeclaredMethod("writeIntervalYM", OracleJsonIntervalYM.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = JsonSerializerImpl.class.getDeclaredMethod("writeIntervalDS", OracleJsonIntervalDS.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JsonSerializerImpl.class.getDeclaredMethod("writeDate", OracleJsonDate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JsonSerializerImpl.class.getDeclaredMethod("writeTimestampTZ", OracleJsonTimestampTZ.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JsonSerializerImpl.class.getDeclaredMethod("writeTimestamp", OracleJsonTimestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonSerializerImpl.class.getDeclaredMethod("numberToString", OracleJsonNumber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonSerializerImpl.class.getDeclaredMethod("writeNumber", OracleJsonNumber.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonSerializerImpl.class.getDeclaredMethod("writeOraNumber", OracleJsonDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonSerializerImpl.class.getDeclaredMethod("writeFloat", OracleJsonFloat.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonSerializerImpl.class.getDeclaredMethod("writeDouble", OracleJsonDouble.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonSerializerImpl.class.getDeclaredMethod("writeBinary", OracleJsonBinary.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonSerializerImpl.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonSerializerImpl.class.getDeclaredMethod("getExceptionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonSerializerImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonSerializerImpl.class.getDeclaredMethod("writeNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonSerializerImpl.class.getDeclaredMethod("write", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonSerializerImpl.class.getDeclaredMethod("write", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonSerializerImpl.class.getDeclaredMethod("write", Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonSerializerImpl.class.getDeclaredMethod("write", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonSerializerImpl.class.getDeclaredMethod("write", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonSerializerImpl.class.getDeclaredMethod("write", BigInteger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonSerializerImpl.class.getDeclaredMethod("write", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonSerializerImpl.class.getDeclaredMethod("serializeString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonSerializerImpl.class.getDeclaredMethod("writeQuotedString", String.class, JsonOutput.class, OracleJsonExceptions.ExceptionFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonSerializerImpl.class.getDeclaredMethod("writeKey", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonSerializerImpl.class.getDeclaredMethod("write", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonSerializerImpl.class.getDeclaredMethod("writeEnd", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonSerializerImpl.class.getDeclaredMethod("writeStartArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonSerializerImpl.class.getDeclaredMethod("writeStartObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        CHAR_TYPES = new byte[65536];
        for (n2 = 0; n2 <= 127; ++n2) {
            JsonSerializerImpl.CHAR_TYPES[n2] = 10;
        }
        for (n2 = 0; n2 <= 31; n2 = (int)((char)(n2 + 1))) {
            JsonSerializerImpl.CHAR_TYPES[n2] = 1;
        }
        JsonSerializerImpl.CHAR_TYPES[127] = 1;
        JsonSerializerImpl.CHAR_TYPES[10] = 2;
        JsonSerializerImpl.CHAR_TYPES[92] = 4;
        JsonSerializerImpl.CHAR_TYPES[34] = 3;
        JsonSerializerImpl.CHAR_TYPES[8] = 6;
        JsonSerializerImpl.CHAR_TYPES[12] = 7;
        JsonSerializerImpl.CHAR_TYPES[13] = 8;
        JsonSerializerImpl.CHAR_TYPES[9] = 9;
        for (n2 = 55296; n2 <= 56319; n2 = (int)((char)(n2 + 1))) {
            JsonSerializerImpl.CHAR_TYPES[n2] = 5;
        }
    }

    private static class UTF8JsonOutput
    implements JsonOutput {
        byte[] buffer = new byte[1024];
        OutputStream out;
        int pos = 0;
        CharsetEncoder encoder;
        CharBuffer cbuffer;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        public UTF8JsonOutput(OutputStream outputStream) {
            this.out = outputStream;
        }

        private void initEncoder() {
            if (this.encoder == null) {
                this.encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.cbuffer = CharBuffer.allocate(2);
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
            this.buffer = null;
        }

        @Override
        public void writeAscii(CharSequence charSequence) throws IOException {
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = (byte)charSequence.charAt(i2);
            }
        }

        @Override
        public void writeAscii(byte by) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = by;
        }

        @Override
        public void flush() throws IOException {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void write(char c2) throws IOException {
            if (c2 <= '\u007f') {
                this.writeAscii((byte)c2);
            } else {
                this.flush();
                this.initEncoder();
                this.cbuffer.clear();
                this.cbuffer.append(c2);
                this.cbuffer.flip();
                this.encodeChars();
            }
        }

        @Override
        public void writeSurrogates(char c2, char c3) throws IOException {
            this.flush();
            this.initEncoder();
            this.cbuffer.clear();
            this.cbuffer.append(c2);
            this.cbuffer.append(c3);
            this.cbuffer.flip();
            this.encodeChars();
        }

        @Override
        public boolean utf8() {
            return true;
        }

        private void encodeChars() {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer);
            this.encoder.encode(this.cbuffer, byteBuffer, false);
            this.pos = byteBuffer.position();
        }

        @Override
        public void utf8(byte[] byArray, int n2, int n3) throws IOException {
            this.flush();
            this.out.write(byArray, n2, n3);
        }

        static {
            try {
                $$$methodRef$$$10 = UTF8JsonOutput.class.getDeclaredConstructor(OutputStream.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = UTF8JsonOutput.class.getDeclaredMethod("utf8", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = UTF8JsonOutput.class.getDeclaredMethod("encodeChars", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = UTF8JsonOutput.class.getDeclaredMethod("utf8", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = UTF8JsonOutput.class.getDeclaredMethod("writeSurrogates", Character.TYPE, Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = UTF8JsonOutput.class.getDeclaredMethod("write", Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = UTF8JsonOutput.class.getDeclaredMethod("flush", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = UTF8JsonOutput.class.getDeclaredMethod("writeAscii", Byte.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = UTF8JsonOutput.class.getDeclaredMethod("writeAscii", CharSequence.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = UTF8JsonOutput.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = UTF8JsonOutput.class.getDeclaredMethod("initEncoder", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class WriterJsonOutput
    implements JsonOutput {
        char[] buffer = new char[1024];
        int pos = 0;
        Writer writer;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        WriterJsonOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.writer.close();
            this.buffer = null;
        }

        @Override
        public void flush() throws IOException {
            this.writer.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void writeAscii(CharSequence charSequence) throws IOException {
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = charSequence.charAt(i2);
            }
        }

        @Override
        public void writeAscii(byte by) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = (char)by;
        }

        @Override
        public void write(char c2) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = c2;
        }

        @Override
        public void writeSurrogates(char c2, char c3) throws IOException {
            this.write(c2);
            this.write(c3);
        }

        @Override
        public boolean utf8() {
            return false;
        }

        @Override
        public void utf8(byte[] byArray, int n2, int n3) throws IOException {
            this.flush();
            this.writer.write(new String(byArray, n2, n3, StandardCharsets.UTF_8));
        }

        static {
            try {
                $$$methodRef$$$8 = WriterJsonOutput.class.getDeclaredConstructor(Writer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = WriterJsonOutput.class.getDeclaredMethod("utf8", byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WriterJsonOutput.class.getDeclaredMethod("utf8", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WriterJsonOutput.class.getDeclaredMethod("writeSurrogates", Character.TYPE, Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WriterJsonOutput.class.getDeclaredMethod("write", Character.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WriterJsonOutput.class.getDeclaredMethod("writeAscii", Byte.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WriterJsonOutput.class.getDeclaredMethod("writeAscii", CharSequence.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WriterJsonOutput.class.getDeclaredMethod("flush", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WriterJsonOutput.class.getDeclaredMethod("close", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static interface JsonOutput
    extends Closeable {
        public void flush() throws IOException;

        public void write(char var1) throws IOException;

        public void writeAscii(CharSequence var1) throws IOException;

        public void writeAscii(byte var1) throws IOException;

        public void writeSurrogates(char var1, char var2) throws IOException;

        public boolean utf8();

        public void utf8(byte[] var1, int var2, int var3) throws IOException;
    }
}

