/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public abstract class OracleXAConnection
extends OraclePooledConnection
implements oracle.jdbc.datasource.OracleXAConnection {
    protected XAResource xaResource = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public OracleXAConnection() throws XAException {
        this((Connection)null);
    }

    public OracleXAConnection(Connection connection) throws XAException {
        super(connection);
    }

    @Override
    public abstract XAResource getXAResource() throws SQLException;

    @Override
    public Connection getConnection() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            Connection connection = super.getConnection();
            if (this.xaResource != null) {
                ((OracleXAResource)this.xaResource).setLogicalConnection(connection);
            }
            Connection connection2 = connection;
            return connection2;
        }
    }

    boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    void setAutoCommit(boolean bl) throws SQLException {
        this.autoCommit = bl;
    }

    static {
        try {
            $$$methodRef$$$4 = OracleXAConnection.class.getDeclaredConstructor(Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAConnection.class.getDeclaredMethod("setAutoCommit", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAConnection.class.getDeclaredMethod("getAutoCommit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAConnection.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

