/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.File;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

public class EnvVariableResolver {
    private static final boolean IS_WINDOWS_FILE_SYSTEM;
    private static final Pattern PLACE_HOLDER_PATTERN;
    private static final String TNS_ADMIN = "TNS_ADMIN";
    private static final List<Character> SUPPORTED_PRE_CHARS;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public static String resolveEnvPlaceHolders(String string, @Blind(value=PropertiesBlinder.class) Properties properties) {
        Matcher matcher = PLACE_HOLDER_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2;
            String string3;
            String string4 = matcher.group(1);
            if (string4 == null || string4.length() < 4 || (string3 = EnvVariableResolver.getEnvValue(string2 = string4.substring(2, string4.length() - 1), properties)) == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String resolveFilePath(String string, @Blind(value=PropertiesBlinder.class) Properties properties) {
        if (EnvVariableResolver.checkIfFileExists(string)) {
            return string;
        }
        return new EnvKeyParser(string.toCharArray()).traverse(properties);
    }

    private static boolean checkIfFileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    private static String getEnvValue(String string, @Blind(value=PropertiesBlinder.class) Properties properties) {
        if (string.equalsIgnoreCase(TNS_ADMIN) && properties.containsKey("oracle.net.tns_admin")) {
            return properties.getProperty("oracle.net.tns_admin");
        }
        String string2 = System.getProperty(string);
        if (string2 == null) {
            try {
                string2 = AccessController.doPrivileged(() -> System.getenv(string));
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return string2;
    }

    static {
        try {
            $$$methodRef$$$7 = EnvVariableResolver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = EnvVariableResolver.class.getDeclaredMethod("access$200", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = EnvVariableResolver.class.getDeclaredMethod("access$100", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = EnvVariableResolver.class.getDeclaredMethod("lambda$getEnvValue$0", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = EnvVariableResolver.class.getDeclaredMethod("getEnvValue", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = EnvVariableResolver.class.getDeclaredMethod("checkIfFileExists", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = EnvVariableResolver.class.getDeclaredMethod("resolveFilePath", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = EnvVariableResolver.class.getDeclaredMethod("resolveEnvPlaceHolders", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        IS_WINDOWS_FILE_SYSTEM = File.separator.equals("\\");
        PLACE_HOLDER_PATTERN = Pattern.compile("(\\$\\{.*?\\})");
        SUPPORTED_PRE_CHARS = IS_WINDOWS_FILE_SYSTEM ? Arrays.asList(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(' '), Character.valueOf(':')) : Arrays.asList(Character.valueOf('/'), Character.valueOf(' '), Character.valueOf(':'));
    }

    private static class EnvKeyParser {
        private final char[] input;
        private final StringBuilder outputBuffer;
        private int currentIndex = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        private EnvKeyParser(char[] cArray) {
            this.input = cArray;
            this.outputBuffer = new StringBuilder();
        }

        public String traverse(@Blind(value=PropertiesBlinder.class) Properties properties) {
            char c2 = ' ';
            while (this.currentIndex < this.input.length) {
                switch (this.input[this.currentIndex]) {
                    case '$': {
                        if (SUPPORTED_PRE_CHARS.contains(Character.valueOf(c2))) {
                            this.lookForLinuxEnvReplacement(properties);
                            break;
                        }
                        this.outputBuffer.append(this.input[this.currentIndex]);
                        break;
                    }
                    case '%': {
                        if (SUPPORTED_PRE_CHARS.contains(Character.valueOf(c2))) {
                            this.lookForWindowsEnvReplacement(properties);
                            break;
                        }
                        this.outputBuffer.append(this.input[this.currentIndex]);
                        break;
                    }
                    default: {
                        this.outputBuffer.append(this.input[this.currentIndex]);
                    }
                }
                if (this.currentIndex < this.input.length && !Character.isWhitespace(this.input[this.currentIndex])) {
                    c2 = this.input[this.currentIndex];
                }
                ++this.currentIndex;
            }
            return this.outputBuffer.toString();
        }

        private boolean lookForWindowsEnvReplacement(@Blind(value=PropertiesBlinder.class) Properties properties) {
            String string;
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(this.input[this.currentIndex]);
            boolean bl = false;
            ++this.currentIndex;
            while (this.currentIndex < this.input.length) {
                stringBuilder2.append(this.input[this.currentIndex]);
                if (this.input[this.currentIndex] == '%') {
                    bl = true;
                    break;
                }
                if (!Character.isWhitespace(this.input[this.currentIndex])) {
                    stringBuilder.append(this.input[this.currentIndex]);
                }
                ++this.currentIndex;
            }
            if (bl && (string2 = EnvVariableResolver.getEnvValue(string = stringBuilder.toString(), properties)) != null) {
                this.outputBuffer.append(string2);
                return true;
            }
            this.outputBuffer.append(stringBuilder2.toString());
            return false;
        }

        private boolean lookForLinuxEnvReplacement(@Blind(value=PropertiesBlinder.class) Properties properties) {
            String string;
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.input[this.currentIndex]);
            StringBuilder stringBuilder2 = new StringBuilder();
            ++this.currentIndex;
            while (this.currentIndex < this.input.length) {
                stringBuilder.append(this.input[this.currentIndex]);
                if (this.input[this.currentIndex] == '/') break;
                if (!Character.isWhitespace(this.input[this.currentIndex])) {
                    stringBuilder2.append(this.input[this.currentIndex]);
                }
                ++this.currentIndex;
            }
            if ((string2 = EnvVariableResolver.getEnvValue(string = stringBuilder2.toString(), properties)) != null) {
                this.outputBuffer.append(string2);
                if (this.currentIndex < this.input.length) {
                    this.outputBuffer.append(this.input[this.currentIndex]);
                }
                return true;
            }
            this.outputBuffer.append(stringBuilder.toString());
            return false;
        }

        static {
            try {
                $$$methodRef$$$4 = EnvKeyParser.class.getDeclaredConstructor(char[].class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = EnvKeyParser.class.getDeclaredConstructor(char[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = EnvKeyParser.class.getDeclaredMethod("lookForLinuxEnvReplacement", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = EnvKeyParser.class.getDeclaredMethod("lookForWindowsEnvReplacement", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = EnvKeyParser.class.getDeclaredMethod("traverse", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

