/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class RAW
extends Datum {
    static final long serialVersionUID = -3298750557928937840L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    static int hexDigit2Nibble(char c2) throws SQLException {
        int n2 = Character.digit(c2, 16);
        if (n2 == -1) {
            throw (SQLException)DatabaseError.createSqlException(59, "Invalid hex digit: " + c2).fillInStackTrace();
        }
        return n2;
    }

    public static byte[] hexString2Bytes(String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, RAW.class, $$$methodRef$$$1, null, string);
            }
            int n2 = string.length();
            char[] cArray = new char[n2];
            string.getChars(0, n2, cArray, 0);
            int n3 = 0;
            int n4 = 0;
            if (n2 == 0) {
                byte[] byArray2 = new byte[]{};
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, RAW.class, $$$methodRef$$$1, null, byArray2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RAW.class, $$$methodRef$$$1, null, null);
                }
                return byArray2;
            }
            if (n2 % 2 > 0) {
                byArray = new byte[(n2 + 1) / 2];
                byArray[n3++] = (byte)RAW.hexDigit2Nibble(cArray[n4++]);
            } else {
                byArray = new byte[n2 / 2];
            }
            while (n3 < byArray.length) {
                byArray[n3] = (byte)(RAW.hexDigit2Nibble(cArray[n4++]) << 4 | RAW.hexDigit2Nibble(cArray[n4++]));
                ++n3;
            }
            byte[] byArray3 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, RAW.class, $$$methodRef$$$1, null, byArray3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RAW.class, $$$methodRef$$$1, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RAW.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static RAW newRAW(Object object) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            RAW rAW;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, RAW.class, $$$methodRef$$$2, null, object);
            }
            RAW rAW2 = rAW = new RAW(object);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RAW.class, $$$methodRef$$$2, null, rAW2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RAW.class, $$$methodRef$$$2, null, null);
            }
            return rAW2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RAW.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static RAW oldRAW(Object object) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            RAW rAW;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, RAW.class, $$$methodRef$$$3, null, object);
            }
            if (object instanceof String) {
                String string = (String)object;
                byte[] byArray = null;
                try {
                    byArray = string.getBytes("ISO8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLException sQLException = DatabaseError.createSqlException(109, "ISO8859_1 character encoding not found");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, RAW.class, $$$methodRef$$$3, null, sQLException);
                    }
                    throw sQLException;
                }
                rAW = new RAW(byArray);
            } else {
                rAW = new RAW(object);
            }
            RAW rAW2 = rAW;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, RAW.class, $$$methodRef$$$3, null, rAW2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RAW.class, $$$methodRef$$$3, null, null);
            }
            return rAW2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RAW.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public RAW() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, RAW.class, $$$methodRef$$$12, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, RAW.class, $$$methodRef$$$12, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, RAW.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, RAW.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public RAW(byte[] byArray) {
        super(byArray);
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, RAW.class, $$$methodRef$$$13, null, new Object[]{byArray});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, RAW.class, $$$methodRef$$$13, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, RAW.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, RAW.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public RAW(Object object) throws SQLException {
        this();
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, RAW.class, $$$methodRef$$$14, null, object);
            }
            if (object instanceof byte[]) {
                this.setShareBytes((byte[])object);
            } else if (object instanceof String) {
                this.setShareBytes(RAW.hexString2Bytes((String)object));
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, RAW.class, $$$methodRef$$$14, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, RAW.class, $$$methodRef$$$14, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, RAW.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, RAW.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, RAW.class, $$$methodRef$$$4, this, new Object[0]);
            }
            byte[] byArray = this.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, RAW.class, $$$methodRef$$$4, this, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RAW.class, $$$methodRef$$$4, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RAW.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, RAW.class, $$$methodRef$$$5, this, clazz);
            }
            if ((string = clazz.getName()).compareTo("java.lang.String") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, RAW.class, $$$methodRef$$$5, this, bl2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RAW.class, $$$methodRef$$$5, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, RAW.class, $$$methodRef$$$5, this, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RAW.class, $$$methodRef$$$5, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RAW.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String stringValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, RAW.class, $$$methodRef$$$6, this, new Object[0]);
            }
            String string2 = string = RepConversion.bArray2String(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, RAW.class, $$$methodRef$$$6, this, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RAW.class, $$$methodRef$$$6, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RAW.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            CharArrayReader charArrayReader;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, RAW.class, $$$methodRef$$$7, this, new Object[0]);
            }
            int n2 = (int)this.getLength();
            char[] cArray = new char[n2 * 2];
            byte[] byArray = this.shareBytes();
            DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
            CharArrayReader charArrayReader2 = charArrayReader = new CharArrayReader(cArray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, RAW.class, $$$methodRef$$$7, this, charArrayReader2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RAW.class, $$$methodRef$$$7, this, null);
            }
            return charArrayReader2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RAW.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            ByteArrayInputStream byteArrayInputStream;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, RAW.class, $$$methodRef$$$8, this, new Object[0]);
            }
            int n2 = (int)this.getLength();
            char[] cArray = new char[n2 * 2];
            byte[] byArray = this.shareBytes();
            DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
            byte[] byArray2 = new byte[n2 * 2];
            DBConversion.javaCharsToAsciiBytes(cArray, n2 * 2, byArray2);
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(byArray2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, RAW.class, $$$methodRef$$$8, this, byteArrayInputStream2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, RAW.class, $$$methodRef$$$8, this, null);
            }
            return byteArrayInputStream2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, RAW.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, RAW.class, $$$methodRef$$$9, this, new Object[0]);
            }
            InputStream inputStream = this.getStream();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, RAW.class, $$$methodRef$$$9, this, inputStream);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, RAW.class, $$$methodRef$$$9, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, RAW.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, RAW.class, $$$methodRef$$$10, this, n2);
            }
            byte[][] byArrayArray = new byte[n2][];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, RAW.class, $$$methodRef$$$10, this, byArrayArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, RAW.class, $$$methodRef$$$10, this, null);
            }
            return byArrayArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, RAW.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$14 = RAW.class.getDeclaredConstructor(Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = RAW.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = RAW.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = RAW.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = RAW.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = RAW.class.getDeclaredMethod("binaryStreamValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = RAW.class.getDeclaredMethod("asciiStreamValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = RAW.class.getDeclaredMethod("characterStreamValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = RAW.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = RAW.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = RAW.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = RAW.class.getDeclaredMethod("oldRAW", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = RAW.class.getDeclaredMethod("newRAW", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = RAW.class.getDeclaredMethod("hexString2Bytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = RAW.class.getDeclaredMethod("hexDigit2Nibble", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

