/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.sql.Connection;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.sql.DataSource;
import oracle.r2dbc.OracleR2dbcOptions;
import oracle.r2dbc.impl.OracleConnectionImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class OracleConnectionFactoryImpl
implements ConnectionFactory {
    private final DataSource dataSource;
    private final Executor executor;
    private final Duration statementTimeout;

    OracleConnectionFactoryImpl(ConnectionFactoryOptions options) {
        OracleR2dbcExceptions.requireNonNull(options, "options is null.");
        this.dataSource = ReactiveJdbcAdapter.getOracleAdapter().createDataSource(options);
        if (options.hasOption(ConnectionFactoryOptions.LOCK_WAIT_TIMEOUT)) {
            throw new UnsupportedOperationException("Unsupported Option: " + ConnectionFactoryOptions.LOCK_WAIT_TIMEOUT.name() + ". Oracle Database does not support a lock wait timeout session parameter.");
        }
        this.statementTimeout = Optional.ofNullable(options.getValue(ConnectionFactoryOptions.STATEMENT_TIMEOUT)).map(timeout -> timeout instanceof Duration ? (Duration)timeout : Duration.parse(timeout.toString())).orElse(Duration.ZERO);
        Object executor = options.getValue(OracleR2dbcOptions.EXECUTOR);
        if (executor == null) {
            this.executor = ForkJoinPool.commonPool();
        } else if (executor instanceof Executor) {
            this.executor = (Executor)executor;
        } else {
            throw new IllegalArgumentException("Value of " + OracleR2dbcOptions.EXECUTOR + " is not an instance of Executor: " + executor.getClass());
        }
    }

    public Publisher<io.r2dbc.spi.Connection> create() {
        return Mono.defer(() -> {
            ReactiveJdbcAdapter adapter = ReactiveJdbcAdapter.getOracleAdapter();
            return Mono.fromDirect(adapter.publishConnection(this.dataSource, this.executor)).flatMap(conn -> {
                OracleConnectionImpl connection = new OracleConnectionImpl((Connection)conn, adapter);
                return Mono.from(connection.setStatementTimeout(this.statementTimeout)).thenReturn((Object)connection);
            });
        });
    }

    public ConnectionFactoryMetadata getMetadata() {
        return () -> "Oracle Database";
    }
}

